/*
   dump - dumps individual records for analysis
   Copyright 1999-2001  Steve Grubb  <linux_4ever@yahoo.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published  by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>	/* for strcpy() */
#include <ctype.h>	/* For isprint */
#include <cole.h>


#define MODE 0			/* 0 - ascii;  1 - hex */
#define TEXT 1			/* In ascii mode, 0 - ascii, 1 - hex */

#define PRGNAME "dump"
#define MAX_COLS 64
#define MAX_ROWS 512

static char FileName[2][12] =			/* The section of the Excel Spreadsheet we read in */
{
	"/Workbook",		/* Office 97 */
	"/Book"			/* Everything else ? */
};

/* Used by cole_locate_filename() */
struct str_info {
	char *name;
	size_t size;
};

/* Function Prototypes */
COLE_LOCATE_ACTION_FUNC dump_file;
static void main_line_processor(int, char);
static void output_opcode_string(int);

/* Global data */
static char filename[128];


int main (int argc, char **argv)
{
	int f_ptr = 0;
	COLEFS * cfs;
	COLERRNO colerrno;

	/* To test cole_locate_filename() */
	struct str_info info;
	info.size = 108004;
	info.name =  FileName[f_ptr];


	if (argc < 2)
	{
		fprintf (stderr, "dump - Outputs excel file records for analysis.\n"
			"Usage: "PRGNAME" <FILE>\n");
		exit (1);
	}
	else
	{
		strncpy(filename, argv[1], 124);
		cfs = cole_mount (filename, &colerrno);
		if (cfs == NULL) 
		{
			cole_perror (PRGNAME, colerrno);
			exit (1);
		}
	}

	while (cole_locate_filename (cfs, FileName[f_ptr], &info, dump_file, &colerrno)) 
	{
		if (f_ptr)
		{
			cole_perror (PRGNAME, colerrno);
			break;
		}
		else
		{
			f_ptr++;
			info.name = FileName[f_ptr];
		}
	}

	if (cole_umount (cfs, &colerrno)) 
	{
		cole_perror ("travel", colerrno);
		exit (1);
	}
		
	return 0;
}


void dump_file(COLEDIRENT *cde, void *_info)
{
	unsigned int length=0, opcode=0, target=0, count = 0;
	unsigned char buf[16];
	COLEFILE *cf;
	COLERRNO err;
	
	cf = cole_fopen_direntry(cde, &err);	

	/* Ouput Header */
	printf("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n");
	printf("<HTML><HEAD><TITLE>%s", filename);	
	printf("</TITLE></HEAD><BODY>\n");	

/* Output body */
#if (MODE == 1)
	while (cole_fread(cf, buf, 8, &err)) /* For mode >= 1 */
#else
	while (cole_fread(cf, buf, 1, &err))
#endif	
	{
		if (MODE == 0)
		{
			if (count == 0)
			{
				length = 0;
				opcode = (unsigned)buf[0];
				target = 80;	/* ficticious number */
				printf("<br>");
			}
			else if (count == 1)
				opcode |= (buf[0]<<8)&0x0000FFFFL;
			else if (count == 2)
				length = (unsigned)buf[0];	
			else if (count == 3)
			{
				length |= (buf[0]<<8);
				target = length;
				printf("<br>\nLength:%04X Opcode:%04X - ", length, opcode);
				output_opcode_string(opcode);
				puts("<br>\n");
			}
			if (count > 3)
			{	/* Here is where we want to process the data */
				/* based on the opcode... */
#if (TEXT == 0)
				if (isprint(buf[0]))
					putc(buf[0], stdout);	
#else
				printf("%02X ", buf[0]);
				if (((count-3) % 8) == 0)
					printf("<br>\n");
#endif
			}		
			if (count == (target+3))
				count = 0;
			else		
				count++;	
		}
		else	/* mode >= 1 */
		{
			printf("%02x %02x %02x %02x %02x %02x %02x %02x &nbsp; &nbsp; &nbsp; &nbsp; ",
			  (unsigned)buf[0], (unsigned)buf[1], (unsigned)buf[2], (unsigned)buf[3], 
			  (unsigned)buf[4], (unsigned)buf[5], (unsigned)buf[6], (unsigned)buf[7]);
			  putchar(buf[0]); putchar(buf[1]); 
			  putchar(buf[2]); putchar(buf[3]); 
			  putchar(buf[4]); putchar(buf[5]); 
			  putchar(buf[6]); putchar(buf[7]);
			  printf("<br>\n");
		}
	}

/* Output Tail */
	printf("</BODY></HTML>\n");	
	cole_fclose(cf, &err);
}

static void main_line_processor(int opcode, char data)
{
}

static void output_opcode_string(int opcode)
{
	switch (opcode&0x00FF)
	{
		case 0x09:
			puts("\nBOF****************");
			break;
		case 0x2F:
			puts("FilePass");
			break;
		case 0x0B:
			puts("Index");
			break;
		case 0x0C:
			puts("Calc Count");
			break;
		case 0x0D:
			puts("Calc Mode");
			break;
		case 0x0E:
			puts("Precision");
			break;
		case 0x0F:
			puts("Ref Mode");
			break;
		case 0x10:
			puts("Delta");
			break;
		case 0x11:
			puts("Iteration");
			break;
		case 0x22:
			puts("1904");
			break;
		case 0x40:
			puts("Backup");
			break;
		case 0x2A:
			puts("Print Row Headers");
			break;
		case 0x2B:
			puts("Print Gridlines");
			break;
		case 0x1A:
			puts("Vertical Page Breaks");
			break;
		case 0x1B:
			puts("Horizontal Page Breaks");
			break;
		case 0x25:
			puts("Default Row Height");
			break;
		case 0x31:
			puts("Font");
			break;
		case 0x32:
			puts("Font2");
			break;
		case 0x14:
			puts("Header");
			break;
		case 0x15:
			puts("Footer");
			break;
		case 0x26:
			puts("Left Margin");
			break;
		case 0x27:
			puts("Right Margin");
			break;
		case 0x28:
			puts("Top Margin");
			break;
		case 0x29:
			puts("Bottom Margin");
			break;
		case 0x24:
			puts("Column Width");
			break;
		case 0x16:
			puts("External Count");
			break;
		case 0x17:
			puts("External Sheet");
			break;
		case 0x23:
			puts("External Name");
			break;
		case 0x1F:
			puts("Format Count");
			break;
		case 0x1E:
			puts("Format");
			break;
		case 0x18:
			puts("Name");
			break;
		case 0x00:
			puts("Dimensions");
			break;
		case 0x20:
			puts("Column Default");
			break;
		case 0x08:
			puts("Row");
			break;
		case 0x01:
			puts("Blank");
			break;
		case 0x02:
			puts("Integer");
			break;
		case 0x03:
			puts("Floating Point Number");
			break;
		case 0x04:
			puts("Label");
			break;
		case 0x05:
			puts("BoolErr");
			break;
		case 0x06:
			puts("Formula");
			break;
		case 0x21:
			puts("Array");
			break;
		case 0x3C:
			puts("Continue");
			break;
		case 0x07:
			puts("String");
			break;
		case 0x36:
			puts("Table");
			break;
		case 0x37:
			puts("Table 2");
			break;
		case 0x12:
			puts("Protect");
			break;
		case 0x19:
			puts("Window Protect");
			break;
		case 0x13:
			puts("Password");
			break;
		case 0x1C:
			puts("Note");
			break;
		case 0x3D:
			puts("Window1");
			break;
		case 0x3E:
			puts("Window2");
			break;
		case 0x41:
			puts("Pane");
			break;
		case 0x1D:
			puts("Selection");
			break;
		case 0x0A:
			puts("\nEOF~~~~~~~~~~~~~~~~~~~~~~~~");
			break;
		case 0xFC:
			puts("String Table Array");
			break;
		case 0xFD:
			puts("String Table Array to Location Record");
			break;
		case 0xD6:
			puts("RString");
			break;
		case 0x5C:
			puts("Write Access");
			break;
		case 0x85:
			puts("BoundSheet");
			break;
		case 0x7E:
			puts("RK Number");
			break;
		case 0xB8:
			puts("Hyperlink");
			break;
		case 0xBD:
			puts("Multiple RK Numbers");
			break;
		case 0xBC:		
			puts("Shared Formulas");
			break;
		case 0xBE:		 
			puts("Multiple Blanks");
			break;
		case 0xE0:
			puts("Extended Format");
			break;
		case 0x92:
			puts("Palette Info");
			break;
		case 0xA1:
			puts("Page Setup");
			break;
		case 0xFF:
			puts("Extended Shared String Table");
			break;
		case 0xE5:
			puts("Cell Merge Instructions");
			break;
		default:
			puts("Unknown Opcode");
			break;
	}
}

