/*
  Xinvest Copyright (c)1996, 2000 
  Mark Buser, All Rights Reserved.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xinvest, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 3.6 $ $Date: 2000/01/25 22:48:36 $
*/
#ifndef RATE_H
#define RATE_H

#include "nav.h"
#include "transP.h"

typedef struct {
  double div;
  double value;
  double yield;    /* yield over period */
  double annYield; /* yield annualized */
} YIELD;

#define CURRENT_DATE -1
#define FIRST_DATE    0
#define LAST_DATE     1

void rateAddTrans( TRANS *, int, double); /* Add one transaction to deposits  */
void rateClrTrans();                 /* Clear all deposits                    */
void rateClrAccount();               /* Clear all deposits                    */
double rate_IRR ( double );          /* IRR of deposits to reach parameter    */

double rate_datenum( int, long, long); /* number of days with transactions    */
double rate_fee( int, long, long);   /* Fees from 1st long date to second     */
double rate_value( int, long, long);
double rate_cost( int, long, long);
double rate_withdrawal( int, long, long);
double rate_distrib( int, long, long);
double rate_exch( int, long);       /* Exchange rate in effect                */
double rate_price( int, long);      /* Price including exchange rate          */
double rate_shares( int, long, long);
double rate_yield( int, long, long, YIELD *);
void   rate_add_account( int, long, long);

long convertDate (int, long);
char *daytostr ( long, char *);          /* Change (long)date to (char *)date */
long strtoday ( char * );                /* Change (char *)date to (long)date */
char *dbltostr (double, int);            /* Change double to char *.          */

#endif
