/*
 * markerlist.h
 *
 * $Id: markerlist.h,v 0.3 1999/07/13 17:31:34 thorsten Exp thorsten $
 *
 * This file is part of XGlobe. See README for details.
 *
 * Copyright (C) 1998 Thorsten Scheuermann
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licenses as published by
 * the Free Software Foundation.
 *
 * $Log: markerlist.h,v $
 * Revision 0.3  1999/07/13 17:31:34  thorsten
 * code beautification
 *
 * Revision 0.2  1999/02/12 17:18:57  thorsten
 * a color is now associated with each location marker
 *
 * Revision 0.1  1998/12/09 18:55:27  thorsten
 * initial revision
 *
 */

#ifndef _MARKERLIST_H
#define _MARKERLIST_H

#include <qstring.h>
#include <qlist.h>
#include <qcolor.h>

class Location
{
  friend class Renderer;
  
public:
  Location(double lon, double lat, const char *name, const QColor &color);
 ~Location() {}
  QString getName();
  double  getLongitude();
  double  getLatitude();
  QColor &getColor();

private:
  double  lon;
  double  lat;
  double  cos_angle;
  int     x, y;
  QString name;
  QColor  color;
};

/* ------------------------------------------------------------------------ */

class MarkerList
{
public:
  MarkerList() { list.setAutoDelete(TRUE); }
 ~MarkerList() { list.clear(); }
  inline void append(const Location *l) { list.append(l); }
  inline Location *first() { return list.first(); }
  inline Location *last() { return list.last(); }
  inline Location *next() { return list.next(); }
  inline Location *prev() { return list.prev(); }
  inline Location *current() { return list.current(); }
  inline uint count() { return list.count(); }
  inline void clear() { list.clear(); }
  
  bool loadMarkerFile(const char *filename);
  
protected:
  QList<Location> list;
};

#endif

