/*
 *
 * This file is part of the XForms library.
 *
 * XForms is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1, or
 * (at your option) any later version.
 *
 * XForms is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with XForms; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */


/*
 * $Id: tabfolder.h,v 0.88 1998/08/25 04:35:44 zhao Beta $
 *
 */
#ifndef FL_FOLDER_H
#define FL_FOLDER_H

enum
{
    FL_TOP_TABFOLDER,		/* tab on top */
    FL_BOTTOM_TABFOLDER,
    FL_LEFT_TABFOLDER,
    FL_RIGHT_TABFOLDER,
    FL_NORMAL_TABFOLDER = FL_TOP_TABFOLDER
};

enum
{
    FL_NO, FL_FIT, FL_ENLARGE_ONLY
};



FL_EXPORT FL_OBJECT *fl_create_tabfolder(int, FL_Coord, FL_Coord, FL_Coord,
					 FL_Coord, const char *);

FL_EXPORT FL_OBJECT *fl_add_tabfolder(int, FL_Coord, FL_Coord, FL_Coord,
				      FL_Coord, const char *);

FL_EXPORT FL_OBJECT *fl_addto_tabfolder(FL_OBJECT *, const char *, FL_FORM *);

FL_EXPORT FL_FORM *fl_get_tabfolder_folder_bynumber(FL_OBJECT *, int);
FL_EXPORT FL_FORM *fl_get_tabfolder_folder_byname(FL_OBJECT *, const char *);

FL_EXPORT void fl_delete_folder(FL_OBJECT *, FL_FORM *);
FL_EXPORT void fl_delete_folder_bynumber(FL_OBJECT *, int);
FL_EXPORT void fl_delete_folder_byname(FL_OBJECT *, const char *);

FL_EXPORT void fl_set_folder(FL_OBJECT *, FL_FORM *);
FL_EXPORT void fl_set_folder_byname(FL_OBJECT *, const char *);
FL_EXPORT void fl_set_folder_bynumber(FL_OBJECT *, int);


FL_EXPORT FL_FORM *fl_get_folder(FL_OBJECT *);
FL_EXPORT int fl_get_folder_number(FL_OBJECT *);
FL_EXPORT const char *fl_get_folder_name(FL_OBJECT *);
FL_EXPORT int fl_get_tabfolder_numfolders(FL_OBJECT *);

FL_EXPORT FL_FORM *fl_get_active_folder(FL_OBJECT *);
FL_EXPORT int fl_get_active_folder_number(FL_OBJECT *);
FL_EXPORT const char *fl_get_active_folder_name(FL_OBJECT *);

FL_EXPORT void fl_get_folder_area(FL_OBJECT *, FL_Coord *, FL_Coord *,
				  FL_Coord *, FL_Coord *);

FL_EXPORT void fl_replace_folder_bynumber(FL_OBJECT *, int, FL_FORM *);
FL_EXPORT int fl_set_tabfolder_autofit(FL_OBJECT *, int);
FL_EXPORT int fl_set_default_tabfolder_corner(int);	/* affects all */
FL_EXPORT int fl_get_tabfolder_offset(FL_OBJECT *);
FL_EXPORT int fl_set_tabfolder_offset(FL_OBJECT *, int);

#endif 
