/*
 *
 * This file is part of the XForms library.
 *
 * XForms is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1, or
 * (at your option) any later version.
 *
 * XForms is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with XForms; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */


/*
 * $Id: canvas.h,v 0.89 1999/07/17 03:17:52 zhao Beta $
 *
 * Header for FL_CANVAS
 *
 */

#ifndef FL_CANVAS_H_
#define FL_CANVAS_H_

typedef enum
{
    FL_NORMAL_CANVAS,
    FL_SCROLLED_CANVAS
}
FL_CANVAS_TYPE;


typedef int (*FL_HANDLE_CANVAS) (FL_OBJECT * ob,
				 Window,
				 int, int,
				 XEvent *, void *);

typedef int (*FL_MODIFY_CANVAS_PROP) (FL_OBJECT *);

/******************** Default *********************/

#define FL_CANVAS_BOXTYPE   FL_DOWN_BOX		/* really the decoration
						   frame */
#define FL_CANVAS_ALIGN     FL_ALIGN_TOP


/************ Interfaces    ************************/


FL_EXPORT FL_OBJECT *fl_create_generic_canvas(int, int, FL_Coord, FL_Coord,
					  FL_Coord, FL_Coord, const char *);

FL_EXPORT FL_OBJECT *fl_add_canvas(int, FL_Coord, FL_Coord, FL_Coord,
				   FL_Coord, const char *);

FL_EXPORT FL_OBJECT *fl_create_canvas(int, FL_Coord, FL_Coord, FL_Coord,
				      FL_Coord, const char *);

FL_EXPORT FL_OBJECT *fl_create_mesacanvas(int, FL_Coord, FL_Coord, FL_Coord,
					  FL_Coord, const char *);

FL_EXPORT FL_OBJECT *fl_add_mesacanvas(int, FL_Coord, FL_Coord, FL_Coord,
				       FL_Coord, const char *);


/* backward compatibility */
#define fl_set_canvas_decoration fl_set_object_boxtype

FL_EXPORT void fl_set_canvas_colormap(FL_OBJECT *, Colormap);
FL_EXPORT void fl_set_canvas_visual(FL_OBJECT *, Visual *);
FL_EXPORT void fl_set_canvas_depth(FL_OBJECT *, int);
FL_EXPORT void fl_set_canvas_attributes(FL_OBJECT *, unsigned,
					XSetWindowAttributes *);

FL_EXPORT FL_HANDLE_CANVAS fl_add_canvas_handler(FL_OBJECT *, int,
						 FL_HANDLE_CANVAS, void *);

FL_EXPORT Window fl_get_canvas_id(FL_OBJECT *);
FL_EXPORT Colormap fl_get_canvas_colormap(FL_OBJECT *);
FL_EXPORT int fl_get_canvas_depth(FL_OBJECT *);
FL_EXPORT void fl_remove_canvas_handler(FL_OBJECT *, int, FL_HANDLE_CANVAS);
FL_EXPORT void fl_hide_canvas(FL_OBJECT *);	/* internal use only */
FL_EXPORT void fl_canvas_yield_to_shortcut(FL_OBJECT *, int);
FL_EXPORT void fl_share_canvas_colormap(FL_OBJECT *, Colormap);
FL_EXPORT void fl_clear_canvas(FL_OBJECT * ob);
FL_EXPORT void fl_modify_canvas_prop(FL_OBJECT *,
				     FL_MODIFY_CANVAS_PROP,
				     FL_MODIFY_CANVAS_PROP,
				     FL_MODIFY_CANVAS_PROP);

/* OpenGL canvases */
FL_EXPORT FL_OBJECT *fl_create_glcanvas(int, FL_Coord, FL_Coord, FL_Coord,
					FL_Coord, const char *);

FL_EXPORT FL_OBJECT *fl_add_glcanvas(int, FL_Coord, FL_Coord, FL_Coord,
				     FL_Coord, const char *);

FL_EXPORT void fl_set_glcanvas_defaults(const int *);
FL_EXPORT void fl_get_glcanvas_defaults(int *);
FL_EXPORT void fl_set_glcanvas_attributes(FL_OBJECT *, const int *);
FL_EXPORT void fl_get_glcanvas_attributes(FL_OBJECT *, int *);
FL_EXPORT void fl_set_glcanvas_direct(FL_OBJECT *, int);
FL_EXPORT void fl_activate_glcanvas(FL_OBJECT *);
FL_EXPORT XVisualInfo *fl_get_glcanvas_xvisualinfo(FL_OBJECT *);


#if defined(__GLX_glx_h__) || defined(GLX_H)
FL_EXPORT GLXContext fl_get_glcanvas_context(FL_OBJECT * ob);
FL_EXPORT Window fl_glwincreate(int *, GLXContext *, int, int);
FL_EXPORT Window fl_glwinopen(int *, GLXContext *, int, int);
#endif

#endif
/****FL_CANVAS_H ******/
