/*
 *
 * This file is part of the XForms library.
 *
 * XForms is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1, or
 * (at your option) any later version.
 *
 * XForms is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with XForms; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 *
 */


/*
 * $Id: bitmap.h,v 0.89 1999/07/17 03:17:52 zhao Beta $
 *
 *   Object Class: Bitmap
 */
#ifndef FL_BITMAP_H
#define FL_BITMAP_H

#define    FL_NORMAL_BITMAP      0

/***** Defaults *****/

#define FL_BITMAP_BOXTYPE	FL_NO_BOX
#define FL_BITMAP_COL1		FL_COL1		/* background of bitmap */
#define FL_BITMAP_COL2		FL_COL1		/* not used currently   */
#define FL_BITMAP_LCOL		FL_LCOL		/* foreground of bitmap */
#define FL_BITMAP_ALIGN		FL_ALIGN_BOTTOM

/***** Routines *****/
FL_EXPORT FL_OBJECT *fl_create_bitmap(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				      const char *);
FL_EXPORT FL_OBJECT *fl_add_bitmap(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord, const char *);
FL_EXPORT void fl_set_bitmap_data(FL_OBJECT *, int, int, unsigned char *);
FL_EXPORT void fl_set_bitmap_file(FL_OBJECT *, const char *);
FL_EXPORT Pixmap fl_read_bitmapfile(Window, const char *,
				    unsigned *, unsigned *, int *, int *);

#define fl_create_from_bitmapdata(win, data, w, h)\
                   XCreateBitmapFromData(fl_get_display(), win, \
                   (char *)data, w, h)

/* for compatibility */
#define fl_set_bitmap_datafile fl_set_bitmap_file


/* PIXMAP stuff */

#define FL_NORMAL_PIXMAP   0

FL_EXPORT FL_OBJECT *fl_create_pixmap(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				      const char *);
FL_EXPORT FL_OBJECT *fl_add_pixmap(int, FL_Coord, FL_Coord, FL_Coord, FL_Coord,
				   const char *);

FL_EXPORT void fl_set_pixmap_data(FL_OBJECT *, char **);
FL_EXPORT void fl_set_pixmap_file(FL_OBJECT *, const char *);
FL_EXPORT void fl_set_pixmap_align(FL_OBJECT *, int, int, int);
FL_EXPORT void fl_set_pixmap_pixmap(FL_OBJECT *, Pixmap, Pixmap);
FL_EXPORT void fl_set_pixmap_colorcloseness(int, int, int);
FL_EXPORT void fl_free_pixmap_pixmap(FL_OBJECT *);
FL_EXPORT Pixmap fl_get_pixmap_pixmap(FL_OBJECT *, Pixmap *, Pixmap *);

FL_EXPORT Pixmap fl_read_pixmapfile(Window, const char *,
				    unsigned int *, unsigned int *,
				    Pixmap *, int *, int *, FL_COLOR);
FL_EXPORT Pixmap fl_create_from_pixmapdata(Window, char **,
					   unsigned int *, unsigned int *,
					   Pixmap *, int *, int *, FL_COLOR);
#define fl_free_pixmap(id)  do {if(id != None) XFreePixmap(fl_display, id);}while(0)

#endif
