/* $Id: connection.h,v 1.5 2002/01/05 07:53:11 cfreeze Exp $ */
/*******************************************************************************
 *   This program is part of a library used by the Archimedes email client     * 
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2002 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU Library General Public License as published *
 *   by the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU Library General Public License for more details.                      *
 *                                                                             *
 *   You should have received a copy of the GNU Library General Public License *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 ******************************************************************************/


#ifndef _CONNECTION_H_
#define _CONNECTION_H_

#include <fmail.h>
#include <config.h>
#include <umail.h>
#include <string>

#define CONNECTION_BUFFER 128

class connection {

public:

	connection(int psock, string phost);

	~connection();

	void disconnect();

	connection * get();

	string getHost();

	int getSock();

	char * getBuf();

	friend bool operator == (const connection & lhs, const connection & rhs);

private:
	int sock;           /* socket file descriptor */
	char buffer[CONNECTION_BUFFER];    /* socket buffer      */
	string host;    /* host name (IP addr)    */
};
#endif
