/* $Id: help.c,v 1.6 1999/12/13 08:46:56 xfmail Exp $ */

#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "help.h"

static int ready = 0;
static int last = 0;
static int lastnodes[10];

extern cfgfile Config;

FD_Help_Form *help_obj;

void help(int chapter) {
    int i, redisp = 0, show = 0;
    int w, h;

    if(ready) {
        fl_activate_form(help_obj->Help_Form);
        XRaiseWindow(fl_display, help_obj->Help_Form->window);
        redisp = 1;
    }

    ready = 1;

    if(!redisp)
        help_obj = create_form_Help_Form();
    fl_freeze_form(help_obj->Help_Form);

    fl_clear_browser(help_obj->Help_Browser);

    if(chapter == 0) {
        chapter++;
        show = 1;
    }

    i = chapter;

    while(strcmp(help_txt[i], "%END")) {
        if(help_txt[i][0] == '%') {
            if(show) {
                i++;
                fl_add_browser_line(help_obj->Help_Browser, " ");
                continue;
            } else {
                break;
            }
        }

        if(strlen(help_txt[i]) < 1)
            fl_add_browser_line(help_obj->Help_Browser, "@N");
        else
            fl_add_browser_line(help_obj->Help_Browser, help_txt[i]);
        i++;
    }

    fl_set_object_callback(help_obj->Help_Browser, Help_Browser_Call,
                           chapter);
    fl_unfreeze_form(help_obj->Help_Form);

    if(redisp)
        return;

    Config.setFlags("helpgeom", CF_NOTCHANGED);
    w = 500;
    h = 300;
    sscanf(Config.getCString("helpgeom", ""), "%d %d", &w, &h);
    if(main_form)
        fl_set_initial_placement(help_obj->Help_Form, main_form->x,
                                 main_form->y, w, h);
    else
        fl_set_form_size(help_obj->Help_Form, w, h);

    fl_set_form_minsize(help_obj->Help_Form, 400, 200);

    fl_show_form(help_obj->Help_Form, FL_PLACE_FREE, FL_TRANSIENT,
                 "Help for XFMail");

    return;
}

void cb_help_button(FL_OBJECT * obj, long param) {
    help(chapters[param]);

    return;
}

void Done_Help_Call(FL_OBJECT * obj, long param) {
    char geom[16];

    if(!ready)
        return;

    sprintf(geom, "%d %d", help_obj->Help_Form->w, help_obj->Help_Form->h);
    Config.set("helpgeom", geom);
    fl_hide_form(help_obj->Help_Form);
    fl_free_form(help_obj->Help_Form);
    fl_free(help_obj);
    help_obj = NULL;

    ready = 0;
    last = 0;
    return;
}

void Help_Browser_Call(FL_OBJECT * obj, long param) {
    int line = fl_get_browser(obj) + param;
    int i, link = 0;

    for(i = 0; i < NrOfLinks; i++)
        if(HelpLinks[i][0] == line) {
            link = HelpLinks[i][1];
            break;
        }

    if(last < 9)
        lastnodes[last++] = param;
    else {
        for(i = 0; i < 9; i++)
            lastnodes[i] = lastnodes[i + 1];
        lastnodes[9] = param;
    }

    if(link)
        help(link);
}

void Help_Top_Call(FL_OBJECT * obj, long param) {
    help(0);
}

void Help_Back_Call(FL_OBJECT * obj, long param) {
    if(last > 0) {
        last--;
        help(lastnodes[last]);
    }
}

void helpchapter(int chapter) {
    help(chapters[chapter]);
}
