#ifndef _CFGFILE_H_
#define _CFGFILE_H_

#include <config.h>
#include <fmail.h>
#include <umail.h>
#include <iostream.h>
#include <fstream.h>
#include <map>
#include <string>

#include <string>

#define SECFILEMODE 00600       /* secure mode on file */
#define HASHMINSIZE  128     /* don't make hash less then this */

#define GLOBAL_XFMAILRC "/etc/xfmailrc" /* global configuration file */
#define GLOBAL_XFDEFS   "/etc/xfdefaults"   /* global xfdefaults file */

typedef map<string, string> mapType;

class cfgfile {

public:

    cfgfile();

    int save(int ask);
    int save_file(char * file, int ask);
    int size();
    int sizeSaved();
    int load(char * fn);
    int check_version();
    void setFlags(char * ln,int flags);
    int getInt(string ln,int def);
    int getIntDefault(string ln, int def, int return_default);
    bool exist(string ln);
    void read_xfdefaults();
    bool set(string key, string val);
    bool set(string key, int val);
    bool set(string key, char * val);
    bool set(char * key, char * val);
    bool set(char *key, string val);
    bool set(char * key, int val);
    bool remove(char * key);
    bool remove(string key);
    char * getCString(string key, string def);
    char * getCString(char * key, char * def);
    string get(string key, string def);
    string get(char * key, char * def);
    char * getCStringDefault(string ln, string def, int return_default);
    char * getCStringDefault(char* ln, char * def, int return_default);
    string getString(string ln,string def);
    string getString(char * ln,char * def);
    string getStringDefault(char * ln, char * def, int return_default);
    string getStringDefault(string ln, string def, int return_default);

	void print();

private:

    unsigned int hash(char * cfgstr);
    bool add(string, string);
    string find(string);
    void addLine(char *);
    void clear();
    void destroy();
    void lock();
    void unlock();

    FILE *cfile;
    char fname[PLEN];
    int changedKeys;
    int changedFlags;

	int saved;

	mapType Map;

};

#endif
