#ifndef HISTINPUTDIALOG_H
#define HISTINPUTDIALOG_H

#include "DialogBox.h"

class XComApp;

class ComboBox : public FXComboBox
{
    FXDECLARE(ComboBox)
    ComboBox()
    {
        ;
    }
public:
    FXTextField *getTextEntry()
    {
        return field;
    }
    void CursorEnd()
    {
		field->onCmdCursorEnd(0,0,0);
        field->setFocus();
    }
    ComboBox(FXComposite *p,FXint cols,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0);
};

class HistInputDialog : public DialogBox
{
    FXDECLARE(HistInputDialog)
protected:
    FXVerticalFrame* contents;
    FXHorizontalFrame* buttons;
    FXHorizontalFrame* checkbutton;
    ComboBox *input;
    FXLabel*           label;
    FXDataTarget*      string_target;
private:
    HistInputDialog()
    {
        ;
    }
public:
    enum{
        ID_BROWSE_PATH=DialogBox::ID_LAST,
        ID_LAST
    };
    HistInputDialog(FXWindow*,FXString,FXString,FXString,FXString label="",FXIcon *ic=NULL, int option=0, FXString=FXString::null);
    virtual void create();
    long onCmdKeyPress(FXObject*,FXSelector,void*);
	long onCmdBrowsePath(FXObject*,FXSelector,void*);
    FXString getText()
    {
        return input->getText();
    }
	void setText(const FXString& text)
	{
		input->setText(text);
	}
    void CursorEnd();
    void SelectAll();
    void appendItem(char *str)
    {
        input->appendItem(str);
    };
    void clearItems()
    {
        input->clearItems();
    };
    FXString getHistoryItem(int pos)
    {
        return input->getItemText(pos);
    }
    int getHistorySize()
    {
        return input->getNumItems();
    }
};
#endif
