#ifndef XFILEIMAGE_H
#define XFILEIMAGE_H

class XFileImage : public FXMainWindow
{
    FXDECLARE(XFileImage)
protected:
	FXbool             hiddenfiles;           // Show or hide hidden files
	FXbool             thumbnails;            // Show or hide image thumbnails
	FXuint             fileview;              // File list view
	FXuint             iconview;              // Icon organization
    FXImageView       *imageview;             // Image viewer
    FXRecentFiles      mrufiles;              // Recent files
    FXString           filename;              // File being viewed
    FXMenuBar         *menubar;               // Menu bar
    FXToolBar         *toolbar;               // Tool bar
    FXToolBarShell    *dragshell1;            // Shell for floating menubar
    FXToolBarShell    *dragshell2;            // Shell for floating toolbar
    FXHorizontalFrame *statusbar;             // Status bar
    FXSplitter        *splitter;              // Splitter
    FXHorizontalFrame *filebox;               // Box containing directories/files
    FileList          *filelist;              // File List
	FXLabel			  *label;				  // Directory path
    FXMenuPane        *filemenu;              // File menu
    FXMenuPane        *viewmenu;              // View menu
    FXMenuPane        *helpmenu;              // Help menu
    FXMenuPane        *imagemenu;             // Image menu
    FXMenuPane        *prefsmenu;             // Preferences menu
    FXTextField       *filter;                // Filter for tree list
	FXImage			  *img;					  // Image loaded
	FXImage			  *tmpimg;				  // Temporary image
    FXColor 		  *tmpdata;				  // Temporary image data
	FXint			  indZoom;				  // Zoom index
	FXdouble		  zoomval;				  // Actual zoom factor					
protected:
    XFileImage()
    {}
public:
    long onCmdAbout(FXObject*,FXSelector,void*);
    long onCmdOpen(FXObject*,FXSelector,void*);
	long onCmdPrint(FXObject*,FXSelector,void*);
	long onCmdShowMini(FXObject*,FXSelector,void*);
 	long onCmdShowBig(FXObject*,FXSelector,void*);
 	long onCmdShowDetails(FXObject*,FXSelector,void*);
 	long onCmdShowRows(FXObject*,FXSelector,void*);
 	long onCmdShowCols(FXObject*,FXSelector,void*);
	long onCmdSave(FXObject*,FXSelector,void*);
    long onCmdQuit(FXObject*,FXSelector,void*);
    long onUpdTitle(FXObject*,FXSelector,void*);
    long onCmdFileList(FXObject*,FXSelector,void*);
    long onCmdRecentFile(FXObject*,FXSelector,void*);
    long onCmdRotate(FXObject*,FXSelector,void*);
    long onCmdMirror(FXObject*,FXSelector,void*);
    long onCmdZoomIn(FXObject*,FXSelector,void*);
    long onCmdZoomOut(FXObject*,FXSelector,void*);
    long onCmdZoom100(FXObject*,FXSelector,void*);
    long onCmdZoomWin(FXObject*,FXSelector,void*);
    long onUpdImage(FXObject*,FXSelector,void*);
	long onUpdFileView(FXObject* sender,FXSelector sel,void* ptr);
	long onUpdIconView(FXObject* sender,FXSelector sel,void* ptr);
	long onCmdToggleHidden(FXObject* sender,FXSelector sel,void* ptr);
	long onUpdToggleHidden(FXObject* sender,FXSelector sel,void* ptr);
	long onCmdToggleThumbnails(FXObject* sender,FXSelector sel,void* ptr);
	long onUpdToggleThumbnails(FXObject* sender,FXSelector sel,void* ptr);
	long onUpdLabel(FXObject*,FXSelector,void*);
public:
    enum{
        ID_ABOUT=FXMainWindow::ID_LAST,
        ID_OPEN,
		ID_LABEL,
		ID_TOGGLE_HIDDEN,
		ID_TOGGLE_THUMBNAILS,
		ID_SHOW_MINI,
		ID_SHOW_BIG,
		ID_SHOW_DETAILS,
		ID_COLS,
		ID_ROWS,
        ID_TITLE,
		ID_PRINT,
        ID_QUIT,
        ID_FILELIST,
        ID_RECENTFILE,
        ID_ROTATE_90,
        ID_ROTATE_270,
        ID_MIRROR_HOR,
        ID_MIRROR_VER,
        ID_SCALE,
        ID_ZOOM_IN,
        ID_ZOOM_OUT,
        ID_ZOOM_100,
        ID_ZOOM_WIN,
        ID_LAST
    };
public:
    XFileImage(FXApp* a);
    virtual void create();
    FXbool loadimage(const FXString& file);
	void saveConfig();
    void start(FXString starimage);
    virtual ~XFileImage();
};
#endif
