#ifndef XFILEEXPLORER_H
#define XFILEEXPLORER_H

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include "FileDict.h"
#include "FilePanel.h"
#include "InputDialog.h"
#include "Properties.h"
#include "DirPanel.h"
#include "Bookmarks.h"


// Helper function
void toolbarSeparator(FXToolBar*);

// Application object
class XFileExplorer : public FXMainWindow
{
    FXDECLARE(XFileExplorer)
    friend class FilePanel;
    friend class DirPanel;
protected:
	int rpanel_width;
	int rpanel_tree_width;
	enum
	{
		ONE_PANEL,
		TWO_PANELS,
		TREE_PANEL,
		TREE_TWO_PANELS
	};	
	int panel_view;
    int RunHistSize;
#define RUN_HIST_SIZE 15
    char RunHistory[RUN_HIST_SIZE][100];
    FXMenuPane		*leftviewmenu;
    FXMenuPane		*rightviewmenu;
    FXMenuTitle		*rmenutitle;
    FXMenuTitle		*lmenutitle;
    Bookmarks		*bookmarks;
	FXMenuBar		*menubar;
    FXToolBar		*toolbar;
    FXToolBar		*locationbar;
	FXComboBox		*address;
    FXStatusBar		*status;
    DirPanel		*dirpanel;
    FilePanel		*lpanel;
    FilePanel		*rpanel;
    FXString		target;
    FXString		sources;
    char			*opendir;
	FXString		xterm;
	FXString		trashlocation;
	FXuint			liststyle;
	FXint			xpos;
	FXint			ypos;
	FXuint			width;
	FXuint			height;
	FXColor			listbackcolor;
	FXColor			listforecolor;
public:
    enum{
        ID_ABOUT=FXMainWindow::ID_LAST,
		ID_HELP,
		ID_REFRESH,
		ID_EMPTY_TRASHCAN,
        ID_XTERM,
        ID_FILE_COPY,
        ID_FILE_RENAME,
        ID_FILE_MOVE,
        ID_FILE_COPYTO,
        ID_FILE_CUT,
        ID_FILE_SYMLINK,
        ID_FILE_DEL,
        ID_FILE_ASSOC,
		ID_CLEAR_LOCATION,
		ID_GOTO_LOCATION,
        ID_RUN,
        ID_PREFS,
        ID_DIR_BOX,
        ID_TOGGLE_STATUS,
		ID_SHOW_ONE_PANEL,
		ID_SHOW_TWO_PANELS,
		ID_SHOW_TREE_PANEL,
		ID_SHOW_TREE_TWO_PANELS,
        ID_RESTART,
        ID_NEW_WIN,
        ID_BOOKMARK,
        ID_ADD_BOOKMARK,
        ID_QUIT,
        ID_LAST
    };
public:
    XFileExplorer(FXApp *app=NULL,char *title = "X File Explorer",FXIcon *bigicon=NULL,FXIcon *miniicon=NULL);
    virtual void create();
    ~XFileExplorer();
    void saveConfig();
    FileDict *getAssociations()
    {
        return lpanel->current->list->getAssociations();
    }
    long onQuit(FXObject*,FXSelector,void*);
	long onKeyPress(FXObject*,FXSelector,void*);
	long onCmdHelp(FXObject*,FXSelector,void*);
    long onCmdAbout(FXObject*,FXSelector,void*);
    long onCmdFileAssoc(FXObject*,FXSelector,void*);
	long onCmdRefresh(FXObject*,FXSelector,void*);
    long onCmdToggleStatus(FXObject*,FXSelector,void*);
    long onCmdPopupMenu(FXObject*,FXSelector,void*);
    long onCmdPrefs(FXObject*,FXSelector,void*);
    long onCmdRun(FXObject*,FXSelector,void*);
    long onCmdXTerm(FXObject*,FXSelector,void*);
	long onCmdEmptyTrashcan(FXObject*,FXSelector,void*);
    long onCmdFileMan(FXObject*,FXSelector,void*);
	long onCmdShowPanels(FXObject*,FXSelector,void*);
    long onCmdRestart(FXObject*,FXSelector,void*);
	long onCmdNewWindow(FXObject*,FXSelector,void*);
    long onCmdBookmark(FXObject*,FXSelector,void*);
	long onCmdGotoLocation(FXObject*,FXSelector,void*);
	long onCmdClearLocation(FXObject*,FXSelector,void*);
    long onUpdToggleStatus(FXObject*,FXSelector,void*);
	long onUpdShowPanels(FXObject*,FXSelector,void*);
	long onUpdFileLocation(FXObject*,FXSelector,void*);
	long onUpdEmptyTrashcan(FXObject*,FXSelector,void*);
};
#endif
