#ifndef PREFERENCES_H
#define PREFERENCES_H

#include <string.h>

// Number of themes
#define THEMES_NUM 10


struct Theme
{
    char *name;
    FXColor color[8];
    Theme()
    {
        name = "";
    };
    Theme(const char *n,FXColor base=0,FXColor bdr=0,FXColor bg=0,FXColor fg=0,
	                    FXColor selbg=0,FXColor selfg=0, FXColor listbg=0, FXColor listfg=0)
    {
        name = strdup(n);
        color[0] = base;
        color[1] = bdr;
        color[2] = bg;
        color[3] = fg;
        color[4] = selbg;
        color[5] = selfg;
		color[6] = listbg;
		color[7] = listfg;
    };
    FXbool operator != (const Theme&);
};

class PreferencesBox : public FXDialogBox
{
    FXDECLARE(PreferencesBox)
private:
    PreferencesBox()
    {}
    FXButton   *cwell;
    FXComboBox *colorsBox;
    FXComboBox *themesBox;
    FXList     *themesList;
    FXTextField *iconpath;
    FXTextField *editor;
    FXTextField *viewer;
    FXTextField *xterm;
    FXTextField *normalfont;
    FXTextField *textfont;
    FXString    oldiconpath;
    FXString    oldeditor;
    FXString    oldviewer;
    FXString    oldxterm;
    FXString    oldnormalfont;
    FXString    oldtextfont;
    FXCheckButton  *autosave;
    FXCheckButton  *quit;
    FXCheckButton  *trashcan;
    FXCheckButton  *del;
    FXCheckButton  *overwrite;
    FXCheckButton  *ask;
    FXCheckButton  *bg;
    FXCheckButton  *root_warning;
    FXCheckButton  *mount;
	FXCheckButton  *show_mount;
    Theme          Themes[THEMES_NUM];
    Theme          currTheme;
public:
    enum{
        ID_ACCEPT=FXDialogBox::ID_LAST,
        ID_BROWSE_EDIT,
        ID_BROWSE_VIEW,
        ID_BROWSE_XTERM,
        ID_COLOR,
		ID_NORMALFONT,
		ID_TEXTFONT,
        ID_THEME,
        ID_BROWSE_ICON_PATH,
        ID_LAST
    };

public:
    PreferencesBox(FXWindow *win,FXColor listbackcolor=FXRGB(255,255,255), FXColor listforecolor=FXRGB(0,0,0));
    long onCmdAccept(FXObject*,FXSelector,void*);
    long onCmdBrowse(FXObject*,FXSelector,void*);
    long onCmdColor (FXObject*,FXSelector,void*);
    long onUpdColor (FXObject*,FXSelector,void*);
    long onCmdTheme (FXObject*,FXSelector,void*);
    long onCmdBrowsePath(FXObject*,FXSelector,void*);
	long onCmdNormalFont(FXObject*,FXSelector,void*);
	long onCmdTextFont(FXObject*,FXSelector,void*);
};
#endif
