/*  gxfce
 *  Copyright (C) 1999 Olivier Fourdan (fourdan@xfce.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/



#ifndef __XFCLOCK_CONFIG_H__
#define __XFCLOCK_CONFIG_H__

#include <gtk/gtk.h>

typedef struct 
  {
	int x;
	int y;
	int w;
	int h;
	gboolean calendar;
	gboolean menubar;
	gboolean digital;
	gboolean seconds;
	gboolean ampm;
	gboolean military;
	int back_red;
	int back_green;
	int back_blue;
	int fore_red;
	int fore_green;
	int fore_blue;
	char *font;
  } 
config;

config current_config;

extern config *initconfig  (config *conf);
extern void    writeconfig (GtkWidget *widget, config *conf);
extern void    readconfig  (config *conf);

#endif
