/* include file to hook skyviewmenu.c and skyhist.c together.
 */


/* history record */
#define	GRIDLEN		9	/* useable chars in grid size TF */
typedef struct {
    double fov;			/* sv_fov value */
    double azra;		/* sv_azra value */
    double altdec;		/* sv_altdec value */

    int dsmag, nsmag;		/* deep and near sky limiting mag */
    int magstp;			/* magnitude step size */

    int grid;			/* grid option */
    int autogrid;		/* auto grid option */
    int aagrid;			/* alt-az grid option */
    int fullgrid;		/* full grid option */
    char vgrid[GRIDLEN+1];	/* vertical grid size text */
    char hgrid[GRIDLEN+1];	/* vertical grid size text */

    int aa_mode;		/* aa_mode value */
    int flip_lr, flip_tb;	/* flip values */
    int justd; 			/* justdots option */
    int eclip, galac, eq;	/* ecliptic, galactic and equator options */
    int hznmap;			/* horizon map */
    int conn, conf, conb;	/* constellatin name, figures, boundaries opts*/
    int eyep;			/* eyepiece option */
    int magscale;		/* mag scale option */

    int lbl_n, lbl_m;		/* name/mags label options */
    int lbl_a, lbl_bd, lbl_bn;	/* all/deep/near label options */
    int lbl_f;			/* field-star label option */

    char type_table[NOBJTYPES];	/* copy of skyfilt's type table */
    char fclass_table[NCLASSES];/* copy of skyfilt's fclass table */
} SvHistory;


/* skyviewmenu.c */
extern void svh_goto P_((SvHistory *hp));
extern void svh_get P_((SvHistory *hp));


/* skyhist.c */
extern void svh_create P_((Widget mb));

/* For RCS Only -- Do Not Edit
 * @(#) $RCSfile: skyhist.h,v $ $Date: 1998/07/06 08:31:49 $ $Revision: 1.2 $ $Name:  $
 */
