/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jde.debugger.Application;
import jde.debugger.JDEException;
import jde.debugger.Protocol;
import jde.debugger.command.DebugCommandFactory;

public class Jdebug
extends Thread
implements Protocol {
    BufferedReader in;
    PrintWriter out;
    Map applications;
    private Collection pendingCommands;
    public static final Integer debuggerID = new Integer(-1);
    public static Jdebug theDebugger = new Jdebug();

    protected Jdebug() {
    }

    public void init() throws IOException {
        this.out = new PrintWriter(System.out);
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.applications = Collections.synchronizedMap(new HashMap());
        this.pendingCommands = Collections.synchronizedSet(new HashSet());
    }

    private void setSyntax(StreamTokenizer st) {
        st.resetSyntax();
        st.eolIsSignificant(true);
        st.whitespaceChars(0, 32);
        st.wordChars(33, 255);
        st.quoteChar(34);
    }

    /*
     * Loose catch block
     */
    public void run() {
        block21: {
            StreamTokenizer st = new StreamTokenizer(this.in);
            this.setSyntax(st);
            int ttype = st.nextToken();
            while (ttype != -1) {
                try {
                    List arguments;
                    String command;
                    Integer cmd_id;
                    ArrayList<String> commandLine = new ArrayList<String>();
                    while (ttype != 10) {
                        if (ttype == -1) {
                            throw new IOException("I/O EOF occured");
                        }
                        if (ttype == -3) {
                            commandLine.add(st.sval);
                        } else if (ttype == 34 || ttype == 39) {
                            commandLine.add(st.sval);
                        } else {
                            commandLine.add(String.valueOf((char)ttype));
                        }
                        ttype = st.nextToken();
                    }
                    if (commandLine.size() < 3) {
                        if (commandLine.size() > 0) {
                            this.signalCommandError(debuggerID, new Integer(-1), "Malformed command");
                        }
                        ttype = st.nextToken();
                        continue;
                    }
                    final Integer app_id = Integer.valueOf(commandLine.get(0).toString());
                    Thread cmd = DebugCommandFactory.theFactory.createCommand(app_id, cmd_id = Integer.valueOf(commandLine.get(1).toString()), command = commandLine.get(2).toString().toLowerCase(), arguments = commandLine.subList(3, commandLine.size()));
                    if (cmd == null) {
                        cmd = new Thread("Executing (" + app_id + "," + cmd_id + ")"){

                            public void run() {
                                Jdebug.this.handleAppCommand(app_id, cmd_id, command, arguments);
                            }
                        };
                    }
                    cmd.start();
                }
                catch (IOException ex) {
                }
                catch (Exception ex) {
                    this.signalCommandError(debuggerID, new Integer(-1), "Malformed command: " + ex.toString());
                }
                ttype = st.nextToken();
            }
            Object var10_12 = null;
            try {
                this.shutdown();
            }
            catch (Exception ex2) {}
            break block21;
            {
                catch (IOException ex) {
                    Object var10_13 = null;
                    try {
                        this.shutdown();
                    }
                    catch (Exception ex2) {}
                }
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    this.shutdown();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void handleAppCommand(Integer app_id, Integer cmd_id, String command, List arguments) {
        Application app;
        Map map = this.applications;
        synchronized (map) {
            if (!this.applications.containsKey(app_id)) {
                this.signalCommandError(debuggerID, cmd_id, "Application ID '" + app_id + "' does not exist");
                return;
            }
        }
        Map map2 = this.applications;
        synchronized (map2) {
            app = (Application)this.applications.get(app_id);
            if (app == null) {
                this.signalCommandError(debuggerID, cmd_id, "Application ID '" + app_id + "' does not correspond to a valid application");
            }
        }
        app.handleCommand(cmd_id, command, arguments);
    }

    public void addApplication(Integer appID, Application app) {
        Map map = this.applications;
        synchronized (map) {
            this.applications.put(appID, app);
        }
    }

    public void removeApplication(Integer app_id) {
        Map map = this.applications;
        synchronized (map) {
            this.applications.remove(app_id);
        }
    }

    public boolean appExists(Integer appID) {
        Map map = this.applications;
        synchronized (map) {
            boolean bl = this.applications.containsKey(appID);
            return bl;
        }
    }

    public Application getApplication(Integer appID) {
        Map map = this.applications;
        synchronized (map) {
            Application application = (Application)this.applications.get(appID);
            return application;
        }
    }

    public void addPendingCommand(Integer cmdID) {
        Collection collection = this.pendingCommands;
        synchronized (collection) {
            this.pendingCommands.add(cmdID);
        }
    }

    public void removePendingCommand(Integer cmdID) {
        Collection collection = this.pendingCommands;
        synchronized (collection) {
            this.pendingCommands.remove(cmdID);
        }
    }

    public boolean pendingCmdExists(Integer cmdID) {
        Collection collection = this.pendingCommands;
        synchronized (collection) {
            boolean bl = this.pendingCommands.contains(cmdID);
            return bl;
        }
    }

    public void shutdown() throws JDEException {
        Map map = this.applications;
        synchronized (map) {
            Iterator iterator = this.applications.values().iterator();
            while (iterator.hasNext()) {
                ((Application)iterator.next()).shutdown();
                iterator.remove();
            }
        }
    }

    public String stringRep(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return "\"" + obj.toString() + "\"";
        }
        if (obj instanceof List) {
            StringBuffer returnString = new StringBuffer("");
            Iterator it = ((List)obj).iterator();
            while (it.hasNext()) {
                returnString.append(this.stringRep(it.next()) + " ");
            }
            return Protocol.BR + returnString.toString().trim();
        }
        return obj.toString();
    }

    public synchronized void signal(Integer app_id, String type, Object obj) {
        String strRep = this.stringRep(obj);
        if (strRep.equals("")) {
            this.out.println(Protocol.BR + "(" + "jde-dbo-" + type + " " + app_id + ")" + Protocol.BR);
        } else {
            String temp = "(jde-dbo-" + type + Protocol.BR + app_id + " " + this.stringRep(obj) + ")";
            if (temp.length() <= 80) {
                this.out.println(Protocol.BR + "(" + "jde-dbo-" + type + " " + app_id + " " + this.stringRep(obj) + ")" + Protocol.BR);
            } else {
                this.out.println(Protocol.BR + temp + Protocol.BR);
            }
        }
        this.out.flush();
    }

    private synchronized void signalReply(Integer app_id, Integer cmd_id, Object obj, String type) {
        String strRep = this.stringRep(obj);
        if (strRep.equals("")) {
            this.out.println(Protocol.BR + "(" + type + " " + cmd_id + ")" + Protocol.BR);
        } else {
            String temp = "(" + type + Protocol.BR + cmd_id + " " + strRep + ")";
            if (temp.length() <= 80) {
                this.out.println(Protocol.BR + "(" + type + " " + cmd_id + " " + strRep + ")" + Protocol.BR);
            } else {
                this.out.println(Protocol.BR + temp + Protocol.BR);
            }
        }
        this.out.flush();
    }

    public void signalCommandResult(Integer app_id, Integer cmd_id) {
        this.signalCommandResult(app_id, cmd_id, null);
    }

    public void signalDebug(String msg) {
        this.signal(debuggerID, "message", msg);
    }

    public synchronized void signalCommandResult(Integer app_id, Integer cmd_id, Object obj) {
        this.signalReply(app_id, cmd_id, obj, "jde-dbo-command-result");
    }

    public synchronized void signalCommandError(Integer app_id, Integer cmd_id, Object obj) {
        this.signalReply(app_id, cmd_id, obj, "jde-dbo-command-error");
    }
}

