/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import bsh.EvalError;
import bsh.ExternalVars;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.util.Httpd;
import bsh.util.Sessiond;
import java.io.IOException;

public class Server
implements ExternalVars {
    int port;
    NameSpace globalNameSpace;

    public Server(int n, NameSpace nameSpace) {
        this.globalNameSpace = nameSpace;
        this.port = n;
    }

    private void error(String string) {
        System.err.println(string);
    }

    public Object getVariable(String string) {
        Object object = this.globalNameSpace.getVariable(string);
        if (object == Primitive.VOID) {
            return null;
        }
        if (object instanceof Primitive) {
            return ((Primitive)object).getValue();
        }
        return object;
    }

    public static void main(String[] stringArray) {
        Server server = new Server(Integer.parseInt(stringArray[0]), new Interpreter().getGlobalNameSpace());
        server.start();
    }

    public void setVariable(String string, float f) {
        try {
            this.globalNameSpace.setVariable(string, new Primitive(f));
        }
        catch (EvalError evalError) {
            this.error(evalError.toString());
        }
    }

    public void setVariable(String string, int n) {
        try {
            this.globalNameSpace.setVariable(string, new Primitive(n));
        }
        catch (EvalError evalError) {
            this.error(evalError.toString());
        }
    }

    public void setVariable(String string, Object object) {
        try {
            this.globalNameSpace.setVariable(string, object);
        }
        catch (EvalError evalError) {
            this.error(evalError.toString());
        }
    }

    public void setVariable(String string, boolean bl) {
        try {
            this.globalNameSpace.setVariable(string, new Primitive(bl));
        }
        catch (EvalError evalError) {
            this.error(evalError.toString());
        }
    }

    public void start() {
        try {
            new Httpd(this.port).start();
            new Sessiond(this.globalNameSpace, this.port + 1).start();
        }
        catch (IOException iOException) {
            System.err.println("bsh Server: IOException: " + iOException);
        }
    }
}

