/**********************************************

	X De Block !
		
	     game headers.
		
   *************************************************/

/* include system headers */

#include	<stdio.h>
#include	<stdlib.h>
#include        <stddef.h>

#include        <sys/time.h>

#include        <X11/Xlib.h>
#include        <X11/Xutil.h>
#include        <X11/Xos.h>
#include        <X11/keysym.h>
#include        <xpm.h>


#include	"defines.h"

#ifndef __GAMEHEADER_H__

#define __GAMEHEADER_H__

typedef unsigned char str32[33],str255[256];


typedef struct flgs
{
  long	res	       	:3,
        use_argv        :1,
        getMode         :1,
        s_map           :1,
        useContinue	:1,
        bloDlg 		:1,
        demoFlg		:1,
       	blockLock	:1,
        useWinOut	:1,
       	useEffect	:1,
       	wallThrough	:1,
       	blockPatchRL_2  :1,
       	blockPatchTB_2  :1,
/*       	useSound	:1,*/
       	hidePen		:1,
	clearAllMap	:1,
        blockPatchRL_1  :1,
       	blockPatchTB_1  :1,
       	pauseFlg	:1,
       	errPatch1	:1,
       	inputName	:1,
       	gameOverFlg	:1,
       	upData		:1,
       	clearString	:1,
       	saveFlg		:1,
       	timeFlg		:1,
       	openMap		:1,
       	backPicDraw	:1,
       	reDraw		:1,
       	reDraw2		:1,
       	life		:1;
}flgs;
		
typedef struct balls
{
  XRectangle	nowRect,
       		prevRect;
  short  	x_v,
         	y_v,
         	x_a,
         	y_a,
         	count,
       	 	prev_x,
       	 	prev_y,
       	 	prev2_x,
       	 	prev2_y;
  flgs	 	nowFlg;
}balls;

typedef struct blocks
{	
  XRectangle	nowRect;
  char   	nowStrong,
         	blockKind;
  short	 	blockPicID;
  flgs	 	nowFlg;
}blocks;	

typedef struct bars
{	
  XPoint        nowMPoint,
                prevMPoint;
  XRectangle   	nowRect,
                prevRect;
  char 		nowAct;
  int	       	bar_v;
  flgs 	        nowFlg;
}bars;

typedef struct items
{
  XRectangle	nowRect,
	       	prevRect;
  XPoint        nowPoint;
  char	       	itemKind;
  short	       	nowAnime;
  flgs	       	nowFlg;
}items;
	
typedef struct maps
{
  long		prevScore,
                myScore,
	       	gameSpeed,
	       	cpuWait,
                barColor,
                ballColor;
 struct timeval prevTime,
                nowTime;
  short		stageX_a,
                stageY_a,
	       	revFlg,
                s_map,
	       	backPicID,
	       	blockBox[dBlockMax+1],
	       	nowBlockNum,
	       	canBreakBlockNum,
	       	allBlockNum;
  char		PicOrPat,
       		continueCount,
       		mapNum,
       		itemNum,
       		mvItemBox[dItemMax+1],
       		mvBallNum,
       		allBallNum,
       		mvBallBox[dBallMax+1],
       		gameCount;
  str32       	playerName;
  str255        dirname,
                filename;
  flgs		nowFlg;
	
}maps;


 /****	file input output	****/

typedef struct fileblo
{
  XPoint        point;
  char 	        strong,
                kind;
  short	        picID;
}fileblo;

typedef struct xmapFileHeader
{
  char         allMapNumber,
               ballAdd;
  str32	       hiScoreName[10],
               createrName,
               clearAllMapText;
  short	       clearAllMapPicID;
  unsigned long	hiScore[10];
				
  char	       setFlgs;
  char	       timeCount;
  char	       cpuWait;
	
  long	       res3;
}xmapFileHeaderRec;


typedef struct xstage
{
  char	       PicOrPat,
               stageX_a,
               stageY_a;
  char      res1;
  short	       ballPatID,
               barPatID,
               allBlockNum,
               canBreakBlockNum,
               backPicID;
  short     res2;
  long	       minTime;
  str32	       minTimeName,
               startText;	
  short     res3;
}xstages;


/***  file buffer structures  ***/

typedef struct stage
{
  char		PicOrPat,
       		stageX_a,
       		stageY_a;
  short		ballPatID,
       		barPatID,
       		allBlockNum,
       		canBreakBlockNum,
       		backPicID,
       		barSndID,
       		blockSndID,
       		itemSndID,
       		wallSndID,
       		res2SndID,
       		res3SndID,
       		stageHiScore;
  long		minTime;
  str32		minTimeName,
       		startText;
 blocks		blockData[dBlockMax];
	
  char		res1;
  short		res2;
  long		res3;
      
}stages;


typedef struct mapFileData
{
  char	 	allMapNumber,
       	 	ballAdd;
  str32	 	hiScoreName[10],
       	 	createrName,
       	 	clearAllMapText;
  short	 	clearAllMapPicID;
  unsigned long	hiScore[10];
  stages 	stageData[dStageMax];
	
}mapFileRec, *mapFilePtr;


/***	all Data struct	****/

typedef	struct allData
{
  balls	  nowBall[dBallMax+1];
  blocks  nowBlock[dBlockMax+1];
  items	  nowItem[dItemMax+1];
  bars	  nowBar;
  maps	  nowMap;
}allDataRec, *allDataPtr, **allDataHdl;

#endif
			
	
	
