/********************************************

	X De Block! 
	
	   game Block check programs.
		
   ***********************************************/


#include	"gameheader.h"

extern Display     *display;                   /* global display      */
extern Window      mWin;                       /* global main window  */
extern GC          gc;                         /* global gc           */
extern Pixmap      offPixmap,backPicPixmap;    /* global offscreen pixmaps */
extern XFontStruct *xfont;                     /* global font         */
extern Colormap    cmap;                       /* global cmap         */

extern allDataRec  nowDataRec;
extern mapFilePtr  nowMapFile;
extern flgs   	   gameMainFlg;

extern XColor      black,white,red,rgb;

short	stacBloNum,stacWhere;

void breakCheckBlock();


void blockToBall(bloNum,ball)
     register bloNum,ball;
{
  register i;

  nowDataRec.nowMap.allBallNum++;
  if(nowDataRec.nowMap.allBallNum > dBallMax)
    {
      nowDataRec.nowMap.allBallNum--;
      return;
    }
  
  serveBall();
  
  i = nowDataRec.nowMap.mvBallBox[nowDataRec.nowMap.mvBallNum -1];
  
  nowDataRec.nowBall[i].nowRect  = nowDataRec.nowBlock[bloNum].nowRect;
  nowDataRec.nowBall[i].nowRect.width = nowDataRec.nowBall[ball].nowRect.width;
  nowDataRec.nowBall[i].nowRect.height = nowDataRec.nowBall[ball].nowRect.width;
  nowDataRec.nowBall[i].prevRect = nowDataRec.nowBall[ball].prevRect;
  nowDataRec.nowBall[i].x_v = -nowDataRec.nowBall[ball].x_v;
  nowDataRec.nowBall[i].y_v = -nowDataRec.nowBall[ball].y_v;
  nowDataRec.nowBall[i].x_a = nowDataRec.nowBall[ball].x_a;
  nowDataRec.nowBall[i].y_a = nowDataRec.nowBall[ball].y_a;
  nowDataRec.nowBall[i].x_v += 2*dBallWeight;
}


void setBlockLockFlg(bloNum)
     register bloNum;
{
  register	i;
	
  for(i^=i; i < nowDataRec.nowMap.allBlockNum; i++)
    if(nowDataRec.nowBlock[i].blockKind == 6)
      if((nowDataRec.nowBlock[i].blockPicID+10) 
	 == nowDataRec.nowBlock[bloNum].blockPicID)
	nowDataRec.nowBlock[i].nowFlg.blockLock = False;
}

void breakAroundBlocks(bloNum,balNum)
     register bloNum,balNum;
{
  register	bloTop,bloLeft,i;
  short		tempTop,tempLeft,initTop,initLeft;
	
  tempTop = nowDataRec.nowBlock[bloNum].nowRect.y + dBlockHeight;
  tempLeft = nowDataRec.nowBlock[bloNum].nowRect.x + dBlockWidth;
  initTop = nowDataRec.nowBlock[bloNum].nowRect.y - dBlockHeight;
  initLeft = nowDataRec.nowBlock[bloNum].nowRect.x - dBlockWidth;
	
	
  for(bloTop = initTop; bloTop <= tempTop; bloTop += dBlockHeight)
    for(bloLeft = initLeft; bloLeft <= tempLeft; bloLeft += dBlockWidth)
      for(i^=i; i < nowDataRec.nowMap.allBlockNum; i++)
	if(nowDataRec.nowBlock[i].nowFlg.life)
	  if((nowDataRec.nowBlock[i].nowRect.y == bloTop)
	     &&(nowDataRec.nowBlock[i].nowRect.x == bloLeft))
	    {
	      if(nowDataRec.nowBlock[i].blockKind == 8)
		{
		  if(bloTop == (initTop + dBlockHeight))
		    if(bloLeft == (initLeft + dBlockWidth))
		      break;
		  
		  nowDataRec.nowBlock[i].nowStrong = 1;
		  breakCheckBlock(i,balNum,0);
		}
	      else if(nowDataRec.nowBlock[i].blockKind < 20)
		{
		  nowDataRec.nowBlock[i].nowStrong = 1;
		  breakCheckBlock(i,balNum,0);
		  break;
		}
	      
	      nowDataRec.nowBlock[i].nowFlg.life = False;
	      nowDataRec.nowMap.nowBlockNum --;
	     	      
	      /***	draw OffPort (BackGroundPicture)	***/
	      
	      drawOff_Pic(&nowDataRec.nowBlock[i].nowRect);
	      
	      
	      /***	draw frontWindow	***/
	      
	      drawBack_Pic(&nowDataRec.nowBlock[i].nowRect);
	    }
}

char moveBlock(bloNum,balNum,where)
     register bloNum,balNum,where;
{	
  register     	bloTop,bloLeft,i;
  short	       	tempTop,tempLeft;
  XRectangle   	box;
	
	
  switch(where)
    {
    case dTop:
      tempTop = nowDataRec.nowBlock[bloNum].nowRect.y + dBlockHeight;
      tempLeft = nowDataRec.nowBlock[bloNum].nowRect.x;
      break;
      
    case dBottom:
      tempTop = nowDataRec.nowBlock[bloNum].nowRect.y - dBlockHeight;
      tempLeft = nowDataRec.nowBlock[bloNum].nowRect.x;
      if(tempTop < dWallTop)
	return(False);
      break;
      
    case dLeft:
      tempTop = nowDataRec.nowBlock[bloNum].nowRect.y;
      tempLeft = nowDataRec.nowBlock[bloNum].nowRect.x + dBlockWidth;
      if(tempLeft + dBlockWidth > dWallRight)
	return(False);
      break;
      
    case dRight:
      tempTop = nowDataRec.nowBlock[bloNum].nowRect.y;
      tempLeft = nowDataRec.nowBlock[bloNum].nowRect.x - dBlockWidth;
      if(tempLeft < dWallLeft)
	return(False);
      break;
    }
  
  /***	check around Blocks	***/
  
  for(i^=i; i < nowDataRec.nowMap.allBlockNum; i++)	
    if(nowDataRec.nowBlock[i].nowFlg.life)
      if((nowDataRec.nowBlock[i].nowRect.y == tempTop)
	 &&(nowDataRec.nowBlock[i].nowRect.x == tempLeft))
	{
	  if(nowDataRec.nowBlock[i].blockKind < 20)
	    {
	      nowDataRec.nowBlock[i].nowStrong = 1;
	      breakCheckBlock(i,balNum,10);
	    }
	  else if(nowDataRec.nowBlock[i].blockKind == 22)
	    if(moveBlock(i,balNum,where))
	      ;
	    else
	      return(False);
	  else
	    return(False);
	}

  if(nowDataRec.nowBlock[bloNum].nowFlg.life == False)
    return(True);
  
  box = nowDataRec.nowBlock[bloNum].nowRect;
  
  switch(where)
    {
    case dTop:
      nowDataRec.nowBlock[bloNum].nowRect.y += dBlockHeight;
      break;
      
    case dBottom:
      nowDataRec.nowBlock[bloNum].nowRect.y -= dBlockHeight;
      break;
      
    case dLeft:
      nowDataRec.nowBlock[bloNum].nowRect.x += dBlockWidth;
      break;
      
    case dRight:
      nowDataRec.nowBlock[bloNum].nowRect.x -= dBlockWidth;
      break;
    }
  
  
  /***	draw OffPort (BackGroundPicture)	***/
  
  drawOff_Blo(&box,&nowDataRec.nowBlock[bloNum].nowRect,
	      nowDataRec.nowBlock[bloNum].blockPicID);
  
  
  /***	draw frontWindow	***/
  
  drawBack_Pic(&box);
  drawBack_Off(&nowDataRec.nowBlock[bloNum].nowRect);
  
  return(True);
}

void breakCheckBlock(bloNum,balNum,score)
     register bloNum,balNum,score;
{
  register     	i,bloMax;
  register     	temp;
  char          text[8];

  
  nowDataRec.nowBlock[bloNum].nowStrong --;
  nowDataRec.nowMap.myScore += score;
  
  statScoreDraw();
  
  if(nowDataRec.nowBlock[bloNum].nowStrong < 1)
    {
      /*  broken block  */
      nowDataRec.nowBlock[bloNum].nowFlg.life = False;
      nowDataRec.nowMap.nowBlockNum --;
      nowDataRec.nowMap.canBreakBlockNum --;
			
      switch(nowDataRec.nowBlock[bloNum].blockKind)
	{
	case 5:
	  blockToBall(bloNum,balNum);
	  break;
	  
	case 7:
	  setBlockLockFlg(bloNum);
	  break;
	  
	case 8:
	  breakAroundBlocks(bloNum,balNum);
	  break;
	  
	case 30:
	  nowDataRec.nowMap.canBreakBlockNum = 0;
	  nowDataRec.nowMap.nowFlg.life      = False;
	  break;
	  
	case 39:
	  nowDataRec.nowMap.nowFlg.gameOverFlg = False;
	  nowDataRec.nowMap.nowFlg.life        = False;		
	  break;
	  
	}
      
      
      
      /***	draw OffPort (BackGroundPicture)	***/
      
      drawOff_Pic(&nowDataRec.nowBlock[bloNum].nowRect);
      
      /***	draw frontWindow	***/
      
      drawBack_Pic(&nowDataRec.nowBlock[bloNum].nowRect);
      
      /***	check left brocks	***/ 
      
      if(nowDataRec.nowMap.canBreakBlockNum < 1)
	{
	  /** Go next stage ! **/
	  nowDataRec.nowMap.nowFlg.life    = False;
	  nowDataRec.nowMap.nowFlg.saveFlg = True;
	  
	  if(nowMapFile->allMapNumber <= (nowDataRec.nowMap.mapNum+1))
	    {
	      nowDataRec.nowMap.nowFlg.clearAllMap = True;
	      nowDataRec.nowMap.nowFlg.gameOverFlg = False;
	      
	      return;
	    }
	}
      
      randomItem(bloNum);
      return;
    }
  
  /***	draw block Strong	****/
	
  drawBack_Off(&nowDataRec.nowBlock[bloNum].nowRect);
  sprintf(text,"%d",nowDataRec.nowBlock[bloNum].nowStrong);

  drawMiniText(display,mWin,
	   nowDataRec.nowBlock[bloNum].nowRect.x +18,
	   nowDataRec.nowBlock[bloNum].nowRect.y +2,
	   text,red.pixel,True);

}


/************************

  block Kinds	functions
  
  ************************/

int checkTouch(balNum,bloNum)
     register balNum,bloNum;
{
  register    temp_y,temp_x,tempLengh;

  temp_y = nowDataRec.nowBall[balNum].nowRect.y - nowDataRec.nowBlock[bloNum].nowRect.y;
  temp_x = nowDataRec.nowBall[balNum].nowRect.x - nowDataRec.nowBlock[bloNum].nowRect.x;
  tempLengh = nowDataRec.nowBall[balNum].nowRect.width - 2;
  
  if((temp_x >=-tempLengh)&&(temp_x <= dBlockWidth-3)&&
     (temp_y >=-tempLengh)&&(temp_y <= dBlockHeight-3))
    return(True);

  return(False);
}

void bloGraphNumber(balNum,bloNum,x,y)
     register balNum,bloNum;
     short    *x,*y;
{
  register tempLengh,x_slant,y_slant;

  tempLengh = nowDataRec.nowBall[balNum].nowRect.width - 2;
  
  *y = nowDataRec.nowBlock[bloNum].nowRect.y
       +(nowDataRec.nowBlock[bloNum].nowRect.height - tempLengh)/2;

  *x = nowDataRec.nowBlock[bloNum].nowRect.x
       +(nowDataRec.nowBlock[bloNum].nowRect.width - tempLengh)/2;
  
  *y = nowDataRec.nowBall[balNum].prev_y - *y;
  *x = nowDataRec.nowBall[balNum].prev_x - *x;
  
  x_slant = dBlockWidth-3 +tempLengh;
  y_slant = dBlockHeight-6 +tempLengh;
  
  *x = *x * y_slant /x_slant;
}

      
void checkBallLoop(balNum,bloNum)
     register balNum,bloNum;
{
  
  if(nowDataRec.nowBall[balNum].x_v == 0)
    if(nowDataRec.nowMap.blockBox[bloNum]++ > 5)
      {
	nowDataRec.nowBall[balNum].x_v += dBallWeight;
	nowDataRec.nowMap.blockBox[bloNum] = 0;
      }
  
  if(!(nowDataRec.nowBall[balNum].count++ % 20))
    {
      if(nowDataRec.nowBall[balNum].x_v > 0){
	if(nowDataRec.nowBall[balNum].x_v < 5 *dBallWeight)
	  nowDataRec.nowBall[balNum].x_v += dBallWeight;}
      else if(nowDataRec.nowBall[balNum].x_v > -5 *dBallWeight)
	nowDataRec.nowBall[balNum].x_v -= dBallWeight;
      
      if(nowDataRec.nowBall[balNum].count >60)
	{
	  nowDataRec.nowBall[balNum].x_v /=2;
	  nowDataRec.nowBall[balNum].count = 0;
	}
    }
      
  if(nowDataRec.nowBall[balNum].nowRect.y == nowDataRec.nowBall[balNum].prev_y)
    nowDataRec.nowBall[balNum].nowRect.y += nowDataRec.nowBall[balNum].y_v;

}

void blockKind_0(balNum,bloNum)
     register balNum,bloNum;
{
  register   temp_y,temp_x,tempLengh;
	
  temp_y = nowDataRec.nowBall[balNum].nowRect.y - nowDataRec.nowBlock[bloNum].nowRect.y;
  temp_x = nowDataRec.nowBall[balNum].nowRect.x - nowDataRec.nowBlock[bloNum].nowRect.x;
  tempLengh = nowDataRec.nowBall[balNum].nowRect.width /2;

  if((temp_x >-tempLengh)&&(temp_x < dBlockWidth)&&
     (temp_y >-tempLengh)&&(temp_y < dBlockHeight))
    {
      breakCheckBlock(bloNum,balNum,10);
    }
}


void blockKind_1(balNum,bloNum)
     register balNum,bloNum;
{
  short       temp_x,temp_y;
  
  if(!checkTouch(balNum,bloNum))
    return;
  
  bloGraphNumber(balNum,bloNum,&temp_x,&temp_y);
  
  if((temp_y >= temp_x)&&(temp_y >= -temp_x))
    {
      /****	touch block bottom	****/
      
      if(nowDataRec.nowBall[balNum].y_v > 0)
	return;
      if(gameMainFlg.blockPatchRL_1)
	return;
      
      nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      
      stacBloNum = bloNum;
      gameMainFlg.blockPatchTB_1 = True;
    }
  else if((temp_y >=temp_x)&&(temp_y < -temp_x))
    {
      /****	touch block left	****/
      
      if(nowDataRec.nowBall[balNum].x_v < 0)
	return;
      
      nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].x_v;
      
      breakCheckBlock(bloNum,balNum,10);
      
      if(gameMainFlg.blockPatchTB_1)
	nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      gameMainFlg.blockPatchRL_1 = True;
    }
  else if((temp_y < temp_x)&&(temp_y < -temp_x))
    {
      /****	touch block top 	****/
      
      if(nowDataRec.nowBall[balNum].y_v < 0)
	return;
      if(gameMainFlg.blockPatchRL_1)
	return;
      
      nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      
      stacBloNum = bloNum;				
      gameMainFlg.blockPatchTB_1 = True;
    }
  else if((temp_y < temp_x)&&(temp_y >= -temp_x))
    {
      /****	touch block right	****/
      
      if(nowDataRec.nowBall[balNum].x_v > 0)
	return;
      
      nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].x_v;
      
      breakCheckBlock(bloNum,balNum,10);
      
      if(gameMainFlg.blockPatchTB_1)
	nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      gameMainFlg.blockPatchRL_1 = True;
    }
}


void blockKind_3(balNum,bloNum)
     register balNum,bloNum;
{
  short       temp_y,temp_x;
  

  if(!checkTouch(balNum,bloNum))
    return;
  
  bloGraphNumber(balNum,bloNum,&temp_x,&temp_y);

      /****	check ball forever loop	****/
      
  checkBallLoop(balNum,bloNum);
      
      /****	where dose ball touch block ?	****/ 
		
  if((temp_y >= temp_x)&&(temp_y >= -temp_x))
    {
      /****	touch block bottom	****/
      
      if(nowDataRec.nowBall[balNum].y_v > 0)
	return;
      if(gameMainFlg.blockPatchRL_2)
	return;
      
      nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
            
      gameMainFlg.blockPatchTB_2 = True;
    }
  else if((temp_y >=temp_x)&&(temp_y < -temp_x))
    {
      /****	touch block left	****/
	  
      if(nowDataRec.nowBall[balNum].x_v < 0)
	return;
      
      nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].x_v;
            
      if(gameMainFlg.blockPatchTB_2)
	nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      gameMainFlg.blockPatchRL_2 = True;
    }
  else if((temp_y < temp_x)&&(temp_y < -temp_x))
    {
      /****	touch block top 	****/
      
      if(nowDataRec.nowBall[balNum].y_v < 0)
	return;
      if(gameMainFlg.blockPatchRL_1)
	return;
      if(gameMainFlg.blockPatchRL_2)
	return;
	  
      nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
	  
      stacBloNum = bloNum;				
      gameMainFlg.blockPatchTB_1 = True;
    }
  else if((temp_y < temp_x)&&(temp_y >= -temp_x))
    {
      /****	touch block right	****/
	  
      if(nowDataRec.nowBall[balNum].x_v > 0)
	return;
      
      nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].x_v;
		  
      if(gameMainFlg.blockPatchTB_2)
	nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      gameMainFlg.blockPatchRL_2 = True;
    }
}

void blockKind_4(balNum,bloNum)
     register balNum,bloNum;
{
  register    temp_y,temp_x,tempLengh,x_axis,y_axis;

  
  temp_y = nowDataRec.nowBall[balNum].nowRect.y - nowDataRec.nowBlock[bloNum].nowRect.y;
  temp_x = nowDataRec.nowBall[balNum].nowRect.x - nowDataRec.nowBlock[bloNum].nowRect.x;
  tempLengh = nowDataRec.nowBall[balNum].nowRect.width;
  
  if((temp_x >-(tempLengh*3/4))&&(temp_x <28)&&(temp_y >-(tempLengh*3/4))&&(temp_y <12))
    {
      
      x_axis = (dBlockHeight - tempLengh) / 2;
      y_axis = (dBlockWidth - tempLengh) / 2;
      
      if((temp_y >= x_axis)&&(temp_x >= y_axis))
	{
	  /****	touch block bottom right	****/
				
	  if((tempLengh = nowDataRec.nowBall[balNum].x_v) >= 0)
	    tempLengh = -8 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].x_v == 0)
	    nowDataRec.nowBall[balNum].y_v = -3 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].y_v < 0)
	    nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].y_v;
	  else
	    nowDataRec.nowBall[balNum].x_v = nowDataRec.nowBall[balNum].y_v;
	  
	  nowDataRec.nowBall[balNum].y_v = -tempLengh;
	  
	  breakCheckBlock(bloNum,balNum,20);
	}
      else if((temp_y >= x_axis)&&(temp_x < y_axis))
	{
	  /****	touch block bottom left 	****/
	  
	  
	  if((tempLengh = nowDataRec.nowBall[balNum].x_v) >= 0)
	    tempLengh = -8 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].x_v == 0)
	    nowDataRec.nowBall[balNum].y_v = -3 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].y_v < 0)
	    nowDataRec.nowBall[balNum].x_v = nowDataRec.nowBall[balNum].y_v;
	  else
	    nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].y_v;
	  
	  nowDataRec.nowBall[balNum].y_v = -tempLengh;
	  
	  breakCheckBlock(bloNum,balNum,20);
	  
	}
      else if((temp_y < x_axis)&&(temp_x >= y_axis))
	{
	  /****	touch block top right	****/
	  
	  if((tempLengh = nowDataRec.nowBall[balNum].x_v) >= 0)
	    tempLengh = -8 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].y_v < 0)
	    nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].y_v;
	  else
	    nowDataRec.nowBall[balNum].x_v = nowDataRec.nowBall[balNum].y_v;
	  
	  nowDataRec.nowBall[balNum].y_v = tempLengh;
	  
	  breakCheckBlock(bloNum,balNum,20);
	}
      else if((temp_y < x_axis)&&(temp_x < y_axis))
	{
	  /****	touch block top left	****/
	  
	  if((tempLengh = nowDataRec.nowBall[balNum].x_v) >= 0)
	    tempLengh = -8 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].y_v < 0)
	    nowDataRec.nowBall[balNum].x_v = nowDataRec.nowBall[balNum].y_v;
	  else
	    nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].y_v;
	  
	  nowDataRec.nowBall[balNum].y_v = tempLengh;
	  
	  breakCheckBlock(bloNum,balNum,20);
	}
    }
}


int blockKind_20(balNum,bloNum)
     register balNum,bloNum;
{
  short       temp_y,temp_x;
  

  if(!checkTouch(balNum,bloNum))
    return(False);
  
  bloGraphNumber(balNum,bloNum,&temp_x,&temp_y);

      /****	check ball forever loop	****/
      
  checkBallLoop(balNum,bloNum);
      
      /****	where dose ball touch block ?	****/ 
      
  if((temp_y >= temp_x)&&(temp_y >= -temp_x))
    {
      /****	touch block bottom	****/
      
      if(nowDataRec.nowBall[balNum].y_v > 0)
	return(False);
      
      if(gameMainFlg.blockPatchRL_2)
	return(False);
      
      nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
	  
      gameMainFlg.blockPatchTB_2 = True;
    }
  else if((temp_y >=temp_x)&&(temp_y < -temp_x))
    {
      /****	touch block left	****/
      
      if(nowDataRec.nowBall[balNum].x_v < 0)
	return(False);
	  
      nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].x_v;
      	  
      if(gameMainFlg.blockPatchTB_2)
	nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      gameMainFlg.blockPatchRL_2 = True;
    }
  else if((temp_y < temp_x)&&(temp_y < -temp_x))
    {
      /****	touch block top 	****/
      
      if(nowDataRec.nowBall[balNum].y_v < 0)
	return(False);
      if(gameMainFlg.blockPatchRL_2)
	return(False);
	  
      nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
	  
      gameMainFlg.blockPatchTB_2 = True;
    }
  else if((temp_y < temp_x)&&(temp_y >= -temp_x))
    {
      /****	touch block right	****/
	  
      if(nowDataRec.nowBall[balNum].x_v > 0)
	return(False);
	  
      nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].x_v;
		  
      if(gameMainFlg.blockPatchTB_2)
	nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      gameMainFlg.blockPatchRL_2 = True;
    }
  return(True);
}

void blockKind_21(balNum,bloNum)
     register balNum,bloNum;
{
  register    temp_y,temp_x,tempLengh,x_axis,y_axis;
  
  temp_y = nowDataRec.nowBall[balNum].nowRect.y - nowDataRec.nowBlock[bloNum].nowRect.y;
  temp_x = nowDataRec.nowBall[balNum].nowRect.x - nowDataRec.nowBlock[bloNum].nowRect.x;
  tempLengh = nowDataRec.nowBall[balNum].nowRect.width;
  
  if((temp_x >-(tempLengh*3/4))&&(temp_x <28)&&(temp_y >-(tempLengh*3/4))&&(temp_y <12))
    {
      
      x_axis = (dBlockHeight - tempLengh) / 2;
      y_axis = (dBlockWidth - tempLengh) / 2;
      
      if(nowDataRec.nowBall[balNum].x_v == 0)
	if(nowDataRec.nowMap.blockBox[bloNum]++ > 5)
	  {
	    nowDataRec.nowBall[balNum].x_v += dBallWeight;
	    nowDataRec.nowMap.blockBox[bloNum] = 0;
	  }

      if(!(nowDataRec.nowBall[balNum].count++ % 25))
	{
	  nowDataRec.nowBall[balNum].x_v /=2;				
	  
	  if(nowDataRec.nowBall[balNum].count >150)
	    {
	      nowDataRec.nowBall[balNum].y_v /=2;
	      nowDataRec.nowBall[balNum].count = 0;
	    }
	}
      
      
      if((temp_y >= x_axis)&&(temp_x >= y_axis))
	{
	  /****	touch block bottom right	****/
	  
	  if((tempLengh = nowDataRec.nowBall[balNum].x_v) >= 0)
	    tempLengh = -8 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].x_v == 0)
	    nowDataRec.nowBall[balNum].y_v = -3 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].y_v < 0)
	    nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].y_v;
	  else
	    nowDataRec.nowBall[balNum].x_v = nowDataRec.nowBall[balNum].y_v;
	  
	  nowDataRec.nowBall[balNum].y_v = -tempLengh;
	}
      else if((temp_y >= x_axis)&&(temp_x < y_axis))
	{
	  /****	touch block bottom left 	****/
	  
	  
	  if((tempLengh = nowDataRec.nowBall[balNum].x_v) >= 0)
	    tempLengh = -8 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].x_v == 0)
	    nowDataRec.nowBall[balNum].y_v = -3 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].y_v < 0)
	    nowDataRec.nowBall[balNum].x_v = nowDataRec.nowBall[balNum].y_v;
	  else
	    nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].y_v;
	  
	  nowDataRec.nowBall[balNum].y_v = -tempLengh;
	  
	}
      else if((temp_y < x_axis)&&(temp_x >= y_axis))
	{
	  /****	touch block top right	****/
	  
	  if((tempLengh = nowDataRec.nowBall[balNum].x_v) >= 0)
	    tempLengh = -8 *dBallWeight;

	  if(nowDataRec.nowBall[balNum].y_v < 0)
	    nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].y_v;
	  else
	    nowDataRec.nowBall[balNum].x_v = nowDataRec.nowBall[balNum].y_v;
	  
	  nowDataRec.nowBall[balNum].y_v = tempLengh;
	}
      else if((temp_y < x_axis)&&(temp_x < y_axis))
	{
	  /****	touch block top left	****/
	  
	  if((tempLengh = nowDataRec.nowBall[balNum].x_v) >= 0)
	    tempLengh = -8 *dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].y_v < 0)
	    nowDataRec.nowBall[balNum].x_v = nowDataRec.nowBall[balNum].y_v;
	  else
	    nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].y_v;
	  
	  nowDataRec.nowBall[balNum].y_v = tempLengh;
	}
    }
}

void blockKind_22(balNum,bloNum)
     register balNum,bloNum;
{
  short       temp_y,temp_x;
  

  if(!checkTouch(balNum,bloNum))
    return;
  
  bloGraphNumber(balNum,bloNum,&temp_x,&temp_y);

      /****	check ball forever loop	****/
      
  checkBallLoop(balNum,bloNum);
	

      /****   where dose ball touch block ?  ****/ 
  if((temp_y >= temp_x)&&(temp_y >= -temp_x))
    {
      /****	touch block bottom	****/
      
      if(nowDataRec.nowBall[balNum].y_v > 0)
	return;
      
      if(gameMainFlg.blockPatchRL_2)
	return;
      
      nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
	  
      moveBlock(bloNum,balNum,dBottom);
      
      gameMainFlg.blockPatchTB_2 = True;
    }
  else if((temp_y >=temp_x)&&(temp_y < -temp_x))
    {
      /****	touch block left	****/
      
      if(nowDataRec.nowBall[balNum].x_v < 0)
	return;
      
      nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].x_v;
	  
      moveBlock(bloNum,balNum,dLeft);
		  
      if(gameMainFlg.blockPatchTB_2)
	nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      gameMainFlg.blockPatchRL_2 = True;
    }
  else if((temp_y < temp_x)&&(temp_y < -temp_x))
    {
      /****	touch block top 	****/
      
      if(nowDataRec.nowBall[balNum].y_v < 0)
	return;
      if(gameMainFlg.blockPatchRL_2)
	return;
	  
      nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      
      moveBlock(bloNum,balNum,dTop);
		  
      gameMainFlg.blockPatchTB_2 = True;
    }
  else if((temp_y < temp_x)&&(temp_y >= -temp_x))
    {
      /****	touch block right	****/
      
      if(nowDataRec.nowBall[balNum].x_v > 0)
	return;
				
      nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].x_v;
	  
      moveBlock(bloNum,balNum,dRight);
		  
      if(gameMainFlg.blockPatchTB_2)
	nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      gameMainFlg.blockPatchRL_2 = True;
    }
}

void blockKind_23(balNum,bloNum)
     register balNum,bloNum;
{
  short       temp_y,temp_x;
  

  if(!checkTouch(balNum,bloNum))
    return;
  
  bloGraphNumber(balNum,bloNum,&temp_x,&temp_y);

      
  if((temp_y >=temp_x)&&(temp_y < -temp_x))
    {
      /****	touch block left	****/
      
      if(nowDataRec.nowBall[balNum].x_v < 0)
	return;
      
      nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].x_v;
      
      if(gameMainFlg.blockPatchTB_2)
	nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      gameMainFlg.blockPatchRL_2 = True;
	  
      if(nowDataRec.nowBall[balNum].x_v == 0)
	if(nowDataRec.nowMap.blockBox[bloNum]++ > 5)
	  {
	    nowDataRec.nowBall[balNum].x_v += dBallWeight;
	    nowDataRec.nowMap.blockBox[bloNum] = 0;
	  }
	  
      if(!(nowDataRec.nowBall[balNum].count++ % 25))
	{
	  if(nowDataRec.nowBall[balNum].x_v > 0){
	    if(nowDataRec.nowBall[balNum].x_v < 5 *dBallWeight)
	      nowDataRec.nowBall[balNum].x_v += dBallWeight;}
	      else if(nowDataRec.nowBall[balNum].x_v > -5 *dBallWeight)
		nowDataRec.nowBall[balNum].x_v -= dBallWeight;
	      
	  if(nowDataRec.nowBall[balNum].count >100)
	    {
	      nowDataRec.nowBall[balNum].x_v /=2;
	      nowDataRec.nowBall[balNum].count = 0;
	    }
	}
    }
  else
    nowDataRec.nowBall[balNum].x_v -= 2;
}

void blockKind_24(balNum,bloNum)
     register balNum,bloNum;
{
  short       temp_y,temp_x;
  

  if(!checkTouch(balNum,bloNum))
    return;
  
  bloGraphNumber(balNum,bloNum,&temp_x,&temp_y);
      
  if((temp_y < temp_x)&&(temp_y >= -temp_x))
    {
      /****	touch block right	****/
      
      if(nowDataRec.nowBall[balNum].x_v > 0)
	return;
      
      nowDataRec.nowBall[balNum].x_v = -nowDataRec.nowBall[balNum].x_v;
      
      if(gameMainFlg.blockPatchTB_2)
	nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      gameMainFlg.blockPatchRL_2 = True;
      
      if(nowDataRec.nowBall[balNum].x_v == 0)
	if(nowDataRec.nowMap.blockBox[bloNum]++ > 5)
	  {
	    nowDataRec.nowBall[balNum].x_v += dBallWeight;
	    nowDataRec.nowMap.blockBox[bloNum] = 0;
	  }
      
      if(!(nowDataRec.nowBall[balNum].count++ % 25))
	{
	  if(nowDataRec.nowBall[balNum].x_v > 0){
	    if(nowDataRec.nowBall[balNum].x_v < 5 *dBallWeight)
	      nowDataRec.nowBall[balNum].x_v += dBallWeight;}
	  else if(nowDataRec.nowBall[balNum].x_v > -5 *dBallWeight)
	    nowDataRec.nowBall[balNum].x_v -= dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].count >100)
	    {
	      nowDataRec.nowBall[balNum].x_v /=2;
	      nowDataRec.nowBall[balNum].count = 0;
	    }
	}
    }
  else
    nowDataRec.nowBall[balNum].x_v += 2;
      
}

void blockKind_25(balNum,bloNum)
     register balNum,bloNum;
{
  short       temp_y,temp_x;
  

  if(!checkTouch(balNum,bloNum))
    return;
  
  bloGraphNumber(balNum,bloNum,&temp_x,&temp_y);

      
  if((temp_y < temp_x)&&(temp_y < -temp_x))
    {
      /****	touch block top 	****/
      
      if(nowDataRec.nowBall[balNum].y_v < 0)
	return;
      if(gameMainFlg.blockPatchRL_2)
	return;
      
      nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      
      gameMainFlg.blockPatchTB_2 = True;
      
      if(nowDataRec.nowBall[balNum].x_v == 0)
	if(nowDataRec.nowMap.blockBox[bloNum]++ > 5)
	  {
	    nowDataRec.nowBall[balNum].x_v += dBallWeight;
	    nowDataRec.nowMap.blockBox[bloNum] = 0;
	  }
	  
      if(!(nowDataRec.nowBall[balNum].count++ % 25))
	{
	  if(nowDataRec.nowBall[balNum].x_v > 0){
	    if(nowDataRec.nowBall[balNum].x_v < 5 *dBallWeight)
	      nowDataRec.nowBall[balNum].x_v += dBallWeight;}
	  else if(nowDataRec.nowBall[balNum].x_v > -5 *dBallWeight)
	    nowDataRec.nowBall[balNum].x_v -= dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].count >100)
	    {
	      nowDataRec.nowBall[balNum].x_v /=2;
	      nowDataRec.nowBall[balNum].count = 0;
	    }
	}
    }
}

void blockKind_26(balNum,bloNum)
     register balNum,bloNum;
{
  short       temp_y,temp_x;
  

  if(!checkTouch(balNum,bloNum))
    return;
  
  bloGraphNumber(balNum,bloNum,&temp_x,&temp_y);
      
  if((temp_y >= temp_x)&&(temp_y >= -temp_x))
    {
      /****	touch block bottom	****/
      
      if(nowDataRec.nowBall[balNum].y_v > 0)
	return;
      
      if(gameMainFlg.blockPatchRL_2)
	return;
      
      nowDataRec.nowBall[balNum].y_v = -nowDataRec.nowBall[balNum].y_v;
      
      gameMainFlg.blockPatchTB_2 = True;
      
      if(nowDataRec.nowBall[balNum].x_v == 0)
	if(nowDataRec.nowMap.blockBox[bloNum]++ > 5)
	  {
	    nowDataRec.nowBall[balNum].x_v += dBallWeight;
	    nowDataRec.nowMap.blockBox[bloNum] = 0;
	  }
      
      if(!(nowDataRec.nowBall[balNum].count++ % 25))
	{
	  if(nowDataRec.nowBall[balNum].x_v > 0){
	    if(nowDataRec.nowBall[balNum].x_v < 5 *dBallWeight)
	      nowDataRec.nowBall[balNum].x_v += dBallWeight;}
	  else if(nowDataRec.nowBall[balNum].x_v > -5 *dBallWeight)
	    nowDataRec.nowBall[balNum].x_v -= dBallWeight;
	  
	  if(nowDataRec.nowBall[balNum].count >100)
	    {
	      nowDataRec.nowBall[balNum].x_v /=2;
	      nowDataRec.nowBall[balNum].count = 0;
	    }
	}
    }
}




/***********       end      ************/


void touchBallCheckBlock(void)
{
  register short	balNum,bloNum,balBox,mvBall,allBlock;
  
  mvBall   = nowDataRec.nowMap.mvBallNum;
  allBlock = nowDataRec.nowMap.allBlockNum;
  
  for(balBox^=balBox; balBox <mvBall; balBox++)
    {
      balNum = nowDataRec.nowMap.mvBallBox[balBox];
      
      gameMainFlg.blockPatchRL_1 = False;
      gameMainFlg.blockPatchTB_1 = False;	/*** use can breakBlock Kind**/
      gameMainFlg.blockPatchRL_2 = False;
      gameMainFlg.blockPatchTB_2 = False;	/*** use cannot breakBlock Kind	*/

      for(bloNum^=bloNum; bloNum < allBlock; bloNum++)
	if(nowDataRec.nowBlock[bloNum].nowFlg.life)	
	  switch(nowDataRec.nowBlock[bloNum].blockKind)
	    {
	    case 0:
	      blockKind_0(balNum,bloNum);
	      break;
	      
	    case 1:
	      blockKind_1(balNum,bloNum);
	      break;
	      
	    case 3:
	      blockKind_3(balNum,bloNum);
	      break;
	      
	    case 4:
	      blockKind_4(balNum,bloNum);
	      break;
	      
	    case 5:
	      blockKind_1(balNum,bloNum);
	      break;
	      
	    case 6:
	      if(nowDataRec.nowBlock[bloNum].nowFlg.blockLock)
		blockKind_20(balNum,bloNum);
	      else
		blockKind_1(balNum,bloNum);
	      break;
	      
	    case 7:
	      blockKind_1(balNum,bloNum);
	      break;
	      
	    case 8:
	      blockKind_1(balNum,bloNum);
	      break;
	      
	    case 30:
	      blockKind_1(balNum,bloNum);
	      break;
	      
	    case 20:
	      blockKind_20(balNum,bloNum);
	      break;
	      
	    case 21:
	      blockKind_21(balNum,bloNum);
	      break;
	      
	    case 22:
	      blockKind_22(balNum,bloNum);
	      break;
	      
	    case 23:
	      blockKind_23(balNum,bloNum);
	      break;
	      
	    case 24:
	      blockKind_24(balNum,bloNum);
	      break;
	      
	    case 25:
	      blockKind_25(balNum,bloNum);
	      break;
	      
	    case 26:
	      blockKind_26(balNum,bloNum);
	      break;	
	      
	    case 28:
	      if(blockKind_20(balNum,bloNum))
		 randomItem(bloNum);
	      break;
	      
	    case 39:
	      blockKind_1(balNum,bloNum);
	      break;
	      
	    case 40:
	      blockKind_1(balNum,bloNum);
	      break;
	    }
      
      if(gameMainFlg.blockPatchTB_1)
	if(gameMainFlg.blockPatchRL_1 == False)
	  breakCheckBlock(stacBloNum,balNum,10);
      
    }
}
