
/*********************************************

	X De Block!
	
		gamefile programs.
		
   ***************************************************/

#include	"gameheader.h"

extern Display     *display;                   /* global display      */
extern Window      mWin;                       /* global main window  */
extern GC          gc;                         /* global gc           */
extern Pixmap      offPixmap,backPicPixmap;    /* global offscreen pixmaps */
extern XFontStruct *xfont;                     /* global font         */
extern Colormap    cmap;                       /* global cmap         */

extern allDataRec  nowDataRec;
extern mapFilePtr  nowMapFile;
extern flgs   	   gameMainFlg;

static  xstages                 xmapStages;
static  xmapFileHeaderRec	xmapHeader;


void fileUpData(void)
{
  register	i,j;
  long 		headerLengh,stageLengh;
  fileblo      	xblo[dBlockMax];
  FILE          *fp;


  headerLengh = sizeof(xmapFileHeaderRec);
  stageLengh  = sizeof(xstages);

  if((fp = fopen(nowDataRec.nowMap.filename,"wb"))==NULL)
    {
      fprintf(stderr,"XDeBlock:cannot updata mapf = %s\n",
	      nowDataRec.nowMap.filename);
    }
  
  for(i = 0; i < 10; i++) 
    {
      strcpy(xmapHeader.hiScoreName[i],nowMapFile->hiScoreName[i]);
      xmapHeader.hiScoreName[i][32] = 0x00;
      xmapHeader.hiScore[i]         = nowMapFile->hiScore[i];
    }
	
  strcpy(xmapHeader.createrName,nowMapFile->createrName);
  strcpy(xmapHeader.clearAllMapText,nowMapFile->clearAllMapText);

  xmapHeader.createrName[32]     = 0x00;
  xmapHeader.clearAllMapText[32] = 0x00;

  xmapHeader.clearAllMapPicID	= nowMapFile->clearAllMapPicID;
  xmapHeader.allMapNumber     	= nowMapFile->allMapNumber;
  xmapHeader.ballAdd	       	= nowMapFile->ballAdd;
/*  xmapHeader.timeCount	= (char)nowDataRec.nowMap.gameSpeed;*/
  xmapHeader.cpuWait	       	= (char)nowDataRec.nowMap.cpuWait;
	
  gameMainFlg.useWinOut?(xmapHeader.setFlgs|=0xF1):(xmapHeader.setFlgs &=0xFE);
  gameMainFlg.useEffect?(xmapHeader.setFlgs|=0xF4):(xmapHeader.setFlgs &=0xFB);
  gameMainFlg.hidePen  ?(xmapHeader.setFlgs|=0xF8):(xmapHeader.setFlgs &=0xF7);
		
  fwrite(&xmapHeader,headerLengh,1,fp);

  for(i^=i; i < xmapHeader.allMapNumber; i++)
    {
      xmapStages.PicOrPat         = nowMapFile->stageData[i].PicOrPat;
      xmapStages.stageX_a         = nowMapFile->stageData[i].stageX_a;
      xmapStages.stageY_a         = nowMapFile->stageData[i].stageY_a;
      xmapStages.ballPatID        = nowMapFile->stageData[i].ballPatID;
      xmapStages.barPatID         = nowMapFile->stageData[i].barPatID;
      xmapStages.allBlockNum      = nowMapFile->stageData[i].allBlockNum;
      xmapStages.canBreakBlockNum = nowMapFile->stageData[i].canBreakBlockNum;
      xmapStages.backPicID        = nowMapFile->stageData[i].backPicID;
      xmapStages.minTime          = nowMapFile->stageData[i].minTime;
      
      strcpy(xmapStages.minTimeName,nowMapFile->stageData[i].minTimeName);
      strcpy(xmapStages.startText,  nowMapFile->stageData[i].startText);
      
      xmapStages.minTimeName[32] = 0x00;
      xmapStages.startText[32]   = 0x00;
      
      fwrite(&xmapStages,stageLengh,1,fp);
            
      for(j^=j; j < xmapStages.allBlockNum; j++)
	{
	  xblo[j].point.x = nowMapFile->stageData[i].blockData[j].nowRect.x;
	  xblo[j].point.y = nowMapFile->stageData[i].blockData[j].nowRect.y;
	  xblo[j].strong  = nowMapFile->stageData[i].blockData[j].nowStrong;
	  xblo[j].kind    = nowMapFile->stageData[i].blockData[j].blockKind;
	  xblo[j].picID   = nowMapFile->stageData[i].blockData[j].blockPicID;
	}
      
      fwrite(xblo,sizeof(fileblo),xmapStages.allBlockNum,fp);
    }

  fclose(fp);
}


void closeMapData(void)
{
  gameMainFlg.openMap = False;

}

int loadBinary(void)
{
  register     	i,j;
  long 		headerLengh,stageLengh,bloLengh;
  fileblo       *bloBuf;
  FILE          *fp;


  headerLengh = sizeof(xmapFileHeaderRec);
  stageLengh  = sizeof(xstages);

  /****     load mapfile    ****/

  if((fp = fopen(nowDataRec.nowMap.filename,"rb"))==NULL)
    {
      fprintf(stderr,"XDeBlock: cannot load mapf = %s\n",
	      nowDataRec.nowMap.filename);
      return(False);
    }

  fread(&xmapHeader,headerLengh,1,fp);

  for(i^=i; i < 10; i++) 
    {
      strcpy(nowMapFile->hiScoreName[i],xmapHeader.hiScoreName[i]);
      nowMapFile->hiScore[i] = xmapHeader.hiScore[i];
    }
	
  strcpy(nowMapFile->createrName,xmapHeader.createrName);
  strcpy(nowMapFile->clearAllMapText,xmapHeader.clearAllMapText);
		
  nowMapFile->clearAllMapPicID  = xmapHeader.clearAllMapPicID;
  nowMapFile->allMapNumber	= xmapHeader.allMapNumber;
  nowMapFile->ballAdd 		= xmapHeader.ballAdd;
/*  nowDataRec.nowMap.gameSpeed	= xmapHeader.timeCount;*/
  nowDataRec.nowMap.cpuWait	= xmapHeader.cpuWait;
  
  (xmapHeader.setFlgs &0x01)?(gameMainFlg.useWinOut=True):(gameMainFlg.useWinOut=False);
  (xmapHeader.setFlgs &0x04)?(gameMainFlg.useEffect=True):(gameMainFlg.useEffect=False);
  (xmapHeader.setFlgs &0x08)?(gameMainFlg.hidePen=True)  :(gameMainFlg.hidePen=False);
  
  for(i^=i; i < xmapHeader.allMapNumber; i++)
    {
      fread(&xmapStages,stageLengh,1,fp);
		
      nowMapFile->stageData[i].PicOrPat    = xmapStages.PicOrPat;
      nowMapFile->stageData[i].stageX_a    = xmapStages.stageX_a;
      nowMapFile->stageData[i].stageY_a    = xmapStages.stageY_a;
      nowMapFile->stageData[i].ballPatID   = xmapStages.ballPatID;
      nowMapFile->stageData[i].barPatID    = xmapStages.barPatID;
      nowMapFile->stageData[i].allBlockNum = xmapStages.allBlockNum;
      nowMapFile->stageData[i].canBreakBlockNum = xmapStages.canBreakBlockNum;
      nowMapFile->stageData[i].backPicID   = xmapStages.backPicID;
      nowMapFile->stageData[i].minTime     = xmapStages.minTime;

      strcpy(nowMapFile->stageData[i].minTimeName,xmapStages.minTimeName);
      strcpy(nowMapFile->stageData[i].startText,xmapStages.startText);
      
      bloLengh = sizeof(fileblo) *xmapStages.allBlockNum;
      bloBuf = malloc(bloLengh);

      fread(bloBuf,sizeof(fileblo),xmapStages.allBlockNum,fp);
      
      for(j^=j; j < xmapStages.allBlockNum; j++)
	{
	  nowMapFile->stageData[i].blockData[j].nowRect.x  = bloBuf[j].point.x;
	  nowMapFile->stageData[i].blockData[j].nowRect.y  = bloBuf[j].point.y;
	  nowMapFile->stageData[i].blockData[j].nowStrong  = bloBuf[j].strong;
	  nowMapFile->stageData[i].blockData[j].blockKind  = bloBuf[j].kind;
	  nowMapFile->stageData[i].blockData[j].blockPicID = bloBuf[j].picID;
	  
	  nowMapFile->stageData[i].blockData[j].nowRect.width  = dBlockWidth;
	  nowMapFile->stageData[i].blockData[j].nowRect.height = dBlockHeight;
	  
	}
      free(bloBuf);
    }
  fclose(fp);

  gameMainFlg.openMap = True;
  return(True);

}

void ftake_str(fp,txt)
     FILE  *fp;
     char  *txt;
{
  char ch;
  char stat = 0x01,flg = True;

  while(stat)
    {
      ch =(char)fgetc(fp);
      
      if(ch == '{'){
	stat |= 0x02;
	flg = False;}
      else if((stat == 0x03)&&(ch == '/')){
	stat |= 0x04;
	flg = False;}
      else if((stat == 0x07)&&(ch == '/')){
	stat |= 0x08;
	flg = False;}
      else if((stat & 0x0F)&&(ch == '}'))
	stat ^= stat;

      if((stat & 0x04)&&(!(stat & 0x08)))
	if(!flg)
	  flg = True;
	else
	  *(txt++) = ch;
    }

  *txt = 0x00;
}

int loadText(void)
{
  register     	i,j;
  fileblo      	xblo[dBlockMax];
  FILE          *fp;
  char          *txt;
  int           temp[32];

  /****     load mapfile    ****/

  if((fp = fopen(nowDataRec.nowMap.filename,"r"))==NULL)
    {
      fprintf(stderr,"XDeBlock: cannot load mapf = %s\n",
	      nowDataRec.nowMap.filename);
      return(False);
    }

  /** change name *.mapf.txt => *.mapf **/
  txt = strstr(nowDataRec.nowMap.filename,".txt");
  *txt = 0x00;

  for(i^=i; i < 10; i++) 
    {
      ftake_str(fp,xmapHeader.hiScoreName[i]);
      fscanf(fp,"%ld",&temp[0]);

      strcpy(nowMapFile->hiScoreName[i],xmapHeader.hiScoreName[i]);
      nowMapFile->hiScore[i] = temp[0];
    }
  ftake_str(fp,xmapHeader.createrName);
  ftake_str(fp,xmapHeader.clearAllMapText);
  
  strcpy(nowMapFile->createrName,xmapHeader.createrName);
  strcpy(nowMapFile->clearAllMapText,xmapHeader.clearAllMapText);

  fscanf(fp,"%d %d %d %ld %ld %d ",&temp[0],&temp[1],&temp[2],&temp[3],
	 &temp[4],&temp[5]);

  nowMapFile->clearAllMapPicID  = (short)temp[0];
  nowMapFile->allMapNumber	= (char)temp[1];
  nowMapFile->ballAdd 		= (char)temp[2];
/*  nowDataRec.nowMap.gameSpeed	= temp[3];*/
  nowDataRec.nowMap.cpuWait	= temp[4];
  xmapHeader.setFlgs            = (char)temp[5];

  (xmapHeader.setFlgs &0x01)?(gameMainFlg.useWinOut=True):(gameMainFlg.useWinOut=False);
  (xmapHeader.setFlgs &0x04)?(gameMainFlg.useEffect=True):(gameMainFlg.useEffect=False);
  (xmapHeader.setFlgs &0x08)?(gameMainFlg.hidePen=True)  :(gameMainFlg.hidePen=False);
  
  for(i^=i; i < nowMapFile->allMapNumber; i++)
    {
      fscanf(fp,"%d %d %d %d %d %d %d %d %ld ",&temp[0],&temp[1],&temp[2],
	     &temp[3],&temp[4],&temp[5],&temp[6],&temp[7],&temp[8]);

      nowMapFile->stageData[i].PicOrPat    = (char)temp[0];
      nowMapFile->stageData[i].stageX_a    = (char)temp[1];
      nowMapFile->stageData[i].stageY_a    = (char)temp[2];
      nowMapFile->stageData[i].ballPatID   = (short)temp[3];
      nowMapFile->stageData[i].barPatID    = (short)temp[4];
      nowMapFile->stageData[i].allBlockNum = (short)temp[5];
      nowMapFile->stageData[i].canBreakBlockNum = (short)temp[6];
      nowMapFile->stageData[i].backPicID   = (short)temp[7];
      nowMapFile->stageData[i].minTime     = temp[8];

      ftake_str(fp,xmapStages.minTimeName);
      ftake_str(fp,xmapStages.startText);
      
      strcpy(nowMapFile->stageData[i].minTimeName,xmapStages.minTimeName);
      strcpy(nowMapFile->stageData[i].startText,xmapStages.startText);
      
      
      for(j^=j; j < nowMapFile->stageData[i].allBlockNum; j++)
	{
	  fscanf(fp,"%d %d %d %d %d",&temp[0],&temp[1],&temp[2],
		 &temp[3],&temp[4]);

	  nowMapFile->stageData[i].blockData[j].nowRect.x  = (short)temp[0];
	  nowMapFile->stageData[i].blockData[j].nowRect.y  = (short)temp[1];
	  nowMapFile->stageData[i].blockData[j].nowStrong  = (char)temp[2];
	  nowMapFile->stageData[i].blockData[j].blockKind  = (char)temp[3];
	  nowMapFile->stageData[i].blockData[j].blockPicID = (short)temp[4];
	  
	  nowMapFile->stageData[i].blockData[j].nowRect.width  = dBlockWidth;
	  nowMapFile->stageData[i].blockData[j].nowRect.height = dBlockHeight;
	  
	}
    }
  fclose(fp);

  gameMainFlg.openMap = True;
  return(True);
}

int loadMapData(useGetFile)
     int  useGetFile;
{

  if(gameMainFlg.openMap)
	closeMapData();

  /****     select mapfile  ****/

  if(useGetFile)
    if(!selectFileDLG())
      return(False);

  /****     check mapfile name     ****/

#ifdef DEBUG
  printf("XDeBlock: Select File = %s\n",nowDataRec.nowMap.filename);
#endif

  if(strstr(nowDataRec.nowMap.filename,".mapf")==NULL)
    return(False);
  else if(strstr(nowDataRec.nowMap.filename,".txt")==NULL)
    return(loadBinary());
  else
    return(loadText());

}


void saveMapText(void)
{
  register	i,j;
  long 		headerLengh,stageLengh;
  fileblo      	xblo[dBlockMax];
  FILE          *fp;

  strcat(nowDataRec.nowMap.filename,".txt");

  if((fp = fopen(nowDataRec.nowMap.filename,"w"))==NULL)
    {
      fprintf(stderr,"XDeBlock:cannot save mapf = %s\n",
	      nowDataRec.nowMap.filename);
    }
  
  for(i = 0; i < 10; i++) 
    {
      strcpy(xmapHeader.hiScoreName[i],nowMapFile->hiScoreName[i]);
      xmapHeader.hiScoreName[i][32] = 0x00;
      xmapHeader.hiScore[i]         = nowMapFile->hiScore[i];
      
      fprintf(fp,"{/%s/} %ld \n",
	      xmapHeader.hiScoreName[i],xmapHeader.hiScore[i]);
    }
	
  strcpy(xmapHeader.createrName,nowMapFile->createrName);
  strcpy(xmapHeader.clearAllMapText,nowMapFile->clearAllMapText);
  xmapHeader.createrName[32]     = 0x00;
  xmapHeader.clearAllMapText[32] = 0x00;

  fprintf(fp,"{/%s/} {/%s/} \n",
	  xmapHeader.createrName,xmapHeader.clearAllMapText);

  xmapHeader.clearAllMapPicID	= nowMapFile->clearAllMapPicID;
  xmapHeader.allMapNumber     	= nowMapFile->allMapNumber;
  xmapHeader.ballAdd	       	= nowMapFile->ballAdd;
  xmapHeader.timeCount	= (char)nowDataRec.nowMap.gameSpeed;
  xmapHeader.cpuWait	       	= (char)nowDataRec.nowMap.cpuWait;
	
  gameMainFlg.useWinOut?(xmapHeader.setFlgs|=0xF1):(xmapHeader.setFlgs &=0xFE);
  gameMainFlg.useEffect?(xmapHeader.setFlgs|=0xF4):(xmapHeader.setFlgs &=0xFB);
  gameMainFlg.hidePen  ?(xmapHeader.setFlgs|=0xF8):(xmapHeader.setFlgs &=0xF7);
		
  fprintf(fp,"%d %d %d %ld %ld %d \n",xmapHeader.clearAllMapPicID,
	  xmapHeader.allMapNumber,xmapHeader.ballAdd,xmapHeader.timeCount,
	  xmapHeader.cpuWait,xmapHeader.setFlgs);

  for(i^=i; i < xmapHeader.allMapNumber; i++)
    {
      xmapStages.PicOrPat         = nowMapFile->stageData[i].PicOrPat;
      xmapStages.stageX_a         = nowMapFile->stageData[i].stageX_a;
      xmapStages.stageY_a         = nowMapFile->stageData[i].stageY_a;
      xmapStages.ballPatID        = nowMapFile->stageData[i].ballPatID;
      xmapStages.barPatID         = nowMapFile->stageData[i].barPatID;
      xmapStages.allBlockNum      = nowMapFile->stageData[i].allBlockNum;
      xmapStages.canBreakBlockNum = nowMapFile->stageData[i].canBreakBlockNum;
      xmapStages.backPicID        = nowMapFile->stageData[i].backPicID;
      xmapStages.minTime          = nowMapFile->stageData[i].minTime;
      
      fprintf(fp,"%d %d %d %d %d %d %d %d %ld \n",xmapStages.PicOrPat,
	      xmapStages.stageX_a,xmapStages.stageY_a,
	      xmapStages.ballPatID,xmapStages.barPatID,
	      xmapStages.allBlockNum,xmapStages.canBreakBlockNum,
	      xmapStages.backPicID,xmapStages.minTime);
      

      strcpy(xmapStages.minTimeName,nowMapFile->stageData[i].minTimeName);
      strcpy(xmapStages.startText,  nowMapFile->stageData[i].startText);  
      xmapStages.minTimeName[32] = 0x00;
      xmapStages.startText[32]   = 0x00;
      
      fprintf(fp,"{/%s/} {/%s/} \n",
	      xmapStages.minTimeName,xmapStages.startText); 

      for(j^=j; j < xmapStages.allBlockNum; j++)
	{
	  xblo[j].point.x = nowMapFile->stageData[i].blockData[j].nowRect.x;
	  xblo[j].point.y = nowMapFile->stageData[i].blockData[j].nowRect.y;
	  xblo[j].strong  = nowMapFile->stageData[i].blockData[j].nowStrong;
	  xblo[j].kind    = nowMapFile->stageData[i].blockData[j].blockKind;
	  xblo[j].picID   = nowMapFile->stageData[i].blockData[j].blockPicID;

	  fprintf(fp,"%d %d %d %d %d \n",xblo[j].point.x,xblo[j].point.y,
		  xblo[j].strong,xblo[j].kind,xblo[j].picID);
	}
    }

  fclose(fp);
}


void makeMapData(void)
{
  register	i,j;
  
  nowMapFile->allMapNumber = 3;
  
  for(i ^=i; i < 10; i++)
    {	
      strcpy(nowMapFile->hiScoreName[i],"pochi");
      nowMapFile->hiScore[i] = 1000 - 100*i;
      nowMapFile->hiScore[i] |= 0x01000000;
    }
  

  for(j = 0; j < nowMapFile->allMapNumber; j++)
    {
      nowMapFile->stageData[j].allBlockNum = 13;
      nowMapFile->stageData[j].minTime = 0;
      nowMapFile->stageData[j].stageHiScore = 0;
      nowMapFile->stageData[j].stageX_a  = 0;
      nowMapFile->stageData[j].stageY_a  = 0;
      nowMapFile->stageData[j].backPicID = 302 +j;
      
      strcpy(nowMapFile->stageData[j].startText,"let's play :-)");

      for(i =0; i <nowMapFile->stageData[j].allBlockNum; i++)
	{
	  setRect(&nowMapFile->stageData[j].blockData[i].nowRect,
		  dWallLeft+(dBlockWidth*i),dWallTop+(dBlockHeight*i),
		  dBlockWidth,dBlockHeight);
	  setRect(&nowMapFile->stageData[j].blockData[i+13].nowRect,
		  dWallLeft+(dBlockWidth*i),(dWallTop*2)+(dBlockHeight*i),
		  dBlockWidth,dBlockHeight);
	  setRect(&nowMapFile->stageData[j].blockData[i+26].nowRect,
		  dWallLeft+(dBlockWidth*i),(dWallTop*3)+(dBlockHeight*i),
		  dBlockWidth,dBlockHeight);
	  nowMapFile->stageData[j].blockData[i].nowStrong     = j+1;
	  nowMapFile->stageData[j].blockData[i+13].nowStrong  = j+1;
	  nowMapFile->stageData[j].blockData[i+26].nowStrong  = j+1;
	  nowMapFile->stageData[j].blockData[i].blockKind     = 1;
	  nowMapFile->stageData[j].blockData[i+13].blockKind  = 1;
	  nowMapFile->stageData[j].blockData[i+26].blockKind  = 1;
	  nowMapFile->stageData[j].blockData[i].blockPicID    = j;
	  nowMapFile->stageData[j].blockData[i+13].blockPicID = 1 + j;
	  nowMapFile->stageData[j].blockData[i+26].blockPicID = 2 + j;
	  
	  nowMapFile->stageData[j].blockData[i].nowFlg.life    = True;
	  nowMapFile->stageData[j].blockData[i+13].nowFlg.life = True;
	  nowMapFile->stageData[j].blockData[i+26].nowFlg.life = True;
	  
	}
      nowMapFile->stageData[j].allBlockNum      = 39;
      nowMapFile->stageData[j].canBreakBlockNum = 39;
    }


  nowMapFile->stageData[0].ballPatID = 1;
  nowMapFile->stageData[0].barPatID  = 2;
  nowMapFile->stageData[1].ballPatID = 2;
  nowMapFile->stageData[1].barPatID  = 3;

  
  strcpy(nowMapFile->clearAllMapText,"you are great !!");
  strcpy(nowMapFile->createrName,"oku");

  nowMapFile->clearAllMapPicID = 0;
  nowMapFile->ballAdd	       = 1;
}

void initStageData(j)
     register j;
{
  register	i;
  
  nowMapFile->stageData[j].allBlockNum      = 0;
  nowMapFile->stageData[j].canBreakBlockNum = 0;
  nowMapFile->stageData[j].minTime          = 0;
  nowMapFile->stageData[j].stageHiScore     = 0;
  nowMapFile->stageData[j].backPicID        = 0;
  nowMapFile->stageData[j].stageX_a         = 0;
  nowMapFile->stageData[j].stageY_a         = 0;
  
  strcpy(nowMapFile->stageData[j].startText,"Let's play XDeBlock !!");
  
  for(i =0; i < dBlockMax; i++) 
    {
      setRect(&nowMapFile->stageData[j].blockData[i].nowRect,
	      0,0,dBlockWidth,dBlockHeight);
      nowMapFile->stageData[j].blockData[i].nowStrong   = 1;
      nowMapFile->stageData[j].blockData[i].blockKind   = 1;
      nowMapFile->stageData[j].blockData[i].blockPicID  = 0;
      nowMapFile->stageData[j].blockData[i].nowFlg.life = False;
      
    }
  
  nowDataRec.nowMap.nowFlg.upData = True;
}

void clearBlocks(void)
{
  register	i,j,num;
  
  num = nowDataRec.nowMap.mapNum;

  for(i = 0; i < dBlockMax; i++)
    if(nowMapFile->stageData[num].blockData[i].nowFlg.life)
      nowMapFile->stageData[num].blockData[i].nowFlg.life = False;
  
  nowMapFile->stageData[num].allBlockNum      = 0;
  nowMapFile->stageData[num].canBreakBlockNum = 0;
}

void clearHiScore(void)
{
  register i;

  for(i ^=i; i < 10; i++)
    {	
      strcpy(nowMapFile->hiScoreName[i],"pochi");
      nowMapFile->hiScore[i] = 1000 - 100*i;
      nowMapFile->hiScore[i] |= 0x01000000 *(10-i);
    }
  
  for(i ^=i; i < nowMapFile->allMapNumber; i++)
    {
      nowMapFile->stageData[i].minTime = 0;
      strcpy(nowMapFile->stageData[i].minTimeName,"pochi");
    }

  fileUpData();
}
