#!/usr/bin/perl -w
#
# Convert bdf fonts to slanted style.
# Copyright (C) 1994-95 Cronyx Ltd.
# Author: Serge Vakulenko, <vak@cronyx.ru>
# Changes Copyright (C) 1995-1997 by Andrey A. Chernov, Moscow, Russia.
#
# This software may be used, modified, copied, distributed, and sold,
# in both source and binary form provided that the above copyright
# and these terms are retained. Under no circumstances is the author
# responsible for the proper functioning of this software, nor does
# the author assume any responsibility for damages incurred with its use.

$pattern{"0"} = "0000";
$pattern{"1"} = "0001";
$pattern{"2"} = "0010";
$pattern{"3"} = "0011";
$pattern{"4"} = "0100";
$pattern{"5"} = "0101";
$pattern{"6"} = "0110";
$pattern{"7"} = "0111";
$pattern{"8"} = "1000";
$pattern{"9"} = "1001";
$pattern{"a"} = "1010";         $pattern{"A"} = "1010";
$pattern{"b"} = "1011";         $pattern{"B"} = "1011";
$pattern{"c"} = "1100";         $pattern{"C"} = "1100";
$pattern{"d"} = "1101";         $pattern{"D"} = "1101";
$pattern{"e"} = "1110";         $pattern{"E"} = "1110";
$pattern{"f"} = "1111";         $pattern{"F"} = "1111";

$hexdig{"0000"} = "0";
$hexdig{"0001"} = "1";
$hexdig{"0010"} = "2";
$hexdig{"0011"} = "3";
$hexdig{"0100"} = "4";
$hexdig{"0101"} = "5";
$hexdig{"0110"} = "6";
$hexdig{"0111"} = "7";
$hexdig{"1000"} = "8";
$hexdig{"1001"} = "9";
$hexdig{"1010"} = "a";         $hexdig{"1010"} = "A";
$hexdig{"1011"} = "b";         $hexdig{"1011"} = "B";
$hexdig{"1100"} = "c";         $hexdig{"1100"} = "C";
$hexdig{"1101"} = "d";         $hexdig{"1101"} = "D";
$hexdig{"1110"} = "e";         $hexdig{"1110"} = "E";
$hexdig{"1111"} = "f";         $hexdig{"1111"} = "F";

$times_font = 0;

while (<>) {
	if (/^SLANT\s/) {
		if ($times_font) {
			s/"R"/"I"/;
		} else {
			s/"R"/"O"/;
		}
		print;
	} elsif (/^FONT\s/) {
		if (/Times/) {
			s/-R-/-I-/;
			$times_font = 1;
		} else {
			s/-R-/-O-/;
		}
		print;
	} elsif (/^FONTBOUNDINGBOX\s/) {
		@r = split;
		$h = $r[2];
		$w = $r[1] + int ($h/3);
		printf "FONTBOUNDINGBOX %d %d %d %d\n", $w, $h, $r[3]-1, $r[4];
	} elsif (/^CHARS\s/) {
		print;
		last;
	} else {
		print;
	}
}

while (<>) {
	if (/^STARTCHAR\s/) {
		print;
	} elsif (/^ENDCHAR/) {
		print;
	} elsif (/^ENCODING\s/) {
		print;
	} elsif (/^SWIDTH\s/) {
		print;
	} elsif (/^DWIDTH\s/) {
		print;
	} elsif (/^BBX\s/) {
		@r = split;
		$h = $r[2];
		$w = $r[1] + int ($h/3);
		printf "BBX %d %d %d %d\n", $w, $h, $r[3]-1, $r[4];
	} elsif (/^BITMAP/) {
		print "BITMAP\n";
		&makechar;
	}
}
print "ENDFONT\n";

sub makechar {
	for ($i=0; $i<$h; ++$i) {
		chop ($line = <>);
		@x = split (//, $line);
		@b = ();
		foreach $c (@x) {
			push (@b, split (//, $pattern{$c}));
		}
		for ($n=int($h/3); $n>0; --$n) {
			push (@b, '0');
		}
		push (@b, ('0','0','0','0','0','0','0'));
		for ($n=int(($h-$i)/3); $n>0; --$n) {
			unshift (@b, '0');
		}
		for ($n=2*int(($w+7)/8); $n>0; --$n) {
			@x = splice (@b, 0, 4);
			$c = join ('', @x);
			print $hexdig{$c};
		}
		print "\n";
	}
}
