using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Reflection;
using XCircuit.COM;

public class Test2
{
	[DllImport("XCIRCUIT.EXE", EntryPoint="xccom_get_application", CallingConvention=CallingConvention.Cdecl)]
	public static extern IXCircuit get_application();

	public static void XC_init()
	{
		IXCircuit app = get_application();
		Console.WriteLine("XCircuit app loaded");
		app.zoomout();

		app.autorefresh = false;

		IXCArc a = app.arc(0, 0, 100, 0.0f, 360.0f);
		a.set_color(System.Drawing.Color.Red.ToArgb() & 0x00ffffff);
		a.center.x += 100;

		IXCPolygon p = app.polygon(new object[8] { 0, 0, 100, 100, 200, 100, 200, 200 } );
		p.get_point(0).x = -100;

		app.autorefresh = true;
		app.refresh();
	}
}
