#!/bin/sh
#
# This script starts xcircuit under the Tcl interpreter,
# reading commands from a special .wishrc script which
# launches magic and retains the Tcl interactive interpreter.
#

loclibdir=${XCIRCUIT_LIB_DIR:=XCLIBDIR}
export XCIRCUIT_LIB_DIR
export XCIRCUIT_WISH=WISH_EXE

# Hacks for Cygwin
if [ ${TERM:=""} = "cygwin" ]; then
   export PATH=$PATH:TCLLIBDIR
   export DISPLAY=${DISPLAY:=":0"}
fi

TKCON=true
for i in $@ ; do
   case $i in
      -noc*) TKCON=;;
   esac
done

if [ $TKCON ]; then

   if [ ! -f ${loclibdir}/CONSOLE ]; then
      loclibdir=${loclibdir}/tcl
   fi

   exec ${loclibdir}/CONSOLE \
	-`eval' "source ${loclibdir}/CONSOLE_SCRIPT" \
        -slave "package require Tk; set argc $#; set argv [list $*]; \
        source ${loclibdir}/WRAPPER_INIT"
else

#
# Run the stand-in for wish (xcircexec), which acts exactly like "wish"
# except that it replaces ~/.wishrc with xcircuit.tcl.  This executable is
# *only* needed when running without the console; the console itself is
# capable of sourcing the startup script.
#
   exec ${loclibdir}/xcircexec -- $@

fi
