//  Copyright (C) 1998 by Jean-Marc Zucconi (jmz@FreeBSD.ORG)
//  Everyone is granted permission to copy, modify and redistribute.
//  This notice must be preserved on all copies or derivates.

#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <err.h>
#include <errno.h>
#include <stdio.h>
#include <sys/file.h>
#include <sys/cdio.h>
#include <math.h>
#include <sys/ioctl.h>
#include <stdarg.h>

#define DEVICE "cd0c"

void open_cd (), setvol (int), do_update (), read_toc (), play_msf (int, int, int),
    time_track (int, int, int), play_track (int), popup (int, int), 
    out (char *, ...);
int get_info ();

class button {
private:
    int state;
    char name[20];
public:
    button (char *s) {state=0; strcpy (name, s);}
    ~button () {}
    set (int i) {
	if (state != i) {
	    state = i;
	    if (state == 0)
		out (".%s configure -fg $fg", name);
	    else
		out (".%s configure -fg $active", name);
	}
    }
    int is_set () {return state;}
};


int cd_fd = -1;
char *device;
int current_track = 0, current_min = 0, current_sec = 0, current_frame = 0;
int last_in_toc = 0;
int time_btn = 0, track_btn = 0;

int linear = 0;

int animate = 1;
int v_animate = 0;

struct cd_toc_entry toc_buffer[100];

typedef enum {
    PLAY, STOP, PAUSE, EJECT, PREV, NEXT, REWIND, FF, 
    TRACK, TIME, VOLUME, UPDATE, QUIT, NONE
} command;

#define C(x) {#x, sizeof(#x)-1, x}
struct {
    char *s;
    int l;
    command cmd;
} clist[] = {
    C(PLAY),
    C(STOP), 
    C(PAUSE), 
    C(EJECT), 
    C(PREV), 
    C(NEXT), 
    C(REWIND), 
    C(FF), 
    C(TRACK), 
    C(TIME), 
    C(VOLUME),
    C(UPDATE),
    C(QUIT),
    {0, 0, NONE}
};

button play_button ("play"),  pause_button ("pause"), stop_button ("stop"),
    eject_button ("eject"), prev_button ("prev"),  next_button ("next"),
    rewind_button ("rewind"),  ff_button ("ff");

#define M(t) toc_buffer[t].addr.msf.minute
#define S(t) toc_buffer[t].addr.msf.second
#define F(t) toc_buffer[t].addr.msf.frame

main (int argc, char **argv)
{
    char dev[20], line[50];
    int i;
    char *a;

    if (argv[1] && !strcmp (argv[1], "-l")) {
	linear = 1;
	a = argv[2];
    } else 
	a = argv[1];
    if (!a)
	a = DEVICE;

    device = getenv ("CDPLAYER");
    if (!device)
	device = a;

    a = strchr (device, '/');
    if (!a && strlen (device) < 10) {
	sprintf (dev, "/dev/%s", device);
	device = dev;
    }
    while (fgets (line, 40, stdin)) {
	for (i = 0; clist[i].s; i++)
	    if (strncasecmp (clist[i].s, line, clist[i].l) == 0)
		break;
	i = clist[i].cmd;
	if ((cd_fd == -1) && (i != UPDATE) && (i != QUIT))
	    i = NONE;
	switch (i) {
	case UPDATE:
	    do_update ();
	    break;
	case PLAY:
	    if (play_button.is_set ())
		break;
	    play_track (1);
	    play_button.set (1);
	    break;
	case STOP:
	    if (play_button.is_set ()) {
		play_button.set (0);
		pause_button.set (0);
		ioctl (cd_fd, CDIOCSTOP);
		stop_button.set (1);
		time_track (-1, -1, -1);
	    }
	    break;
	case PAUSE: 
	    if (play_button.is_set ())
		if (!pause_button.is_set () && !ioctl (cd_fd, CDIOCPAUSE))
		    pause_button.set (1);
		else if (!ioctl (cd_fd, CDIOCRESUME))
		    pause_button.set (0);
	    break;
	case EJECT: 
	    if (!eject_button.is_set ()) {
		i = ioctl (cd_fd, CDIOCALLOW);
		if (!i)
		    i = ioctl (cd_fd, CDIOCEJECT);
		if (!i) {
		    eject_button.set (1);
		    play_button.set (0);
		    pause_button.set (0);
		    stop_button.set (0);
		    close (cd_fd);
		    cd_fd = -1;
		    last_in_toc = 0;
		    animate = 1;
		    v_animate = 0;
		}
	    }
	    break;
	case PREV: 
	    if (!play_button.is_set ())
		break;
	    get_info ();
	    if (current_sec > 2)
		play_track (current_track);
	    else
		play_track (current_track-1);
	    break;
	case NEXT: 
	    if (!play_button.is_set ())
		break;
	    play_track (current_track + 1);
	    break;
	case REWIND: 
	    if (atoi (line+clist[i].l) == 1)
		rewind_button.set (1);
	    else
		rewind_button.set (0);
	    break;
	case FF: 
	    if (atoi (line+clist[i].l) == 1)
		ff_button.set (1);
	    else
		ff_button.set (0);
	    break;
	case TRACK:
	    i = atoi (line+clist[i].l);
	    if (i == 2) {
		char *p = strchr (line, '.') + 1;
		i = atoi (p);
		p = strchr (p, '.') + 1;
		popup (i, atoi(p));
	    } else if (i < 0) 
		play_track (-i);
	    else
		track_btn = i;
	    break;
	case TIME: 
	    time_btn = atoi (line+clist[i].l);
	    break;
	case VOLUME:
	    setvol (atoi (line+clist[i].l));
	    break;
	case QUIT:
	    printf ("exit\n");
	    fflush (stdout);
	    sleep (3);
	    exit (0);
	default:
	    break;
	}
	printf ("after %d do_update\n", 
		play_button.is_set () && !pause_button.is_set () ? 100 : 200);
	fflush (stdout);
    }
    exit (0);
}

void
open_cd ()
{
    cd_fd = open (device, O_RDONLY); /* warning: this may take a long time */
    if (cd_fd < 0) {
	if (errno == ENXIO)
	    return; /* open says 'Device not configured' if there is no cd in */
	if (errno == EBUSY || EINVAL)
	    return; /* loading the CD? */
{FILE *f=fopen("/tmp/cdplayer.error", "w"); fprintf(f, "exiting with errno=%d\n", errno);}
	err (1, device);
    }
}
void
setvol (int l)
{
    struct ioc_vol v;

    l = linear ? int(l*2.55) : int(55.253*log(l+1.) +.01);
    v.vol[0] = l;
    v.vol[1] = l;
    v.vol[2] = 0;
    v.vol[3] = 0;
    ioctl (cd_fd, CDIOCSETVOL, &v);
}
int
get_info ()
{
    struct ioc_read_subchannel s;
    struct cd_sub_channel_info data;
    bzero(&s, sizeof(s));
    s.data = &data;
    s.data_len = sizeof (data);
    s.address_format = CD_MSF_FORMAT;
    s.data_format = CD_CURRENT_POSITION;
    ioctl (cd_fd, CDIOCREADSUBCHANNEL, (char *)&s);
    current_min = data.what.position.reladdr.msf.minute;
    current_sec = data.what.position.reladdr.msf.second;
    current_frame = data.what.position.reladdr.msf.frame;
    current_track = data.what.position.track_number;
    return data.header.audio_status;
}
void
do_update ()
{
    struct ioc_vol v;
    int i, vol;

    if (cd_fd < 0) {
	open_cd ();
	if (cd_fd < 0) {
	    eject_button.set (1);
	    time_track (0, 0, 0);
	    if (animate < 0) {
		v_animate -= 10;
		out ("set volume %d", v_animate);
		if (v_animate == 0)
		    animate = 1;
	    } else {
		v_animate += 10;
		out ("set volume %d", v_animate);
		if (v_animate == 100)
		    animate = -1;
	    }
	    return;
	}
	eject_button.set (0);
	read_toc ();
	if (get_info () == 18)
	    time_track (current_min, current_sec, current_track);
	else
	    time_track (-1, -1, -1);
	ioctl (cd_fd, CDIOCGETVOL, &v);
	vol = (v.vol[0]+v.vol[1])/2;
	vol = linear ? int(vol/2.55) : int (exp (vol/55.253) - 1);
	out ("set volume %d", vol);
    }
    if (play_button.is_set () && !pause_button.is_set () && 
	(rewind_button.is_set () || ff_button.is_set ())) {
	int f;
	f = (M(current_track-1) + current_min)*60*75
	    + (S(current_track-1) + current_sec)*75
	    + F(current_track-1) + current_frame
	    + (ff_button.is_set () ? 10*75 : -10*75);
	if ((f > M(0)*60*75 + S(0)*75 + F(0)) &&
	    (f < M(last_in_toc)*60*75 + S(last_in_toc)*75 + F(last_in_toc))) {
	    int m = f/(60*75);
	    int s = (f - m*60*75)/75;
	    f -=  m*60*75 + s*75;
	    play_msf (m, s, f);
	}
    }
    i = get_info ();
    switch (i) {
    case 17:
	stop_button.set (0);
	pause_button.set (0);
	play_button.set (1);
	if (track_btn)
	    time_track (-1, -1, -1);
	else if (time_btn) {
	    int i = (M(current_track) - M(current_track-1)) * 75*60 +
	    (S(current_track) - S(current_track-1)) *75 +
	    F(current_track) - F(current_track-1);

	    time_track (i/(60*75), (i-60*75*int(i/(60*75)))/75,	current_track);
	} else
	    time_track (current_min, current_sec, current_track);
	break;
    case 18:
	stop_button.set (0);
	play_button.set (1);
	pause_button.set (1);
	break;
    case 19:
	play_button.set (0);
	stop_button.set (1);
	time_track (-1, -1, -1);
	break;
    case 20:
    case 21:
	play_button.set (0);
	pause_button.set (0);
	stop_button.set (1);
	break;
    }
}
void
read_toc ()
{
    struct ioc_toc_header h;
    struct ioc_read_toc_entry t;
    int n;

    n = ioctl (cd_fd, CDIOREADTOCHEADER, (char *)&h);
    n =  h.ending_track - h.starting_track + 1;
    t.address_format = CD_MSF_FORMAT;
    t.starting_track = 1;
    t.data_len = (n+1)*sizeof(struct cd_toc_entry);
    t.data = toc_buffer;
    ioctl (cd_fd, CDIOREADTOCENTRYS, (char *)&t);
    toc_buffer[n].track = 255;
    last_in_toc = n;
}
void
time_track (int m, int s, int t)
{
    if (m != -1) 
	out ("set track %02d; set time %02d:%02d", t, m, s);
    else
	time_track (M(last_in_toc), S(last_in_toc), last_in_toc);
}
void
play_track (int start)
{
#if 0
    struct ioc_play_track t;

    if (start == 0 || start > last_in_toc)
	return;
    t.start_track = start;
    t.start_index = 1;
    t.end_track = last_in_toc;
    t.end_index = last_in_toc;
    ioctl (cd_fd, CDIOCPLAYTRACKS, &t);
#else
    start--;
    play_msf (M(start), S(start), F(start));
#endif
}
void
play_msf (int start_m, int start_s, int start_f)
{
    struct ioc_play_msf a;
    int i;

    a.start_m = start_m;
    a.start_s = start_s;
    a.start_f = start_f;
    i = M(last_in_toc)*60*75 + S(last_in_toc)*75 + F(last_in_toc) - 1;
    a.end_m = i/(60*75);
    a.end_s = (i - a.end_m*60*75)/75;
    a.end_f = i - a.end_s*75 - a.end_m*60*75;
    i=ioctl (cd_fd, CDIOCPLAYMSF, (char *)&a);
}
void 
out (char *fmt, ...)
{
    va_list ap;

    va_start (ap, fmt);
    vfprintf (stdout, fmt, ap);
    va_end (ap);
    putchar (';');
}
void
popup (int x, int y)
{
    int i, m, s, d;

    if (!last_in_toc)
	return;
    out ("if {[winfo exists .pop]} {destroy .pop}; menu .pop");
    for (i = 0; i < last_in_toc; i++) {
	d = (M(i+1)-M(i))*60*75 + (S(i+1)-S(i))*75 + F(i+1)-F(i);
	m = d/(60*75);
	s = (d - m*60*75)/75;
	out (".pop add command -label {%2d    %02d:%02d} -command \"cmd track %d\"", i+1, m, s, -i-1);
    }
    out ("tk_popup .pop %d %d", x, y);
}

