/*
 *
 *   Xbreaky: A breakout game for X11
 *
 *   Copyright (C) 2000  Dave Brul
 *   
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *
 *   Coded by Dave Brul  <davebrul@hotmail.com>
 */

#include <stdio.h>
#include <malloc.h>
#include <unistd.h>
#include <stdlib.h>
#include <getopt.h>
#include <fcntl.h>
#include <string.h>
#include <strings.h>
#include <signal.h>
#include <sys/soundcard.h>
#include <sys/ioctl.h>

#define DEFAULT_DSP_SPEED 8000
#define AUDIO "/dev/dsp"
#define RAWFILESDIR PREFIX"/share/games/xbreaky"

int timelimit = 0, dsp_speed = DEFAULT_DSP_SPEED, dsp_stereo = 0;
int samplesize = 8;
int audio, abuf_size;
char *audiobuf, c;
char *names[]={ RAWFILESDIR"/catch.raw",
                RAWFILESDIR"/fire.raw"  };

void play (char *name);
void quit ();


int main (int argc, char *argv[])
{ 
  int tmp;
  int i;
  char k;

  signal(SIGTERM, quit);   
  fcntl(STDIN_FILENO,F_SETFL,O_NONBLOCK);
  audio = open (AUDIO, O_WRONLY, 0);
  if (audio == -1)
  {
   perror (AUDIO);
   exit (-1);
  }

  tmp = samplesize;
  ioctl(audio, SNDCTL_DSP_SAMPLESIZE, &samplesize);
  if (tmp != samplesize)
  {
   fprintf(stderr, "xbreaky.snd: Unable to set the sample size\n");
   exit(-1);
  }

  if (ioctl (audio, SNDCTL_DSP_STEREO, &dsp_stereo)==-1)
  {
   fprintf (stderr, "xbreaky.snd: Unable to set mono/stereo\n");
   perror (AUDIO);
   exit (-1);
  }

  if (ioctl (audio, SNDCTL_DSP_SPEED, &dsp_speed) == -1)
  {
   fprintf (stderr, "xbreaky.snd: Unable to set audio speed\n");
   perror (AUDIO);
   exit (-1);
  }
  
  ioctl (audio, SNDCTL_DSP_GETBLKSIZE, &abuf_size);
  
  if ((audiobuf = malloc (abuf_size)) == NULL)
  {
   fprintf (stderr, "Unable to allocate input/output buffer\n");
   exit (-1);
  }

  
  for(;;)
  {
   i=read(STDIN_FILENO, &k, sizeof(k));
   if(i==0)  
   {   
    kill(getpid(), SIGTERM);
   }
   if(i!=-1)  
   { 
    play(names[(int)k]);
   }
  }    

  close (audio);
  return 0;
}


void play (char *name)
{
  int fd, l;

  int count, c;

  if (!timelimit)
    count = 0x7fffffff;
  else
  {
   count = timelimit * dsp_speed;
   if (dsp_stereo || samplesize != 8) count *= 2;
  }
  if ((fd = open (name, O_RDONLY, 0)) == -1)
  {
   perror (name);
   exit (-1);
  }
  while (count)
  {
   c = count;
   if (c > abuf_size) c = abuf_size;
   if ((l = read (fd, audiobuf, c)) > 0)
   {
    if (write (audio, audiobuf, l) != l)
    {
     perror (AUDIO);
     exit (-1);
    }
    count -= l;
   }
   else
   {
    if (l == -1)
    {
     perror (name);
     exit (-1);
    }
    count = 0;	
   }
  }			
  if (fd != 0) close (fd);
} 

 
void quit ()
{
  exit (0);
}   
