#ifndef XARCHIVE_SRC_MAIN
#define XARCHIVE_SRC_MAIN 1

#include"common.h"
#include<stdio.h>
#include<unistd.h>
#include<string.h>
#include<dirent.h>
#include<fnmatch.h>
#include<gtk/gtk.h>
#include<glib/gstdio.h>
#include<sys/wait.h>

/* LOCAL DATA TYPES AND STRUCTURES */
typedef struct wrapper_entry
{
    gchar *path;
    GPtrArray *ext_array;
} WrapperEntry;

/* LOCAL GLOBAL VARIABLES */
GPtrArray *WRAPPER_ARRAY = NULL;
extern GtkWidget *MAIN_WINDOW;

/* EXTERNAL FUNCTIONS */
/* from my_strescape.c */
gchar *
my_strescape(gchar *string);

/* from widgets_gtk.c */
GtkTreeView *
get_current_tree(void);

gint 
make_widgets(ParsedArgs *pargs);

void 
add_row(GtkListStore *liststore, gchar **ent);

gboolean
message(GtkWidget *parentwin, gint type, gchar *text);

void
setup_opening_progress_bar(GtkWidget *pbwin, GtkWidget *pbar, 
                           gboolean *stopit);

void
wait_with_progress_bar(GPid pid, gint *wrapper_status, gint ar_func);

/* LOCAL FUNCTIONS */
void 
setup_exts(WrapperEntry *wrapd);

WrapperEntry *
make_wrapper(gchar *dir, gchar *fname);

int 
is_wrapper(const struct dirent *dirent);

void 
setup_wrappers(void);

extern gchar * 
wrapper_info(void);

gchar *
get_wrapper(gchar *archive);

gint 
get_archive_data(gchar **arg);

gint 
wrapper_cmd(gint af, gchar **argv, gchar *dest);

void
setup_home_directory(void);

ParsedArgs *
parse_options(gint argc, gchar *argv[]);

#endif
