/*
 * resolv.c : Program to test if you need -lresolv to ensure DNS
 *	      hostname lookups.
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 *
 * Compile with: cc -o resolv resolv.c
 *
 * If you get an error message when you run the program, you need -lresolv.
 *
 * 24 Aug 1993: Use perror() rather than herror().
 */

#include <stdio.h>
#include <netdb.h>

main(argc,argv)
int argc;
char *argv[];
{
    char *hostname = "archie.ans.net";
    char *addr;
    struct hostent *host;
    int i;

    if (argc > 1)
	hostname = argv[1];
    if((host=gethostbyname(hostname)) == NULL) {
	/* Not everyone has herror() */
        perror(hostname);
        exit(1);
    } else {
	if (strcmp(hostname,host->h_name) != 0)
	    printf("%s has official name %s\n",hostname,host->h_name);
	for (i=0; host->h_aliases[i]; i++)
	    if (strcmp(hostname,host->h_aliases[i]) != 0)
		printf("%s has alias %s\n",hostname,host->h_aliases[i]);
	for (i=0; host->h_addr_list[i]; i++) {
	    addr = host->h_addr_list[i];
	    printf("%s has address %d.%d.%d.%d\n",hostname,
		   ((unsigned char *)addr)[0],((unsigned char *)addr)[1],
		   ((unsigned char *)addr)[2],((unsigned char *)addr)[3]);
	}
	exit(0);
    }
}
