/////////////////////////////////////////////////////////////////////////////
// Name:        colordlg.h
// Purpose:     wxColourDialog class. Use generic version if no
//              platform-specific implementation.
// Author:      Julian Smart
// Modified by:
// Created:     17/09/98
// RCS-ID:      $Id: colordlg.h,v 1.2 2002/02/05 16:34:30 JS Exp $
// Copyright:   (c) Julian Smart
// Licence:   	wxWindows licence
/////////////////////////////////////////////////////////////////////////////

#ifndef _WX_COLORDLG_H_
#define _WX_COLORDLG_H_

#ifdef __GNUG__
#pragma interface "colordlg.h"
#endif

#include "wx/setup.h"
#include "wx/dialog.h"
#include "wx/cmndata.h"

/*
* Platform-specific colour dialog implementation
*/

class WXDLLEXPORT wxColourDialog: public wxDialog
{
    DECLARE_DYNAMIC_CLASS(wxColourDialog)
public:
    wxColourDialog();
    wxColourDialog(wxWindow *parent, wxColourData *data = NULL);
    
    bool Create(wxWindow *parent, wxColourData *data = NULL);
    
    int ShowModal();
    wxColourData& GetColourData() { return m_colourData; }
    
protected:
    wxColourData        m_colourData;
    wxWindow*           m_dialogParent;
};

#endif
// _WX_COLORDLG_H_
