/* The following code was generated by JFlex 1.4 on 7/5/05 12:27 AM */

/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*nlsXXX*/
package org.eclipse.jst.jsp.core.internal.contenttype;
import java.io.IOException;
import java.io.Reader;

import org.eclipse.wst.xml.core.internal.contenttype.EncodingParserConstants;
import org.eclipse.wst.xml.core.internal.contenttype.XMLHeadTokenizerConstants;






/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.4
 * on 7/5/05 12:27 AM from the specification file
 * <tt>D:/builds/Workspaces/PureHeadWTP_M7/org.eclipse.jst.jsp.core/DevTimeSupport/HeadParsers/JSPHeadTokenizer.jFlex</tt>
 */
public class JSPHeadTokenizer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 8192;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int UnDelimitedString = 12;
  public static final int DQ_STRING = 8;
  public static final int SQ_STRING = 10;
  public static final int ST_XMLDecl = 2;
  public static final int ST_PAGE_DIRECTIVE = 4;
  public static final int QuotedAttributeValue = 6;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = { 
     0,  1,  2,  2,  3,  3,  4,  4,  5,  5,  6,  6,  7, 7
  };

  /** 
   * Translates characters to character classes
   */
  private static final String ZZ_CMAP_PACKED = 
    "\11\0\1\6\1\11\2\0\1\10\22\0\1\6\1\0\1\45\2\0"+
    "\1\17\1\0\1\46\6\0\1\36\1\44\12\0\1\27\1\0\1\12"+
    "\1\7\1\41\1\13\1\20\1\22\1\0\1\33\1\30\1\24\1\0"+
    "\1\23\1\0\1\31\1\25\1\0\1\16\1\15\1\40\1\37\1\21"+
    "\1\0\1\32\1\26\1\34\1\42\1\35\1\0\1\14\1\43\7\0"+
    "\1\22\1\0\1\33\1\30\1\24\1\0\1\23\1\0\1\31\1\25"+
    "\1\0\1\16\1\15\1\40\1\37\1\21\1\0\1\32\1\26\1\34"+
    "\1\42\1\35\1\0\1\14\1\43\101\0\1\4\3\0\1\5\17\0"+
    "\1\3\16\0\1\1\20\0\1\3\16\0\1\1\1\2\170\0\1\2"+
    "\ufe87\0";

  /** 
   * Translates characters to character classes
   */
  private static final char [] ZZ_CMAP = zzUnpackCMap(ZZ_CMAP_PACKED);

  /** 
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\10\0\20\1\2\2\1\1\1\3\1\4\1\5\1\6"+
    "\2\5\1\7\1\5\1\7\1\10\2\11\2\0\1\12"+
    "\1\13\6\0\1\14\3\0\1\15\2\0\1\16\1\0"+
    "\1\17\1\20\3\0\1\21\30\0\1\22\14\0\1\23"+
    "\2\0\1\24\4\0\1\25\1\26\12\0\1\27\1\0"+
    "\1\30\2\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[126];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String ZZ_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the textposition at the last state to be included in yytext */
  private int zzPushbackPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /** number of newlines encountered up to the start of the matched text */
//  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
//  private int yycolumn;

  /** 
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */




        private boolean hasMore = true;
        private final static int MAX_TO_SCAN = 8000;
        StringBuffer string = new StringBuffer();
        // state stack for easier state handling
        private IntStack fStateStack = new IntStack();
        private String valueText = null;


        public JSPHeadTokenizer() {
                super();
        }

          public void reset (Reader in) {
                /* the input device */
                zzReader = in;

                /* the current state of the DFA */
                zzState = 0;

                /* the current lexical state */
                zzLexicalState = YYINITIAL;

                /* this buffer contains the current text to be matched and is
                 the source of the yytext() string */
                java.util.Arrays.fill(zzBuffer, (char)0);

                /* the textposition at the last accepting state */
                zzMarkedPos = 0;

                /* the textposition at the last state to be included in yytext */
                zzPushbackPos = 0;

                /* the current text position in the buffer */
                zzCurrentPos = 0;

                /* startRead marks the beginning of the yytext() string in the buffer */
                zzStartRead = 0;

                /**
                 * endRead marks the last character in the buffer, that has been read
                 * from input
                 */
                zzEndRead = 0;

                /* number of newlines encountered up to the start of the matched text */
//                yyline = 0;

                /* the number of characters up to the start of the matched text */
                yychar = 0;

                /**
                 * the number of characters from the last newline up to the start
                 * of the matched text
                 */
//                yycolumn = 0;

                /**
                 * yy_atBOL == true <=> the scanner is currently at the beginning
                 * of a line
                 */
                zzAtBOL = true;

                /* yy_atEOF == true <=> the scanner has returned a value for EOF */
                zzAtEOF = false;

                /* denotes if the user-EOF-code has already been executed */
                zzEOFDone = false;


                fStateStack.clear();

                hasMore = true;


        }


        public final HeadParserToken getNextToken() throws IOException {
                String context = null;
                context = primGetNextToken();
                HeadParserToken result = null;
                if (valueText != null) {
                        result = createToken(context, yychar, valueText);
                        valueText = null;
                } else {
                        result = createToken(context, yychar, yytext());
                }
                return result;
        }

        public final boolean hasMoreTokens() {
                return hasMore && yychar < MAX_TO_SCAN;
        }
        private void pushCurrentState() {
                fStateStack.push(yystate());

        }
 
        private void popState() {
                yybegin(fStateStack.pop());
        }
        private HeadParserToken createToken(String context, int start, String text) {
                return new HeadParserToken(context, start, text);
        }




  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JSPHeadTokenizer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public JSPHeadTokenizer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 182) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead-zzStartRead);

      /* translate stored positions */
      zzEndRead-= zzStartRead;
      zzCurrentPos-= zzStartRead;
      zzMarkedPos-= zzStartRead;
      zzPushbackPos-= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzCurrentPos*2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = zzReader.read(zzBuffer, zzEndRead,
                                            zzBuffer.length-zzEndRead);

    if (numRead < 0) {
      return true;
    }
    else {
      zzEndRead+= numRead;
      return false;
    }
  }

    
  /**
   * Closes the input stream.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true;            /* indicate end of file */
    zzEndRead = zzStartRead;  /* invalidate buffer    */

    if (zzReader != null)
      zzReader.close();
  }


  /**
   * Resets the scanner to read from a new input stream.
   * Does not close the old reader.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>ZZ_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzAtBOL  = true;
    zzAtEOF  = false;
    zzEndRead = zzStartRead = 0;
    zzCurrentPos = zzMarkedPos = zzPushbackPos = 0;
    //yyline = yychar = yycolumn = 0;
    yychar = 0;
    zzLexicalState = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final String yytext() {
    return new String( zzBuffer, zzStartRead, zzMarkedPos-zzStartRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer[zzStartRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void zzDoEOF() {
    if (!zzEOFDone) {
      zzEOFDone = true;
            hasMore=false;

    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public String primGetNextToken() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char [] zzBufferL = zzBuffer;
    char [] zzCMapL = ZZ_CMAP;


    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      if (zzMarkedPosL > zzStartRead) {
        switch (zzBufferL[zzMarkedPosL-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          zzAtBOL = true;
          break;
        case '\r': 
          if (zzMarkedPosL < zzEndReadL)
            zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          else if (zzAtEOF)
            zzAtBOL = false;
          else {
            boolean eof = zzRefill();
            zzMarkedPosL = zzMarkedPos;
            zzBufferL = zzBuffer;
            if (eof) 
              zzAtBOL = false;
            else 
              zzAtBOL = zzBufferL[zzMarkedPosL] != '\n';
          }
          break;
        default:
          zzAtBOL = false;
        }
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;
  
      if (zzAtBOL)
        zzState = ZZ_LEXSTATE[zzLexicalState+1];
      else
        zzState = ZZ_LEXSTATE[zzLexicalState];


      zzForAction: {
        while (true) {
    
          if (zzCurrentPosL < zzEndReadL)
            zzInput = zzBufferL[zzCurrentPosL++];
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = zzBufferL[zzCurrentPosL++];
            }
          }
          zzInput = zzCMapL[zzInput];

          boolean zzIsFinal = false;
          boolean zzNoLookAhead = false;

          zzForNext: { switch (zzState) {
            case 0:
              switch (zzInput) {
                case 10: zzIsFinal = true; zzState = 9; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 8; break zzForNext;
              }

            case 1:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzState = 10; break zzForNext;
                case 2: zzIsFinal = true; zzState = 11; break zzForNext;
                case 3: zzIsFinal = true; zzState = 12; break zzForNext;
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 13; break zzForNext;
                case 10: zzIsFinal = true; zzState = 14; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 8; break zzForNext;
              }

            case 2:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 15; break zzForNext;
                case 11: zzIsFinal = true; zzState = 16; break zzForNext;
                case 20: zzIsFinal = true; zzState = 17; break zzForNext;
                case 29: zzIsFinal = true; zzState = 18; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 8; break zzForNext;
              }

            case 3:
              switch (zzInput) {
                case 14: zzIsFinal = true; zzState = 19; break zzForNext;
                case 15: zzIsFinal = true; zzState = 20; break zzForNext;
                case 17: zzIsFinal = true; zzState = 21; break zzForNext;
                case 27: zzIsFinal = true; zzState = 22; break zzForNext;
                case 36: zzIsFinal = true; zzState = 23; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 8; break zzForNext;
              }

            case 4:
              switch (zzInput) {
                case 6: 
                case 8: zzIsFinal = true; zzState = 25; break zzForNext;
                case 9: zzIsFinal = true; zzState = 26; break zzForNext;
                case 37: zzIsFinal = true; zzNoLookAhead = true; zzState = 27; break zzForNext;
                case 38: zzIsFinal = true; zzNoLookAhead = true; zzState = 28; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 24; break zzForNext;
              }

            case 5:
              switch (zzInput) {
                case 8: 
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 30; break zzForNext;
                case 11: zzIsFinal = true; zzState = 31; break zzForNext;
                case 15: zzIsFinal = true; zzState = 32; break zzForNext;
                case 37: zzIsFinal = true; zzNoLookAhead = true; zzState = 33; break zzForNext;
                case 38: zzIsFinal = true; zzState = 34; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 29; break zzForNext;
              }

            case 6:
              switch (zzInput) {
                case 8: 
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 30; break zzForNext;
                case 15: zzIsFinal = true; zzState = 32; break zzForNext;
                case 38: zzIsFinal = true; zzState = 35; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 29; break zzForNext;
              }

            case 7:
              switch (zzInput) {
                case 11: 
                case 15: zzIsFinal = true; zzState = 32; break zzForNext;
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzNoLookAhead = true; zzState = 36; break zzForNext;
                case 37: zzIsFinal = true; zzNoLookAhead = true; zzState = 37; break zzForNext;
                case 38: zzIsFinal = true; zzState = 38; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 29; break zzForNext;
              }

            case 9:
              switch (zzInput) {
                case 15: zzState = 39; break zzForNext;
                case 21: zzState = 40; break zzForNext;
                default: break zzForAction;
              }

            case 10:
              switch (zzInput) {
                case 2: zzIsFinal = true; zzNoLookAhead = true; zzState = 41; break zzForNext;
                default: break zzForAction;
              }

            case 11:
              switch (zzInput) {
                case 1: zzIsFinal = true; zzNoLookAhead = true; zzState = 42; break zzForNext;
                default: break zzForAction;
              }

            case 12:
              switch (zzInput) {
                case 4: zzState = 43; break zzForNext;
                default: break zzForAction;
              }

            case 13:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 44; break zzForNext;
                case 10: zzState = 45; break zzForNext;
                default: break zzForAction;
              }

            case 14:
              switch (zzInput) {
                case 15: zzState = 39; break zzForNext;
                case 21: zzState = 40; break zzForNext;
                case 11: zzState = 46; break zzForNext;
                default: break zzForAction;
              }

            case 15:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 47; break zzForNext;
                case 11: zzState = 48; break zzForNext;
                default: break zzForAction;
              }

            case 16:
              switch (zzInput) {
                case 33: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                default: break zzForAction;
              }

            case 17:
              switch (zzInput) {
                case 32: zzState = 50; break zzForNext;
                default: break zzForAction;
              }

            case 18:
              switch (zzInput) {
                case 20: zzState = 51; break zzForNext;
                default: break zzForAction;
              }

            case 19:
              switch (zzInput) {
                case 18: zzState = 52; break zzForNext;
                default: break zzForAction;
              }

            case 20:
              switch (zzInput) {
                case 33: zzIsFinal = true; zzNoLookAhead = true; zzState = 53; break zzForNext;
                default: break zzForAction;
              }

            case 21:
              switch (zzInput) {
                case 18: zzState = 54; break zzForNext;
                default: break zzForAction;
              }

            case 22:
              switch (zzInput) {
                case 31: zzState = 55; break zzForNext;
                default: break zzForAction;
              }

            case 23:
              switch (zzInput) {
                case 33: zzIsFinal = true; zzNoLookAhead = true; zzState = 56; break zzForNext;
                default: break zzForAction;
              }

            case 25:
              switch (zzInput) {
                case 6: 
                case 8: zzIsFinal = true; zzState = 25; break zzForNext;
                case 9: zzState = 57; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 24; break zzForNext;
              }

            case 26:
              switch (zzInput) {
                case 6: 
                case 8: zzIsFinal = true; zzState = 25; break zzForNext;
                case 9: zzState = 57; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 24; break zzForNext;
              }

            case 31:
              switch (zzInput) {
                case 33: zzIsFinal = true; zzNoLookAhead = true; zzState = 58; break zzForNext;
                default: break zzForAction;
              }

            case 32:
              switch (zzInput) {
                case 33: zzIsFinal = true; zzNoLookAhead = true; zzState = 59; break zzForNext;
                default: break zzForAction;
              }

            case 34:
              switch (zzInput) {
                case 10: zzState = 60; break zzForNext;
                default: break zzForAction;
              }

            case 35:
              switch (zzInput) {
                case 10: zzState = 60; break zzForNext;
                default: break zzForAction;
              }

            case 38:
              switch (zzInput) {
                case 10: zzState = 60; break zzForNext;
                default: break zzForAction;
              }

            case 39:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 39; break zzForNext;
                case 16: zzState = 61; break zzForNext;
                default: break zzForAction;
              }

            case 40:
              switch (zzInput) {
                case 22: zzState = 62; break zzForNext;
                default: break zzForAction;
              }

            case 43:
              switch (zzInput) {
                case 5: zzIsFinal = true; zzNoLookAhead = true; zzState = 63; break zzForNext;
                default: break zzForAction;
              }

            case 44:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 44; break zzForNext;
                case 10: zzState = 45; break zzForNext;
                default: break zzForAction;
              }

            case 45:
              switch (zzInput) {
                case 11: zzState = 46; break zzForNext;
                default: break zzForAction;
              }

            case 46:
              switch (zzInput) {
                case 12: zzState = 64; break zzForNext;
                default: break zzForAction;
              }

            case 47:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 47; break zzForNext;
                case 11: zzState = 48; break zzForNext;
                default: break zzForAction;
              }

            case 48:
              switch (zzInput) {
                case 33: zzIsFinal = true; zzNoLookAhead = true; zzState = 49; break zzForNext;
                default: break zzForAction;
              }

            case 50:
              switch (zzInput) {
                case 27: zzState = 65; break zzForNext;
                default: break zzForAction;
              }

            case 51:
              switch (zzInput) {
                case 26: zzState = 66; break zzForNext;
                default: break zzForAction;
              }

            case 52:
              switch (zzInput) {
                case 32: zzState = 67; break zzForNext;
                default: break zzForAction;
              }

            case 54:
              switch (zzInput) {
                case 19: zzState = 68; break zzForNext;
                default: break zzForAction;
              }

            case 55:
              switch (zzInput) {
                case 32: zzState = 69; break zzForNext;
                default: break zzForAction;
              }

            case 57:
              switch (zzInput) {
                case 6: 
                case 8: zzIsFinal = true; zzState = 25; break zzForNext;
                case 9: zzState = 57; break zzForNext;
                default: zzIsFinal = true; zzNoLookAhead = true; zzState = 24; break zzForNext;
              }

            case 60:
              switch (zzInput) {
                case 38: zzIsFinal = true; zzNoLookAhead = true; zzState = 30; break zzForNext;
                default: break zzForAction;
              }

            case 61:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 61; break zzForNext;
                case 17: zzState = 70; break zzForNext;
                default: break zzForAction;
              }

            case 62:
              switch (zzInput) {
                case 17: zzState = 71; break zzForNext;
                default: break zzForAction;
              }

            case 64:
              switch (zzInput) {
                case 13: zzState = 72; break zzForNext;
                default: break zzForAction;
              }

            case 65:
              switch (zzInput) {
                case 31: zzState = 73; break zzForNext;
                default: break zzForAction;
              }

            case 66:
              switch (zzInput) {
                case 22: zzState = 74; break zzForNext;
                default: break zzForAction;
              }

            case 67:
              switch (zzInput) {
                case 19: zzState = 75; break zzForNext;
                default: break zzForAction;
              }

            case 68:
              switch (zzInput) {
                case 20: zzState = 76; break zzForNext;
                default: break zzForAction;
              }

            case 69:
              switch (zzInput) {
                case 28: zzState = 77; break zzForNext;
                default: break zzForAction;
              }

            case 70:
              switch (zzInput) {
                case 18: zzState = 78; break zzForNext;
                default: break zzForAction;
              }

            case 71:
              switch (zzInput) {
                case 23: zzState = 79; break zzForNext;
                default: break zzForAction;
              }

            case 72:
              switch (zzInput) {
                case 14: zzState = 80; break zzForNext;
                default: break zzForAction;
              }

            case 73:
              switch (zzInput) {
                case 24: zzState = 81; break zzForNext;
                default: break zzForAction;
              }

            case 74:
              switch (zzInput) {
                case 25: zzState = 82; break zzForNext;
                default: break zzForAction;
              }

            case 75:
              switch (zzInput) {
                case 34: zzState = 83; break zzForNext;
                default: break zzForAction;
              }

            case 76:
              switch (zzInput) {
                case 20: zzState = 84; break zzForNext;
                default: break zzForAction;
              }

            case 77:
              switch (zzInput) {
                case 20: zzState = 85; break zzForNext;
                default: break zzForAction;
              }

            case 78:
              switch (zzInput) {
                case 19: zzState = 86; break zzForNext;
                default: break zzForAction;
              }

            case 79:
              switch (zzInput) {
                case 24: zzState = 87; break zzForNext;
                default: break zzForAction;
              }

            case 80:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 88; break zzForNext;
                default: break zzForAction;
              }

            case 81:
              switch (zzInput) {
                case 25: zzState = 89; break zzForNext;
                default: break zzForAction;
              }

            case 82:
              switch (zzInput) {
                case 31: zzState = 90; break zzForNext;
                default: break zzForAction;
              }

            case 83:
              switch (zzInput) {
                case 18: zzState = 91; break zzForNext;
                default: break zzForAction;
              }

            case 84:
              switch (zzInput) {
                case 32: zzState = 92; break zzForNext;
                default: break zzForAction;
              }

            case 85:
              switch (zzInput) {
                case 32: zzState = 93; break zzForNext;
                default: break zzForAction;
              }

            case 86:
              switch (zzInput) {
                case 20: zzState = 94; break zzForNext;
                default: break zzForAction;
              }

            case 87:
              switch (zzInput) {
                case 25: zzState = 95; break zzForNext;
                default: break zzForAction;
              }

            case 88:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 88; break zzForNext;
                default: break zzForAction;
              }

            case 89:
              switch (zzInput) {
                case 32: zzState = 96; break zzForNext;
                default: break zzForAction;
              }

            case 90:
              switch (zzInput) {
                case 32: zzState = 97; break zzForNext;
                default: break zzForAction;
              }

            case 91:
              switch (zzInput) {
                case 19: zzState = 98; break zzForNext;
                default: break zzForAction;
              }

            case 92:
              switch (zzInput) {
                case 27: zzState = 99; break zzForNext;
                default: break zzForAction;
              }

            case 93:
              switch (zzInput) {
                case 28: zzState = 100; break zzForNext;
                default: break zzForAction;
              }

            case 94:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 101; break zzForNext;
                default: break zzForAction;
              }

            case 95:
              switch (zzInput) {
                case 26: zzState = 102; break zzForNext;
                default: break zzForAction;
              }

            case 96:
              switch (zzInput) {
                case 19: zzState = 103; break zzForNext;
                default: break zzForAction;
              }

            case 97:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 97; break zzForNext;
                case 7: zzIsFinal = true; zzState = 104; break zzForNext;
                default: break zzForAction;
              }

            case 98:
              switch (zzInput) {
                case 20: zzState = 105; break zzForNext;
                default: break zzForAction;
              }

            case 99:
              switch (zzInput) {
                case 31: zzState = 106; break zzForNext;
                default: break zzForAction;
              }

            case 100:
              switch (zzInput) {
                case 28: zzState = 107; break zzForNext;
                default: break zzForAction;
              }

            case 101:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 101; break zzForNext;
                default: break zzForAction;
              }

            case 102:
              switch (zzInput) {
                case 20: zzState = 108; break zzForNext;
                default: break zzForAction;
              }

            case 103:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 103; break zzForNext;
                case 7: zzIsFinal = true; zzState = 109; break zzForNext;
                default: break zzForAction;
              }

            case 104:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 104; break zzForNext;
                default: break zzForAction;
              }

            case 105:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 105; break zzForNext;
                case 7: zzIsFinal = true; zzState = 110; break zzForNext;
                default: break zzForAction;
              }

            case 106:
              switch (zzInput) {
                case 24: zzState = 111; break zzForNext;
                default: break zzForAction;
              }

            case 107:
              switch (zzInput) {
                case 35: zzState = 112; break zzForNext;
                default: break zzForAction;
              }

            case 108:
              switch (zzInput) {
                case 27: zzState = 113; break zzForNext;
                default: break zzForAction;
              }

            case 109:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 109; break zzForNext;
                default: break zzForAction;
              }

            case 110:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 110; break zzForNext;
                default: break zzForAction;
              }

            case 111:
              switch (zzInput) {
                case 25: zzState = 114; break zzForNext;
                default: break zzForAction;
              }

            case 112:
              switch (zzInput) {
                case 17: zzState = 115; break zzForNext;
                default: break zzForAction;
              }

            case 113:
              switch (zzInput) {
                case 28: zzState = 116; break zzForNext;
                default: break zzForAction;
              }

            case 114:
              switch (zzInput) {
                case 32: zzState = 117; break zzForNext;
                default: break zzForAction;
              }

            case 115:
              switch (zzInput) {
                case 20: zzState = 118; break zzForNext;
                default: break zzForAction;
              }

            case 116:
              switch (zzInput) {
                case 25: zzState = 119; break zzForNext;
                default: break zzForAction;
              }

            case 117:
              switch (zzInput) {
                case 19: zzState = 120; break zzForNext;
                default: break zzForAction;
              }

            case 118:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 118; break zzForNext;
                case 7: zzIsFinal = true; zzState = 121; break zzForNext;
                default: break zzForAction;
              }

            case 119:
              switch (zzInput) {
                case 29: zzState = 122; break zzForNext;
                default: break zzForAction;
              }

            case 120:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzState = 120; break zzForNext;
                case 7: zzIsFinal = true; zzState = 123; break zzForNext;
                default: break zzForAction;
              }

            case 121:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 121; break zzForNext;
                default: break zzForAction;
              }

            case 122:
              switch (zzInput) {
                case 20: zzState = 124; break zzForNext;
                default: break zzForAction;
              }

            case 123:
              switch (zzInput) {
                case 6: 
                case 8: 
                case 9: zzIsFinal = true; zzState = 123; break zzForNext;
                default: break zzForAction;
              }

            case 124:
              switch (zzInput) {
                case 30: zzState = 125; break zzForNext;
                default: break zzForAction;
              }

            case 125:
              switch (zzInput) {
                case 17: zzState = 70; break zzForNext;
                default: break zzForAction;
              }

            default:
              // if this is ever reached, there is a serious bug in JFlex
              zzScanError(ZZ_UNKNOWN_ERROR);
              break;
          } }

          if ( zzIsFinal ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( zzNoLookAhead ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
        case 10: 
          { if (yychar == 0 ) {hasMore = false; return EncodingParserConstants.UTF16BE;}
          }
        case 25: break;
        case 17: 
          { if (yychar == 0 ) {hasMore = false; return EncodingParserConstants.UTF83ByteBOM;}
          }
        case 26: break;
        case 4: 
          { yybegin(SQ_STRING); string.setLength(0);
          }
        case 27: break;
        case 5: 
          { string.append( yytext() );
          }
        case 28: break;
        case 22: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return JSPHeadTokenizerConstants.PageLanguage;
          }
        case 29: break;
        case 24: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return JSPHeadTokenizerConstants.PageEncoding;
          }
        case 30: break;
        case 1: 
          { if (yychar > MAX_TO_SCAN) {hasMore=false; return EncodingParserConstants.MAX_CHARS_REACHED;}
          }
        case 31: break;
        case 11: 
          { if (yychar == 0 ) {hasMore = false; return EncodingParserConstants.UTF16LE;}
          }
        case 32: break;
        case 6: 
          { yypushback(1);popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTerminatedStringValue;
          }
        case 33: break;
        case 8: 
          { yypushback(1);popState(); valueText = string.toString(); return EncodingParserConstants.UnDelimitedStringValue;
          }
        case 34: break;
        case 9: 
          { yypushback(1);popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTermintatedUnDelimitedStringValue;
          }
        case 35: break;
        case 7: 
          { popState(); valueText = string.toString(); return EncodingParserConstants.StringValue;
          }
        case 36: break;
        case 13: 
          { yybegin(YYINITIAL);  return JSPHeadTokenizerConstants.PageDirectiveEnd;
          }
        case 37: break;
        case 23: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return JSPHeadTokenizerConstants.PageContentType;
          }
        case 38: break;
        case 18: 
          { if (yychar == 0 ) {yybegin(ST_XMLDecl); return XMLHeadTokenizerConstants.XMLDeclStart;}
          }
        case 39: break;
        case 15: 
          { yypushback(2); popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTerminatedStringValue;
          }
        case 40: break;
        case 2: 
          { yypushback(1); yybegin(UnDelimitedString); string.setLength(0);
          }
        case 41: break;
        case 12: 
          { yybegin(YYINITIAL); return XMLHeadTokenizerConstants.XMLDeclEnd;
          }
        case 42: break;
        case 14: 
          { yybegin(YYINITIAL); return JSPHeadTokenizerConstants.PageDirectiveEnd;
          }
        case 43: break;
        case 19: 
          { yybegin(ST_PAGE_DIRECTIVE); return JSPHeadTokenizerConstants.PageDirectiveStart;
          }
        case 44: break;
        case 21: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return XMLHeadTokenizerConstants.XMLDelEncoding;
          }
        case 45: break;
        case 20: 
          { pushCurrentState(); yybegin(QuotedAttributeValue); return XMLHeadTokenizerConstants.XMLDeclVersion;
          }
        case 46: break;
        case 16: 
          { yypushback(2);popState(); valueText = string.toString(); return EncodingParserConstants.InvalidTerminatedStringValue;
          }
        case 47: break;
        case 3: 
          { yybegin(DQ_STRING); string.setLength(0);
          }
        case 48: break;
        default: 
          if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
            zzAtEOF = true;
            zzDoEOF();
              { hasMore = false; return EncodingParserConstants.EOF; }
          } 
          else {
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
