/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.NameSection;

public abstract class ReferenceSection
extends NameSection {
    public static String BROWSE_STRING = Messages.getString("_UI_BUTTON_BROWSE");
    public static String NEW_STRING = Messages.getString("_UI_BUTTON_NEW");
    protected CCombo combo;
    protected CLabel comboLabel;
    protected List itemsInCombo = new ArrayList();

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.comboLabel = this.getWidgetFactory().createCLabel(this.composite, "Reference");
        this.combo = this.getWidgetFactory().createCCombo(this.composite);
        this.combo.setBackground(this.composite.getBackground());
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.combo, -5);
        data.top = new FormAttachment((Control)this.combo, 0, 0x1000000);
        this.comboLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.nameText, 4);
        this.combo.setLayoutData((Object)data);
        this.combo.addListener(24, (Listener)this);
    }

    public void refresh() {
        this.combo.removeListener(24, (Listener)this);
        super.refresh();
        List comboItems = this.getComboItems();
        if (comboItems.size() > 0) {
            this.combo.removeAll();
            this.itemsInCombo.clear();
            String currentComboItemName = this.getComboItemName(this.getCurrentComboItem());
            int currentBindingIndex = -1;
            List items = this.getComboItems();
            int index = 0;
            while (index < items.size()) {
                Object item = items.get(index);
                String itemName = this.getComboItemName(item);
                this.combo.add(itemName);
                this.itemsInCombo.add(item);
                if (itemName.equals(currentComboItemName)) {
                    currentBindingIndex = index;
                }
                ++index;
            }
            if (currentBindingIndex != -1) {
                this.combo.select(currentBindingIndex);
            }
        }
        this.setControlForegroundColor((Control)this.combo);
        this.combo.addListener(24, (Listener)this);
    }

    protected abstract List getComboItems();

    protected abstract Object getCurrentComboItem();

    protected abstract String getComboItemName(Object var1);

    protected abstract void performComboSelection(Object var1);

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void doHandleEvent(Event event) {
        super.doHandleEvent(event);
        if (event.widget == this.combo && !this.combo.isDisposed()) {
            int selectionIndex = this.combo.getSelectionIndex();
            this.performComboSelection(this.itemsInCombo.get(selectionIndex));
            this.refresh();
        }
    }
}

