/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.OverviewDoc;
import org.uddi4j.datatype.OverviewURL;
import org.uddi4j.datatype.binding.AccessPoint;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.binding.BindingTemplates;
import org.uddi4j.datatype.binding.InstanceDetails;
import org.uddi4j.datatype.binding.TModelInstanceDetails;
import org.uddi4j.datatype.binding.TModelInstanceInfo;
import org.uddi4j.datatype.service.BusinessService;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Uddi4jHelper {
    private final String URL_TYPE_OTHER = "other";
    private final String URL_TYPES = "http https mail ftp fax phone other";

    public final KeyedReference getWSDLKeyedReference() {
        KeyedReference keyRef = new KeyedReference("types", "wsdlSpec");
        keyRef.setTModelKey("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4");
        return keyRef;
    }

    public final TModel newTModel(String wsdlUrl) throws WSDLException {
        return this.newTModel(wsdlUrl, this.getWSDLDefinition(wsdlUrl));
    }

    public final TModel newTModel(String wsdlUrl, Definition def) throws WSDLException {
        TModel tModel = new TModel();
        tModel.setTModelKey("");
        tModel.setName(def.getTargetNamespace());
        tModel.setDefaultDescriptionString("");
        OverviewDoc overviewDoc = new OverviewDoc();
        overviewDoc.setOverviewURL(wsdlUrl);
        tModel.setOverviewDoc(overviewDoc);
        CategoryBag catBag = new CategoryBag();
        Vector<KeyedReference> keyRefVector = new Vector<KeyedReference>();
        keyRefVector.add(this.getWSDLKeyedReference());
        catBag.setKeyedReferenceVector(keyRefVector);
        tModel.setCategoryBag(catBag);
        return tModel;
    }

    public final BusinessService newBusinessService(String wsdlUrl, Hashtable tModelsTable) throws WSDLException {
        return this.newBusinessService(wsdlUrl, this.getWSDLDefinition(wsdlUrl), tModelsTable);
    }

    public final BusinessService newBusinessService(String wsdlUrl, Definition def, Hashtable tModelsTable) throws WSDLException {
        BusinessService bs = new BusinessService();
        bs.setServiceKey("");
        BindingTemplates bindingTemplates = new BindingTemplates();
        Vector<BindingTemplate> bindingTemplateVector = new Vector<BindingTemplate>();
        Service[] services = def.getServices().values().toArray(new Service[0]);
        if (services.length > 0) {
            Port[] ports = services[0].getPorts().values().toArray(new Port[0]);
            int i = 0;
            while (i < ports.length) {
                TModelInstanceDetails tModelDetails = new TModelInstanceDetails();
                Vector<TModelInstanceInfo> tModelInfoVector = new Vector<TModelInstanceInfo>();
                TModel tModel = (TModel)tModelsTable.get(ports[i].getBinding().getPortType().getQName().getNamespaceURI());
                tModelInfoVector.add(this.createTModelInstanceInfo(wsdlUrl, ports[i], tModel.getTModelKey()));
                tModelDetails.setTModelInstanceInfoVector(tModelInfoVector);
                BindingTemplate bindingTemplate = new BindingTemplate();
                bindingTemplate.setDefaultDescriptionString(this.createDescription(ports[i]));
                bindingTemplate.setAccessPoint(this.createAccessPoint(ports[i]));
                bindingTemplate.setTModelInstanceDetails(tModelDetails);
                bindingTemplate.setBindingKey("");
                bindingTemplateVector.add(bindingTemplate);
                ++i;
            }
        }
        bindingTemplates.setBindingTemplateVector(bindingTemplateVector);
        bs.setBindingTemplates(bindingTemplates);
        return bs;
    }

    public final BusinessService newBusinessService(String wsdlUrl, Definition def, TModel[] tModels) throws WSDLException {
        BusinessService bs = new BusinessService();
        bs.setServiceKey("");
        BindingTemplates bindingTemplates = new BindingTemplates();
        Vector<BindingTemplate> bindingTemplateVector = new Vector<BindingTemplate>();
        Service[] services = def.getServices().values().toArray(new Service[0]);
        if (services.length > 0) {
            Port[] ports = services[0].getPorts().values().toArray(new Port[0]);
            int i = 0;
            while (i < ports.length) {
                int j = 0;
                while (j < tModels.length) {
                    TModelInstanceDetails tModelDetails = new TModelInstanceDetails();
                    Vector<TModelInstanceInfo> tModelInfoVector = new Vector<TModelInstanceInfo>();
                    tModelInfoVector.add(this.createTModelInstanceInfo(wsdlUrl, ports[i], tModels[j].getTModelKey()));
                    tModelDetails.setTModelInstanceInfoVector(tModelInfoVector);
                    BindingTemplate bindingTemplate = new BindingTemplate();
                    bindingTemplate.setDefaultDescriptionString(this.createDescription(ports[i]));
                    bindingTemplate.setAccessPoint(this.createAccessPoint(ports[i]));
                    bindingTemplate.setTModelInstanceDetails(tModelDetails);
                    bindingTemplate.setBindingKey("");
                    bindingTemplateVector.add(bindingTemplate);
                    ++j;
                }
                ++i;
            }
        }
        bindingTemplates.setBindingTemplateVector(bindingTemplateVector);
        bs.setBindingTemplates(bindingTemplates);
        return bs;
    }

    public Definition getWSDLDefinition(String wsdlUrl) throws WSDLException {
        try {
            WebServicesParserExt parser = new WebServicesParserExt();
            String proxySet = System.getProperty("http.proxySet");
            if (proxySet != null && proxySet.equals("true")) {
                parser.setHTTPBasicAuthUsername(System.getProperty("http.proxyUserName"));
                parser.setHTTPBasicAuthPassword(System.getProperty("http.proxyPassword"));
            }
            return parser.getWSDLDefinitionVerbose(wsdlUrl);
        }
        catch (Exception e) {
            throw new WSDLException("PARSER_ERROR", e.getMessage(), (Throwable)e);
        }
    }

    private final String createDescription(Port port) {
        String desc = null;
        Element e = port.getDocumentationElement();
        if (e != null) {
            Node node = e.getFirstChild();
            StringBuffer sb = new StringBuffer();
            while (node != null) {
                switch (node.getNodeType()) {
                    case 3: 
                    case 4: {
                        sb.append(((CharacterData)node).getData());
                    }
                }
                node = node.getNextSibling();
            }
            desc = sb.toString();
        }
        return desc;
    }

    private final TModelInstanceInfo createTModelInstanceInfo(String wsdlUrl, Port port, String tModelKey) {
        InstanceDetails details = new InstanceDetails();
        OverviewDoc overviewDoc = new OverviewDoc();
        TModelInstanceInfo tModelInfo = new TModelInstanceInfo();
        StringBuffer overviewURLString = new StringBuffer(wsdlUrl);
        String portName = port.getName();
        if (portName != null) {
            overviewURLString.append("#");
            overviewURLString.append(portName);
        }
        overviewDoc.setOverviewURL(new OverviewURL(overviewURLString.toString()));
        details.setOverviewDoc(overviewDoc);
        tModelInfo.setInstanceDetails(details);
        if (tModelKey != null) {
            tModelInfo.setTModelKey(tModelKey);
        }
        return tModelInfo;
    }

    private final AccessPoint createAccessPoint(Port port) {
        AccessPoint accessPoint = null;
        List list = port.getExtensibilityElements();
        int j = 0;
        while (j < list.size()) {
            ExtensibilityElement extElement = (ExtensibilityElement)list.get(j);
            if (extElement instanceof SOAPAddress) {
                String locationURI = ((SOAPAddress)extElement).getLocationURI();
                accessPoint = new AccessPoint(locationURI, this.getURLType(locationURI));
                break;
            }
            if (extElement instanceof HTTPAddress) {
                String locationURI = ((HTTPAddress)extElement).getLocationURI();
                accessPoint = new AccessPoint(locationURI, this.getURLType(locationURI));
                break;
            }
            ++j;
        }
        return accessPoint;
    }

    private final String getURLType(String url) {
        String type;
        int i = url.indexOf(":");
        if (i == -1) {
            type = "other";
        } else {
            type = url.substring(0, i);
            if (type.equals("") || "http https mail ftp fax phone other".indexOf(type) == -1) {
                type = "other";
            }
        }
        return type;
    }

    public boolean isMonolithicWSDL(Definition def) {
        return this.hasMessage(def) && this.hasPortType(def) && this.hasBinding(def) && this.hasService(def);
    }

    public boolean isServiceImplement(Definition def) {
        return this.hasImport(def) && this.hasService(def);
    }

    public boolean isServiceInterface(Definition def) {
        return this.hasMessage(def) && this.hasPortType(def) && this.hasBinding(def);
    }

    public boolean isServiceInterfaceWithBindingsOnly(Definition def) {
        return !this.hasService(def) && this.hasBinding(def);
    }

    private boolean hasMessage(Definition def) {
        Iterator it = def.getMessages().values().iterator();
        while (it.hasNext()) {
            if (((Message)it.next()).isUndefined()) continue;
            return true;
        }
        return false;
    }

    private boolean hasPortType(Definition def) {
        Iterator it = def.getPortTypes().values().iterator();
        while (it.hasNext()) {
            if (((PortType)it.next()).isUndefined()) continue;
            return true;
        }
        return false;
    }

    private boolean hasBinding(Definition def) {
        Iterator it = def.getBindings().values().iterator();
        while (it.hasNext()) {
            if (((Binding)it.next()).isUndefined()) continue;
            return true;
        }
        return false;
    }

    private boolean hasService(Definition def) {
        return !def.getServices().isEmpty();
    }

    private boolean hasImport(Definition def) {
        return !def.getImports().isEmpty();
    }

    public String[] getImports(Definition def, String wsdlUrl) {
        Import[] imports = def.getImports().values().toArray(new Import[0]);
        String[] importStrings = new String[imports.length];
        String s = wsdlUrl != null && wsdlUrl.indexOf(47) != -1 ? wsdlUrl.substring(0, wsdlUrl.lastIndexOf(47) + 1) : "";
        int i = 0;
        while (i < importStrings.length) {
            StringBuffer sb = new StringBuffer();
            String locationURI = imports[i].getLocationURI();
            if (locationURI.indexOf(58) != -1) {
                sb.append(locationURI);
            } else {
                sb.append(s).append(locationURI);
            }
            importStrings[i] = sb.toString();
            ++i;
        }
        return importStrings;
    }

    public String getWSDL(BusinessService bs, UDDIProxy proxy) {
        Vector tModelInfoVector;
        BindingTemplate bt;
        TModelInstanceDetails tModelDetails;
        Vector bindingTemplateVector = bs.getBindingTemplates().getBindingTemplateVector();
        if (bindingTemplateVector.size() > 0 && (tModelDetails = (bt = (BindingTemplate)bindingTemplateVector.get(0)).getTModelInstanceDetails()) != null && (tModelInfoVector = tModelDetails.getTModelInstanceInfoVector()).size() > 0) {
            String tModelKey;
            TModelInstanceInfo tModelInfo = (TModelInstanceInfo)tModelInfoVector.get(0);
            InstanceDetails details = tModelInfo.getInstanceDetails();
            if (details != null) {
                OverviewDoc overviewDoc = details.getOverviewDoc();
                if (overviewDoc != null) {
                    return this.parse(overviewDoc.getOverviewURLString());
                }
            } else if (proxy != null && (tModelKey = tModelInfo.getTModelKey()) != null) {
                try {
                    Vector tModelVector;
                    TModelDetail t = proxy.get_tModelDetail(tModelKey);
                    if (t != null && (tModelVector = t.getTModelVector()) != null && tModelVector.size() > 0) {
                        return this.getWSDL((TModel)tModelVector.get(0));
                    }
                }
                catch (UDDIException uDDIException) {
                }
                catch (TransportException transportException) {}
            }
        }
        return null;
    }

    public String getWSDL(TModel tModel) {
        OverviewDoc overviewDoc = tModel.getOverviewDoc();
        if (overviewDoc != null) {
            return this.parse(overviewDoc.getOverviewURLString());
        }
        return null;
    }

    private String parse(String s) {
        int index;
        if (s != null && s.length() > 0 && (index = s.indexOf(35)) != -1) {
            return s.substring(0, index);
        }
        return s;
    }
}

