/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.outputview;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.rdb.internal.outputview.DialogShowLongField;
import org.eclipse.wst.rdb.internal.outputview.DialogShowXMLField;
import org.eclipse.wst.rdb.internal.outputview.IAdditionalOutputViewTab;
import org.eclipse.wst.rdb.internal.outputview.OVMessageAreaMenu;
import org.eclipse.wst.rdb.internal.outputview.OVParameterAreaMenu;
import org.eclipse.wst.rdb.internal.outputview.OVResultAreaMenu;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewActionsTable;
import org.eclipse.wst.rdb.internal.outputview.OutputViewModel;
import org.eclipse.wst.rdb.internal.outputview.OutputViewPlugin;
import org.eclipse.wst.rdb.internal.outputview.ResultTableModel;
import org.eclipse.wst.rdb.internal.outputview.ResultTableViewer;
import org.w3c.dom.Document;

public class OutputView
extends ViewPart
implements SelectionListener {
    protected static final String PREFIX = "output_view.";
    protected static final String messages = OutputViewPlugin.getString("OV_DISPLAY_MESSAGES");
    protected static final String parms = OutputViewPlugin.getString("OV_DISPLAY_PARMS");
    protected static final String results = OutputViewPlugin.getString("OV_DISPLAY_RESULTS");
    protected static final String input = OutputViewPlugin.getString("OV_PARMS_INPUT");
    protected static final String output = OutputViewPlugin.getString("OV_PARMS_OUTPUT");
    protected static final String name = OutputViewPlugin.getString("OV_PARMS_NAME");
    protected static final String ADDITIONAL_TABS_EXT_POINT = "org.eclipse.wst.rdb.outputview.additionalOutputViewTabs";
    protected static final String ADDITIONAL_TAB_ATTR_CLASS = "class";
    protected static final String ADDITIONAL_TAB_ATTR_ID = "id";
    protected static ArrayList contributedTabOrder;
    protected static HashMap contributedTabs;
    protected Composite displayArea;
    protected Composite arrowPane;
    protected Composite topPane;
    protected Composite resultArea;
    protected TabFolder pageArea;
    protected TabItem messageTab;
    protected TabItem parmsTab;
    protected TabItem resultsTab = null;
    protected OutputViewActionsTable actionsTable;
    protected ResultTableViewer resultViewer;
    protected static final OutputViewModel model;
    protected TableViewer parmsTable;
    protected TableViewer resultsTable;
    protected StyledText messageArea;
    protected Label nameLabel;
    protected Button leftArrowB;
    protected Button rightArrowB;
    protected OutputItem item;
    protected String msg;
    protected Vector parameters;
    protected static String BUTTON_TEXT;
    protected ArrayList longParams = new ArrayList();
    protected static final int MAXDISPLAYLENGTH = 60;

    static {
        model = new OutputViewModel();
        BUTTON_TEXT = "...";
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        SashForm mainForm = new SashForm(parent, 256);
        mainForm.setLayoutData((Object)new GridData(1808));
        this.actionsTable = new OutputViewActionsTable((Composite)mainForm, model, this);
        this.actionsTable.getTable().addSelectionListener((SelectionListener)this);
        this.createDisplayArea((Composite)mainForm);
        mainForm.setWeights(new int[]{40, 60});
        WorkbenchHelp.setHelp((Control)mainForm, (String)"org.eclipse.wst.rdb.outputview.dboutput_view");
        this.refreshWithDefault();
    }

    protected void createDisplayArea(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setLayout((Layout)gridLayout);
        this.topPane = new Composite(this.displayArea, 0);
        FormLayout fl = new FormLayout();
        fl.marginHeight = 2;
        fl.marginWidth = 0;
        this.topPane.setLayout((Layout)fl);
        Composite labelPane = new Composite(this.topPane, 0);
        this.nameLabel = new Label(labelPane, 0);
        this.nameLabel.setVisible(true);
        GridData gd = new GridData(32);
        gd.grabExcessHorizontalSpace = true;
        this.nameLabel.setLayoutData((Object)gd);
        this.arrowPane = this.createArrowPane(this.topPane);
        FormData fd = new FormData();
        fd.width = 50;
        fd.right = new FormAttachment(100, 0);
        this.arrowPane.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment((Control)this.arrowPane, 0);
        fd.left = new FormAttachment(0, 0);
        labelPane.setLayoutData((Object)fd);
        gd = new GridData(256);
        this.topPane.setLayoutData((Object)gd);
        this.pageArea = new TabFolder(this.displayArea, 128);
        this.pageArea.addSelectionListener((SelectionListener)this);
        gd = new GridData(256);
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        this.pageArea.setLayoutData((Object)gd);
        this.messageTab = new TabItem(this.pageArea, 0);
        this.messageTab.setText(OutputViewPlugin.getString("OV_DISPLAY_MESSAGES"));
        this.messageTab.setToolTipText(OutputViewPlugin.getString("OV_MESSAGES_TOOL_TIP"));
        this.messageArea = new StyledText((Composite)this.pageArea, 33557066);
        OVMessageAreaMenu ovMessageMenu = new OVMessageAreaMenu(this.messageArea);
        this.messageArea.setMenu(ovMessageMenu.getMenu());
        this.messageTab.setControl((Control)this.messageArea);
        this.parmsTab = new TabItem(this.pageArea, 0);
        this.parmsTab.setText(OutputViewPlugin.getString("OV_DISPLAY_PARMS"));
        this.parmsTab.setToolTipText(OutputViewPlugin.getString("OV_PARMS_TOOL_TIP"));
        this.parmsTable = this.createParametersTable((Composite)this.pageArea);
        this.parmsTab.setControl(this.parmsTable.getControl());
        OVParameterAreaMenu ovParmMenu = new OVParameterAreaMenu(this.parmsTable.getTable());
        this.parmsTable.getTable().setMenu(ovParmMenu.getMenu());
        this.resultsTab = new TabItem(this.pageArea, 0);
        this.resultsTab.setText(OutputViewPlugin.getString("OV_DISPLAY_RESULTS"));
        this.resultsTab.setToolTipText(OutputViewPlugin.getString("OV_RESULTS_TOOL_TIP"));
        this.resultViewer = new ResultTableViewer((Composite)this.pageArea, model.getResultTableModel());
        this.resultsTable = this.resultViewer.getTableViewer();
        this.resultsTab.setControl(this.resultsTable.getControl());
        OVResultAreaMenu ovResultMenu = new OVResultAreaMenu(this.resultsTable.getTable());
        this.resultsTable.getTable().setMenu(ovResultMenu.getMenu());
        this.addTabItemsFromExtensions();
        this.showMessagePage();
    }

    private void addTabItemsFromExtensions() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(ADDITIONAL_TABS_EXT_POINT);
        IExtension[] extensions = extensionPoint.getExtensions();
        contributedTabs = new LinkedHashMap(extensions.length);
        contributedTabOrder = new ArrayList(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] configElements = ext.getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                IConfigurationElement currentConfigElement = configElements[j];
                try {
                    IAdditionalOutputViewTab myTabs = (IAdditionalOutputViewTab)currentConfigElement.createExecutableExtension(ADDITIONAL_TAB_ATTR_CLASS);
                    String id = currentConfigElement.getAttribute(ADDITIONAL_TAB_ATTR_ID);
                    myTabs.getTab(this.pageArea);
                    contributedTabs.put(id, myTabs);
                    contributedTabOrder.add(id);
                }
                catch (CoreException ex) {
                    OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputView:addTabItemsFromExtensions()", ex);
                }
                ++j;
            }
            ++i;
        }
    }

    protected TableViewer createParametersTable(Composite parent) {
        Table aTable = new Table(parent, 68356);
        aTable.setLinesVisible(true);
        aTable.setHeaderVisible(true);
        aTable.addSelectionListener((SelectionListener)this);
        TableColumn column = new TableColumn(aTable, 0);
        column.setText(name);
        column = new TableColumn(aTable, 0);
        column.setText(input);
        column = new TableColumn(aTable, 0);
        column.setText(output);
        this.parmsTable = new TableViewer(aTable);
        TableLayout layout = new TableLayout();
        ColumnWeightData data = new ColumnWeightData(33, true);
        layout.addColumnData((ColumnLayoutData)data);
        layout.addColumnData((ColumnLayoutData)data);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(34, false));
        aTable.setLayout((Layout)layout);
        this.parmsTable.setLabelProvider((IBaseLabelProvider)new ParmsTableLabelProvider());
        this.parmsTable.setContentProvider((IContentProvider)new ParmsTableContentProvider());
        this.parameters = new Vector();
        this.parmsTable.setInput((Object)this.parameters);
        return this.parmsTable;
    }

    protected Composite createArrowPane(Composite parent) {
        this.arrowPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.arrowPane.setLayout((Layout)layout);
        this.leftArrowB = new Button(this.arrowPane, 8);
        this.leftArrowB.setImage(OutputViewPlugin.getPlugin().getImageDescriptor("left_arrow_nav").createImage());
        this.leftArrowB.setToolTipText(OutputViewPlugin.getString("OV_RESULTS_LEFTARROW"));
        this.leftArrowB.addSelectionListener((SelectionListener)this);
        GridData gd = new GridData();
        gd.widthHint = 24;
        gd.heightHint = 18;
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        this.leftArrowB.setLayoutData((Object)gd);
        this.rightArrowB = new Button(this.arrowPane, 8);
        this.rightArrowB.setImage(OutputViewPlugin.getPlugin().getImageDescriptor("right_arrow_nav").createImage());
        this.rightArrowB.setToolTipText(OutputViewPlugin.getString("OV_RESULTS_RIGHTARROW"));
        this.rightArrowB.addSelectionListener((SelectionListener)this);
        gd = new GridData();
        gd.widthHint = 24;
        gd.heightHint = 18;
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        this.rightArrowB.setLayoutData((Object)gd);
        return this.arrowPane;
    }

    protected OutputViewModel getModel() {
        return model;
    }

    protected void addOutputItem(final OutputItem item, boolean async, final boolean showMsgPage) {
        model.addOutputItem(item);
        if (async) {
            if (this.displayArea == null) {
                return;
            }
            Display display = this.displayArea.getDisplay();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        OutputView.this.actionsTable.refresh();
                        OutputView.this.updateContentForNewSelectedItem(item);
                        int i = model.getActionList().indexOf(item);
                        OutputView.this.actionsTable.selectItem(i);
                        if (showMsgPage) {
                            OutputView.this.showMessagePage(false);
                        } else if (item.hasResults() && item.isStatusSuccess()) {
                            OutputView.this.showResultsPage(false);
                        } else {
                            OutputView.this.showMessagePage(false);
                        }
                    }
                });
            }
        } else {
            this.actionsTable.refresh();
            this.updateContentForNewSelectedItem(item);
            int i = model.getActionList().indexOf(item);
            this.actionsTable.selectItem(i);
            if (showMsgPage) {
                this.showMessagePage(false);
            } else if (item.hasResults() && item.isStatusSuccess()) {
                this.showResultsPage(false);
            } else {
                this.showMessagePage(false);
            }
        }
    }

    protected void showMessage(OutputItem item, String msg, boolean async) {
        item.appendMessage(msg);
        this.addOutputItem(item, async, true);
    }

    protected void showMessage(OutputItem item, boolean async) {
        this.addOutputItem(item, async, true);
    }

    public void showResult(final OutputItem item) {
        Display display = this.displayArea.getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    OutputView.this.actionsTable.refresh();
                    OutputView.this.updateContentForNewSelectedItem(item);
                    OutputView.this.showResultsPage();
                    OutputView.this.actionsTable.selectItem(item);
                }
            });
        }
    }

    public void showResult(OutputItem item, boolean async) {
        if (async) {
            this.showResult(item, true);
        } else {
            this.actionsTable.refresh();
            this.updateContentForNewSelectedItem(item);
            this.showResultsPage();
            this.actionsTable.selectItem(item);
        }
    }

    public void showParameters(OutputItem item, boolean async) {
        if (async) {
            this.showParameters(item, null);
        } else {
            this.actionsTable.refresh();
            this.updateContentForNewSelectedItem(item);
            this.showParametersPage();
            this.actionsTable.selectItem(item);
        }
    }

    public void showParameters(OutputItem item, Vector parms) {
        Display display;
        if (parms != null) {
            model.addParameters(item, parms);
        }
        if ((display = this.displayArea.getDisplay()) != null) {
            final OutputItem outputItem = item;
            display.asyncExec(new Runnable(){

                public void run() {
                    OutputView.this.actionsTable.refresh();
                    OutputView.this.updateContentForNewSelectedItem(outputItem);
                    OutputView.this.showParametersPage();
                    OutputView.this.actionsTable.selectItem(outputItem);
                }
            });
        }
    }

    protected void updateMessage(OutputItem item) {
        this.nameLabel.setText(item.getUniqueName());
        this.nameLabel.setToolTipText(item.getUniqueName());
        if (item.getMessages() != null) {
            this.messageArea.setText(item.getMessages());
            this.messageArea.setTopIndex(this.messageArea.getLineCount());
        }
        this.nameLabel.pack();
    }

    protected void updateResults(OutputItem item) {
        if (item.hasResults()) {
            ResultTableModel tabModel = model.getResultTableModel(item);
            this.resultViewer.setTableModel(tabModel);
            this.resultViewer.refresh();
        } else {
            this.clearResults();
        }
        this.updateArrows(item);
    }

    protected void updateParameters(OutputItem item) {
        this.updateParameters(item, model.getParameters(item));
    }

    protected void updateParameters(OutputItem item, Vector parms) {
        if (item.hasParameters() && parms != null && !parms.isEmpty()) {
            if (this.parameters.isEmpty() || parms.get(0) != this.parameters.get(0)) {
                this.clearParameters();
                this.parameters.addAll(parms);
                this.parmsTable.refresh();
                this.addParamButtons();
            }
        } else {
            this.clearParameters();
        }
    }

    protected void updateContentForNewSelectedItem(OutputItem item) {
        this.updateMessage(item);
        this.updateParameters(item);
        this.updateResults(item);
        Iterator tabKeyIterator = contributedTabOrder.iterator();
        while (tabKeyIterator.hasNext()) {
            String id = (String)tabKeyIterator.next();
            IAdditionalOutputViewTab tab = (IAdditionalOutputViewTab)contributedTabs.get(id);
            if (!item.hasContents(id)) continue;
            tab.clearContents();
            tab.setContents(this.getModel().getContents(item, id));
            tab.refresh();
        }
    }

    protected void replaceMessage(OutputItem item, String msg) {
        this.replaceMessage(item, msg, false);
    }

    protected void replaceMessage(OutputItem item1, String msg1, boolean async) {
        this.item = item1;
        this.msg = msg1;
        if (model.outputItemExists(this.item)) {
            if (async) {
                if (this.displayArea == null) {
                    return;
                }
                Display display = this.displayArea.getDisplay();
                if (display != null) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            OutputView.this.item.setMessage(OutputView.this.msg);
                            OutputView.this.updateMessage(OutputView.this.item);
                            OutputView.this.actionsTable.selectItem(OutputView.this.item);
                        }
                    });
                }
            } else {
                this.item.setMessage(this.msg);
                this.updateMessage(this.item);
                this.actionsTable.selectItem(this.item);
            }
        }
    }

    protected void clearMessages(OutputItem item) {
        if (model.outputItemExists(item)) {
            item.setMessage("");
            this.updateMessage(item);
            this.actionsTable.selectItem(item);
        }
    }

    protected void clearOutputPages() {
        this.messageArea.setText("");
        this.nameLabel.setText("");
        this.nameLabel.setToolTipText("");
        this.nameLabel.pack();
        this.clearParameters();
        this.clearResults();
    }

    protected void clearParameters() {
        this.parameters.clear();
        if (this.longParams != null) {
            Iterator iterLongParams = this.longParams.iterator();
            while (iterLongParams.hasNext()) {
                LongParamControls longParamCtls = (LongParamControls)iterLongParams.next();
                Iterator iter = longParamCtls.getEditorCells().iterator();
                while (iter.hasNext()) {
                    ((TableEditor)iter.next()).dispose();
                }
                iter = longParamCtls.getEditorButtons().iterator();
                while (iter.hasNext()) {
                    ((Button)iter.next()).dispose();
                }
            }
            this.longParams.clear();
        }
        this.parmsTable.refresh();
    }

    protected void clearResults() {
        this.resultViewer.clearResult();
        this.resultViewer.setTableModel(null);
        this.resultViewer.refresh();
    }

    protected void clearParameters(OutputItem item) {
        this.actionsTable.selectItem(item);
        this.clearParameters();
    }

    protected void clearResults(OutputItem item) {
        this.actionsTable.selectItem(item);
        this.resultViewer.clearResult();
        this.resultViewer.setTableModel(null);
        this.resultViewer.refresh();
    }

    protected void refreshActionTable(OutputItem item) {
        this.refreshActionTable(item, false);
    }

    protected void refreshActionTable(OutputItem item1, boolean async) {
        this.item = item1;
        if (async) {
            if (this.displayArea == null) {
                return;
            }
            Display display = this.displayArea.getDisplay();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        OutputView.this.actionsTable.selectItem(OutputView.this.item);
                    }
                });
            }
        } else {
            this.actionsTable.selectItem(this.item);
        }
    }

    protected void updateArrows(OutputItem item) {
        if (item != null && item.hasResults() && this.isResultsTabSelected()) {
            if (model.isLastResultSet(item)) {
                this.rightArrowB.setEnabled(false);
            } else {
                this.rightArrowB.setEnabled(true);
            }
            if (model.isFirstResultSet(item)) {
                this.leftArrowB.setEnabled(false);
            } else {
                this.leftArrowB.setEnabled(true);
            }
            this.arrowPane.pack();
        } else {
            this.disableArrows();
        }
    }

    protected void disableArrows() {
        this.leftArrowB.setEnabled(false);
        this.rightArrowB.setEnabled(false);
        this.arrowPane.pack();
    }

    protected void refreshWithDefault() {
        if (model.isActionListEmpty()) {
            this.actionsTable.refresh();
            this.clearOutputPages();
        } else {
            this.actionsTable.selectItem(0);
            this.updateContentForNewSelectedItem(model.getItem(0));
            this.showMessagePage();
        }
    }

    protected void showMessagePage() {
        this.showMessagePage(false);
    }

    protected void showMessagePage(boolean async) {
        if (async) {
            if (this.displayArea == null) {
                return;
            }
            Display display = this.displayArea.getDisplay();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        OutputView.this.pageArea.setSelection(0);
                        OutputView.this.disableArrows();
                    }
                });
            }
        } else {
            this.pageArea.setSelection(0);
            this.disableArrows();
        }
    }

    protected void showParametersPage() {
        this.showParametersPage(false);
    }

    protected void showParametersPage(boolean async) {
        if (async) {
            if (this.displayArea == null) {
                return;
            }
            Display display = this.displayArea.getDisplay();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        OutputView.this.pageArea.setSelection(1);
                        OutputView.this.disableArrows();
                    }
                });
            }
        } else {
            this.pageArea.setSelection(1);
            this.disableArrows();
        }
    }

    protected void showResultsPage() {
        this.showResultsPage(false);
        OutputItem item = this.actionsTable.getSelectedItem();
        this.updateArrows(item);
    }

    protected void showResultsPage(boolean async) {
        if (async) {
            if (this.displayArea == null) {
                return;
            }
            Display display = this.displayArea.getDisplay();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        OutputView.this.pageArea.setSelection(2);
                    }
                });
            }
        } else {
            this.pageArea.setSelection(2);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        try {
            if (source.equals(this.actionsTable.getTable())) {
                OutputItem item = this.actionsTable.getSelectedItem();
                this.displayArea.setVisible(false);
                this.updateContentForNewSelectedItem(item);
                this.showMessagePage();
                this.displayArea.setVisible(true);
            } else if (source.equals(this.leftArrowB)) {
                OutputItem item = this.actionsTable.getSelectedItem();
                if (item != null) {
                    model.getPreviousResultSetModel(item);
                    this.displayArea.setVisible(false);
                    this.updateResults(item);
                    this.updateArrows(item);
                    this.displayArea.setVisible(true);
                }
            } else if (source.equals(this.rightArrowB)) {
                OutputItem item = this.actionsTable.getSelectedItem();
                if (item != null) {
                    model.getNextResultSetModel(item);
                    this.displayArea.setVisible(false);
                    this.updateResults(item);
                    this.updateArrows(item);
                    this.displayArea.setVisible(true);
                }
            } else if (source == this.pageArea) {
                OutputItem item = this.actionsTable.getSelectedItem();
                this.updateArrows(item);
            } else if (source instanceof CTabFolder && ((CTabFolder)source).getSelectionIndex() == 2) {
                this.updateArrows(this.actionsTable.getSelectedItem());
            }
        }
        catch (SQLException ex) {
            OutputViewPlugin.getPlugin().writeLog(4, 0, "OutputView:widgetSelected()", ex);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    private boolean isResultsTabSelected() {
        TabItem selectedItem;
        int index = this.pageArea.getSelectionIndex();
        return index > -1 && (selectedItem = this.pageArea.getItem(index)) == this.resultsTab;
    }

    public void setFocus() {
        if (this.actionsTable != null) {
            this.actionsTable.getTable().setFocus();
        }
    }

    public void dispose() {
        this.parameters = null;
        this.resultViewer = null;
        this.actionsTable = null;
        super.dispose();
    }

    protected void addParamButtons() {
        LongParamControls longParamCtls = new LongParamControls(1);
        this.longParams.add(longParamCtls);
        longParamCtls = new LongParamControls(2);
        this.longParams.add(longParamCtls);
        int i = 0;
        while (i < this.parameters.size()) {
            String[] param = (String[])this.parameters.get(i);
            TableItem[] items = this.parmsTable.getTable().getItems();
            if (param[1] != null && param[1].length() > 60) {
                this.setParamButton(i, items, (LongParamControls)this.longParams.get(0));
            }
            if (param[2] != null && param[2].length() > 60) {
                this.setParamButton(i, items, (LongParamControls)this.longParams.get(1));
            }
            ++i;
        }
        this.parmsTable.getTable().layout(true);
        this.redrawTable();
    }

    protected void setParamButton(int i, TableItem[] items, LongParamControls longParamCtls) {
        TableItem item = items[i];
        Table table = this.parmsTable.getTable();
        TableEditor tableEditor = new TableEditor(table);
        Button colButton = new Button((Composite)table, 8);
        colButton.setToolTipText(OutputViewPlugin.getString("OV_LOB_COLUMN_TOOLTIP"));
        colButton.setText(BUTTON_TEXT);
        colButton.setSize(colButton.computeSize(-1, -1));
        colButton.setData((Object)new Integer(i));
        tableEditor.horizontalAlignment = 131072;
        tableEditor.minimumWidth = colButton.computeSize((int)-1, (int)-1).x;
        tableEditor.setEditor((Control)colButton, item, longParamCtls.getColumnIndex());
        longParamCtls.getEditorCells().add(tableEditor);
        longParamCtls.getEditorButtons().add(colButton);
        colButton.addSelectionListener((SelectionListener)longParamCtls.getListener());
    }

    protected void redrawTable() {
        this.parmsTable.getTable().layout();
        this.parmsTable.getTable().getParent().layout();
        this.parmsTable.getTable().setSize(this.parmsTable.getTable().getSize().x + 1, this.parmsTable.getTable().getSize().y);
        this.parmsTable.getTable().setSize(this.parmsTable.getTable().getSize().x - 1, this.parmsTable.getTable().getSize().y);
    }

    public void showContents(OutputItem item, String id, boolean async) {
        if (async) {
            this.showContents(item, id, null);
        } else {
            this.actionsTable.refresh();
            this.updateContentForNewSelectedItem(item);
            this.showContentsPage(id);
            this.actionsTable.selectItem(item);
        }
    }

    public void showContents(OutputItem item, final String id, Object contents) {
        Display display;
        if (contents != null) {
            this.getModel().addContents(item, id, contents);
        }
        if ((display = this.displayArea.getDisplay()) != null) {
            final OutputItem outputItem = item;
            display.asyncExec(new Runnable(){

                public void run() {
                    OutputView.this.actionsTable.refresh();
                    OutputView.this.updateContentForNewSelectedItem(outputItem);
                    OutputView.this.showContentsPage(id);
                    OutputView.this.actionsTable.selectItem(outputItem);
                }
            });
        }
    }

    protected void showContentsPage(String id) {
        this.showContentsPage(id, false);
    }

    protected void showContentsPage(final String id, boolean async) {
        if (async) {
            if (this.displayArea == null) {
                return;
            }
            Display display = this.displayArea.getDisplay();
            if (display != null) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        OutputView.this.pageArea.setSelection(OutputView.this.getPageIndex(id));
                    }
                });
            }
        } else {
            this.pageArea.setSelection(this.getPageIndex(id));
        }
    }

    protected int getPageIndex(String id) {
        int index = -1;
        int i = 1;
        Iterator tabIDIterator = contributedTabOrder.iterator();
        while (tabIDIterator.hasNext()) {
            String tabID = (String)tabIDIterator.next();
            if (id.equals(tabID)) {
                index = 2 + i;
                break;
            }
            ++i;
        }
        return index;
    }

    protected class ButtonListener
    extends SelectionAdapter {
        protected ButtonListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            LongParamControls longParamCtls = null;
            Iterator iterLongParams = OutputView.this.longParams.iterator();
            while (iterLongParams.hasNext()) {
                longParamCtls = (LongParamControls)iterLongParams.next();
                if (longParamCtls.getListener() == this) break;
            }
            Button button = (Button)e.widget;
            int i = (Integer)button.getData();
            String[] param = (String[])OutputView.this.parameters.get(i);
            String title = longParamCtls.getColumnIndex() == 1 ? String.valueOf(param[0]) + " - " + input : String.valueOf(param[0]) + " - " + output;
            boolean truncated = param[3].equals("1");
            Document doc = OutputView.this.resultViewer.parseXMLText(param[longParamCtls.getColumnIndex()]);
            if (doc != null) {
                DialogShowXMLField xmlDialog = new DialogShowXMLField(OutputView.this.pageArea.getShell(), title, param[longParamCtls.getColumnIndex()]);
                xmlDialog.open();
            } else {
                DialogShowLongField ddlDialog = new DialogShowLongField(OutputView.this.pageArea.getShell(), title, param[longParamCtls.getColumnIndex()], truncated);
                ddlDialog.open();
            }
        }
    }

    protected class LongParamControls {
        protected ArrayList editorCells;
        protected ArrayList editorButtons;
        protected ButtonListener listener;
        protected int colIndex;

        public LongParamControls(int aColIndex) {
            this.colIndex = aColIndex;
            this.editorCells = new ArrayList();
            this.editorButtons = new ArrayList();
            this.listener = new ButtonListener();
        }

        public ArrayList getEditorCells() {
            return this.editorCells;
        }

        public ArrayList getEditorButtons() {
            return this.editorButtons;
        }

        public ButtonListener getListener() {
            return this.listener;
        }

        public int getColumnIndex() {
            return this.colIndex;
        }
    }

    protected class ParmsTableContentProvider
    implements IStructuredContentProvider {
        protected ParmsTableContentProvider() {
        }

        public Object[] getElements(Object collection) {
            if (collection instanceof Vector) {
                return ((Vector)collection).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }
    }

    protected class ParmsTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ParmsTableLabelProvider() {
        }

        public String getColumnText(Object parmRow, int columnIndex) {
            if (parmRow instanceof String[]) {
                String[] row = (String[])parmRow;
                if (row[columnIndex] == null) {
                    return "";
                }
                return row[columnIndex];
            }
            return "";
        }

        public Image getColumnImage(Object outputItem, int columnIndex) {
            return null;
        }
    }
}

