#include "statusDialog.h"
#include <gtk/gtk.h>

GtkWidget *statusDialog;
GtkWidget *statusBar;
int progressMinimum,progressMaximum;

void showStatusDialog(char *title,int low,int high)
{
	GtkAdjustment *adjustment;

	statusDialog=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width(GTK_CONTAINER(statusDialog),10);
	gtk_window_set_title(GTK_WINDOW(statusDialog),title);
	
	progressMinimum=low;
	progressMaximum=high;
	
	adjustment=GTK_ADJUSTMENT(gtk_adjustment_new(low,low,high,1,1,1));
	statusBar=gtk_progress_bar_new_with_adjustment(adjustment);
	gtk_container_add(GTK_CONTAINER(statusDialog),statusBar);
	gtk_widget_show(statusBar);

	gtk_widget_show_now(statusDialog);
}

void hideStatusDialog()
{
	gtk_widget_hide(statusDialog);
	gtk_widget_destroy(statusDialog);
}

void setStatus(int value)
{
	gfloat percentage;
	
	percentage=((float)value)/((float)progressMaximum);
	gtk_progress_bar_update(GTK_PROGRESS_BAR(statusBar),percentage);
	gtk_widget_show_now(statusDialog);
	gtk_main_iteration();
}
