#include "optionDialog.h"
#include "wmOptions.h"
#include "mainWidget.h"
#include "uninstallWidget.h"
#include "installWidget.h"
#include "dirBrowser.h"
#include <gtk/gtk.h>

GtkWidget *optionDialog;
GtkWidget *globalEntry,*userEntry;
GtkWidget *defaultEntry;
GtkWidget *radioButton1,*radioButton2;
GtkWidget *removeThemeCheckButton;
int 	  isMainWidget;

void optionOkClicked(gpointer data)
{
	struct stWMOptions *options;
	char systemPath[PATH_MAX];
	char userPath[PATH_MAX];
	int error;
			
	options=(struct stWMOptions *)data;
	
	if (GTK_TOGGLE_BUTTON(radioButton1)->active) {
		options->installType=GLOBAL_INSTALL;
	} else {
		options->installType=LOCAL_INSTALL;
	}
	if (GTK_TOGGLE_BUTTON(removeThemeCheckButton)->active) {
		options->removeTheme=REMOVE_THEME;
	} else {
		options->removeTheme=LEAVE_THEME;
	}
	strcpy(options->defaultDirectory,gtk_entry_get_text(GTK_ENTRY(defaultEntry)));
	strcpy(options->globalInstallPath,gtk_entry_get_text(GTK_ENTRY(globalEntry)));
	strcpy(options->userInstallPath,gtk_entry_get_text(GTK_ENTRY(userEntry)));
	error=writeOptions(options);
	if (error==WMOPTERR_UNABLETOWRITE) {
		showMessageDialog("Error","Unable to write to the options file\nat ~/.themeinstaller/wmoptions\n\nPlease check that the file exists and\nyou have write permissions.");
	} else {	
		if (isMainWidget==1) {
			/* Reread the options file, so we can check and make sure
			   the global install path exists */
			getOptions(options);
			/* Check to make sure the global install path is valid */
			if (options->globalInstallPath[0]!=0) {
				/* Hide the options dialog */
				gtk_widget_hide(optionDialog);
				strncpy(systemPath,options->globalInstallPath,PATH_MAX);
				strncat(systemPath,"Themes",PATH_MAX-strlen(options->globalInstallPath));
				strncpy(userPath,options->userInstallPath,PATH_MAX);
				strncat(userPath,"Themes",PATH_MAX-strlen(options->userInstallPath));
				createMainWidget();
				updateInstalledTree(systemPath,userPath);
				setInstallPath(options->defaultDirectory);
			} else {
				showMessageDialog("Error","Unable to locate WindowMaker\nPlease check your Global Install Directory.\n");
			}
		} else {
			/* Hide the options dialog */
			gtk_widget_hide(optionDialog);
		}
	}
}

void optionCancelClicked(gpointer data)
{
	struct stWMOptions *options;
	
	options=(struct stWMOptions *)data;
	gtk_widget_hide(optionDialog);
	gtk_entry_set_text(GTK_ENTRY(defaultEntry),options->defaultDirectory);
	gtk_entry_set_text(GTK_ENTRY(globalEntry),options->globalInstallPath);
	gtk_entry_set_text(GTK_ENTRY(userEntry),options->userInstallPath);
	if (options->installType==GLOBAL_INSTALL) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioButton1),TRUE);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(radioButton2),TRUE);
	}
	if (options->removeTheme==REMOVE_THEME) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(removeThemeCheckButton),TRUE);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(removeThemeCheckButton),FALSE);
	}
	if (isMainWidget==1) gtk_main_quit();
}

void gotBrowseGlobal(gpointer data)
{
	gtk_entry_set_text(GTK_ENTRY(globalEntry),(char *)data);
}

void browseGlobalShow(gpointer data)
{
	showDirBrowser(GTK_SIGNAL_FUNC(gotBrowseGlobal),gtk_entry_get_text(GTK_ENTRY(globalEntry)));
}

void gotBrowseUser(gpointer data)
{
	gtk_entry_set_text(GTK_ENTRY(userEntry),(char *)data);
}

void browseUserShow(gpointer data)
{
	showDirBrowser(GTK_SIGNAL_FUNC(gotBrowseUser),gtk_entry_get_text(GTK_ENTRY(userEntry)));
}

void gotBrowseDefault(gpointer data)
{
	gtk_entry_set_text(GTK_ENTRY(defaultEntry),(char *)data);
}

void browseDefaultShow(gpointer data)
{
	showDirBrowser(GTK_SIGNAL_FUNC(gotBrowseDefault),gtk_entry_get_text(GTK_ENTRY(defaultEntry)));
}

void initializeOptionDialog(struct stWMOptions *options)
{
	GtkWidget *okButton;
	GtkWidget *cancelButton;
	GtkWidget *label;
	GtkWidget *hbox;
	GtkWidget *rbutton1,*rbutton2;
	GtkWidget *defaultBrowseButton;
	GtkWidget *globalBrowseButton;
	GtkWidget *userBrowseButton;
	GSList *rgroup;
	
	/* Create the new dialog box */
	optionDialog=gtk_dialog_new();
	gtk_window_set_title(GTK_WINDOW(optionDialog),"Options");
	
	/* Create the buttons */
	okButton=gtk_button_new_with_label("Ok");
	cancelButton=gtk_button_new_with_label("Cancel");
	
	/* Add the buttons to the dialogs action area */
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(optionDialog)->action_area),okButton,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(optionDialog)->action_area),cancelButton,TRUE,TRUE,0);
	gtk_widget_show(okButton);
	gtk_widget_show(cancelButton);
	
	/* Connect the buttons to the appropriate actions */
	gtk_signal_connect_object(GTK_OBJECT(okButton),"clicked",GTK_SIGNAL_FUNC(optionOkClicked),(gpointer)options);
	gtk_signal_connect_object(GTK_OBJECT(cancelButton),"clicked",GTK_SIGNAL_FUNC(optionCancelClicked),(gpointer)options);
	
	/* Create a horizontal box to hold the label and entry fields */
	hbox=gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(optionDialog)->vbox),hbox,TRUE,TRUE,5);
	gtk_widget_show(hbox);
	
	/* Create the label for the global */
	label=gtk_label_new("Default Directory:");
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,5);
	gtk_widget_show(label);
	
	/* Create the text entry widget for the default directory */
	defaultEntry=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox),defaultEntry,TRUE,TRUE,5);
	gtk_entry_set_text(GTK_ENTRY(defaultEntry),options->defaultDirectory);
	gtk_widget_show(defaultEntry);
	gtk_widget_grab_focus(defaultEntry);
	
	/* Create the browse button for the default directory */
	defaultBrowseButton=gtk_button_new_with_label("Browse");
	gtk_box_pack_start(GTK_BOX(hbox),defaultBrowseButton,TRUE,TRUE,5);
	gtk_signal_connect_object(GTK_OBJECT(defaultBrowseButton),"clicked",GTK_SIGNAL_FUNC(browseDefaultShow),NULL);
	gtk_widget_show(defaultBrowseButton);
		
	/* Create a horizontal box to hold the label and entry fields */
	hbox=gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(optionDialog)->vbox),hbox,TRUE,FALSE,5);
	gtk_widget_show(hbox);
	
	/* Create the label for the global */
	label=gtk_label_new("Global Install Directory:");
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,5);
	gtk_widget_show(label);
	
	/* Create the text entry widget for the global */
	globalEntry=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox),globalEntry,FALSE,FALSE,5);
	gtk_entry_set_text(GTK_ENTRY(globalEntry),options->globalInstallPath);
	gtk_widget_show(globalEntry);
	
	/* Create the browse button for the global */
	globalBrowseButton=gtk_button_new_with_label("Browse");
	gtk_box_pack_start(GTK_BOX(hbox),globalBrowseButton,TRUE,TRUE,5);
	gtk_signal_connect_object(GTK_OBJECT(globalBrowseButton),"clicked",GTK_SIGNAL_FUNC(browseGlobalShow),NULL);
	gtk_widget_show(globalBrowseButton);
	
	/* Create a horizontal box to hold the label and entry fields */
	hbox=gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(optionDialog)->vbox),hbox,TRUE,TRUE,5);
	gtk_widget_show(hbox);
	
	/* Create the label for the user */
	label=gtk_label_new("User Install Directory:");
	gtk_box_pack_start(GTK_BOX(hbox),label,FALSE,FALSE,5);
	gtk_widget_show(label);
	
	/* Create the text entry widget for the user */
	userEntry=gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox),userEntry,TRUE,TRUE,5);
	gtk_entry_set_text(GTK_ENTRY(userEntry),options->userInstallPath);
	gtk_widget_show(userEntry);

	/* Create the browse button for the user */
	userBrowseButton=gtk_button_new_with_label("Browse");
	gtk_box_pack_start(GTK_BOX(hbox),userBrowseButton,TRUE,TRUE,5);
	gtk_signal_connect_object(GTK_OBJECT(userBrowseButton),"clicked",GTK_SIGNAL_FUNC(browseUserShow),NULL);
	gtk_widget_show(userBrowseButton);
		
	/* Create a horizontal box to hold the radio buttons */
	hbox=gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(optionDialog)->vbox),hbox,TRUE,TRUE,5);
	gtk_widget_show(hbox);
	
	/* Create a label for the installation type */
	label=gtk_label_new("Installation Type:");
	gtk_box_pack_start(GTK_BOX(hbox),label,TRUE,TRUE,5);
	gtk_widget_show(label);
	
	/* Create the radio button group and buttons */
	rbutton1=gtk_radio_button_new_with_label(NULL,"Global");
	gtk_box_pack_start(GTK_BOX(hbox),rbutton1,TRUE,TRUE,5);
	gtk_widget_show(rbutton1);
	rgroup=gtk_radio_button_group(GTK_RADIO_BUTTON(rbutton1));
	rbutton2=gtk_radio_button_new_with_label(rgroup,"User");
	gtk_box_pack_start(GTK_BOX(hbox),rbutton2,TRUE,TRUE,5);
	gtk_widget_show(rbutton2);
	if (options->installType==GLOBAL_INSTALL) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rbutton1),TRUE);
	} else {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(rbutton2),TRUE);
	}
	radioButton1=rbutton1;
	radioButton2=rbutton2;
	
	/* Create a horizontal box to hold the check button */
	hbox=gtk_hbox_new(FALSE,5);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(optionDialog)->vbox),hbox,TRUE,TRUE,5);
	gtk_widget_show(hbox);

	/* Create the remove theme check button */
	removeThemeCheckButton=gtk_check_button_new_with_label("Remove theme file after installation");
	gtk_box_pack_start(GTK_BOX(hbox),removeThemeCheckButton,TRUE,FALSE,5);
	gtk_widget_show(removeThemeCheckButton);
	if (options->removeTheme==REMOVE_THEME) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(removeThemeCheckButton),TRUE);
	}
	
	gtk_window_set_modal(GTK_WINDOW(optionDialog),TRUE);
}

void showOptionDialog(int mainWindow)
{
	isMainWidget=mainWindow;
	gtk_widget_show(optionDialog);
	if (isMainWidget==1) {
		showMessageDialog("Error","Unable to find WindowMaker\nPlease update your Global Install Directory");
	}
}
