#include "msgDialog.h"
#include <gtk/gtk.h>

void showMessageDialog(char *title,char *message)
{
	GtkWidget *msgDialog;
	GtkWidget *label;
	GtkWidget *okButton;
	GtkWidget *frame;
	GtkWidget *vbox;

	/* Create the dialog box */
	msgDialog=gtk_dialog_new();
	/* Set the title of the widget */
	gtk_window_set_title(GTK_WINDOW(msgDialog),title);
	
	frame=gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(msgDialog)->vbox),
		frame,TRUE,TRUE,0);
	gtk_widget_show(frame);
	
	vbox=gtk_vbox_new(TRUE,TRUE);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),5);
	gtk_container_add(GTK_CONTAINER(frame),vbox);
	gtk_widget_show(vbox);

	/* Create the ok button */
	okButton=gtk_button_new_with_label("Okay");
	/* Place the ok button in the dialog's action area */
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(msgDialog)->action_area),okButton,
		TRUE,TRUE,0);
	/* Connect the button press to the dialog's destroy call */
	gtk_signal_connect_object(GTK_OBJECT(okButton),"clicked",
		GTK_SIGNAL_FUNC(gtk_widget_destroy),GTK_OBJECT(msgDialog));
	/* Show the ok button */
	gtk_widget_show(okButton);
	
	/* Create the label */
	label=gtk_label_new(message);
	gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(msgDialog)->vbox),5);
	/* Place the label in the dialog's vertical box */
	gtk_box_pack_start(GTK_BOX(vbox),label,TRUE,TRUE,0);
	/* Show the label */
	gtk_widget_show(label);
	
	/* Set the dialog to modal mode */
	gtk_window_set_modal(GTK_WINDOW(msgDialog),TRUE);
	/* Show the dialog */
	gtk_widget_show(msgDialog);
}