#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tarutil.h"
#include "statusDialog.h"
#include "install.h"

int checkExtension(char *);
int checkTheme(char *);
void getFirstName(char *,char *);

#define COMMAND_MAX	PATH_MAX+256

struct stDirll *getDirectoryList(char *pathname)
{
	DIR *thisDir=NULL;
	struct stDirll *first,*current;
	struct stDirll *fileFirst;
	char filename[256];
	struct dirent *dirEntry;
	struct stat *fileStat;
	int type;
	int count=0;
	int totalFiles=0;
	
	/* Allocate memory for the file stat structure */
	fileStat=(struct stat *)malloc(sizeof(struct stat));
	first=current=NULL;
	fileFirst=NULL;
	
	
	/* Open up the directory */
	thisDir=opendir(pathname);
	if (thisDir==NULL) {
		printf("Unable to open directory: %s\n",pathname);
		return;
	}
	/* Add all the directories to the list first */
	while ((dirEntry=readdir(thisDir))!=NULL) {
		getFilename(filename,pathname,dirEntry->d_name);
		stat(filename,fileStat);
		if ((S_ISDIR(fileStat->st_mode))&&(strcmp(dirEntry->d_name,".")!=0)) {
			current=addDirectoryEntry(&first,dirEntry->d_name);
			current->type=DIRECTORY;
		}
		totalFiles++;
	}
	if (current==NULL) return (NULL);
	showStatusDialog("Checking directory...",1,totalFiles);
	rewinddir(thisDir);
	while ((dirEntry=readdir(thisDir))!=NULL) {
		getFilename(filename,pathname,dirEntry->d_name);
		stat(filename,fileStat);
		if ((S_ISREG(fileStat->st_mode))&&
			 (checkExtension(dirEntry->d_name)) &&
		     (type=checkTheme(filename))) {
			current=addDirectoryEntry(&fileFirst,dirEntry->d_name);
			current->type=100+type;
/*			if (S_ISDIR(fileStat->st_mode)) current->type=DIRECTORY;
			if (S_ISREG(fileStat->st_mode)) current->type=THEME_FILE;*/
		}
		setStatus(++count);
	}
	closedir(thisDir);

	/* Append the filelist to the end of the directory list */
	if (first!=NULL) current=first;
	if (current!=NULL) {
		while (current->next!=NULL) current=current->next;
		current->next=fileFirst;
	}
	
	hideStatusDialog();
	
	return first;
}

struct stDirll *addDirectoryEntry(struct stDirll **pFirst,char *filename)
{
	struct stDirll *temp, *seeknode, *seeknode_last;
	
	temp=(struct stDirll *)malloc(sizeof(struct stDirll));
	strncpy(temp->filename,filename,256);
	
	seeknode_last=NULL;
	seeknode=*pFirst;
	while ((seeknode!=NULL) && strncasecmp(seeknode->filename,filename,256) < 0) {
		seeknode_last=seeknode;
		seeknode=seeknode->next;
	}
	temp->next=seeknode;
	if (!seeknode_last) {
		*pFirst=temp;
	} else {
		seeknode_last->next=temp;
	}
	return temp;
}

void getFilename(char *filename,char *pathname,char *shortname)
{
	strcpy(filename,pathname);
	strcat(filename,shortname);
}

/* This function checks to make sure it has a correct .tar.gz 
   extension */
int checkExtension(char *filename)
{
    int retValue=0;
	int length;
	
	length=strlen(filename);
	/* If the length of the string is greater then 7 */
	if (length>7) {
		if (strcmp(".tar.gz",&filename[length-7])==0) retValue=1;
	}
	
	return retValue;
}

void getFirstName(char *filename,char *name)
{
	int pos;
	int namePos;
	
	if (filename[0]=='/') pos=1;
	else pos=0;
	namePos=0;
	
	while ((filename[pos]!='\0')&&(filename[pos]!='/')) {
		name[namePos]=filename[pos];
		pos++;
		namePos++;
	}
	name[namePos]='\0';
}

/* This function checks to see if it is a theme file by looking
   to see if the archive has a "Themes/" directory */
int checkTheme(char *filename)
{
	char command[256];
	char buffer[256];
	char tempBuffer[15];
	int length=0;
	TarFileList *fileList=NULL;
	
	fileList=getFileList(filename);

	while (fileList!=NULL) {
		strncpy(buffer,fileList->filename,sizeof(buffer));
		length=strlen(buffer);
		if (length>7) {
			strncpy(tempBuffer,buffer,7);
			tempBuffer[7]='\0';
			if (strcmp(tempBuffer,"Themes/")==0) {
				return (1);
			}
			getFirstName(buffer,tempBuffer);
			if (strchr(tempBuffer,'.')!=NULL) {
				if (strncmp(strchr(tempBuffer,'.'),".themed",7)==0) {
					return (2);
				}
			}
		}
		fileList=fileList->next;
	}
	
	return (0);
}

struct stDirll *getEntryByName(struct stDirll *first,char *name)
{
	struct stDirll *current;
	
	current=first;
	while ((current!=NULL)&&(strcmp(current->filename,name)!=0)) {
		current=current->next;
	}

	return current;
}

/* -- DEBUG SECTION -- */
void printDirectoryEntries(struct stDirll *first)
{
	struct stDirll *current;
	
	current=first;
	while (current!=NULL) {
		printf("%s\n",current->filename);
		current=current->next;
	}
}

void installTheme(char *filename,char *location)
{
	untar(filename,location);
}
