#  wmtheme update support

my %rdfcache = ();
my $cachenames = '';

sub init_update_management {

  unless ($tosite) {
    choke("Sorry, cannot update $wm_name themes.");
  }

  include_wmcode('wm_download.pl');
  scan_themes();

  if (!-d $wmthemedir) {
    print "In order to keep track of themes' last updates, the directory\n";
    print "$home/.wmtheme must be created to store theme information.\n";
    print "Do you want this directory created now? [Y/n] ";
    return unless ask_setup();
  }

}

sub _manage_themes {
  my @themes = @ARGV;
  @ARGV = ();
  my (@eligible, $themename, %found);

  init_update_management();

  if (@themes) {
    foreach (@themes) {
      $themename = identify_installed_theme($_);
      if ($themename =~ /\// or ($themes{$themename}{'owner'} != $> and $>)) {
        print "$programname: can't manage \"$themename\"\n";
      } else {
        push @eligible, $themename unless $found{$themename};
        $found{$themename} = 1;
      }
    }
    if (!@eligible) {
      print "$programname: no eligible themes specified\n";
      return;
    }
  } else {
    foreach (sort keys %themes) {
      if (!/\// and ($themes{$_}{'owner'} == $> or !$>)) {
        push @eligible, $_;
      }
    }
  }

  if (!@eligible) {
    print "$programname: there are no themes that can be managed by this user\n";
    return;
  }

  identify_themerecs(@eligible);
  $loginfo{'hasupdated'} = 1;
  $themedata_modified = 1;
}

sub _update_themes {
  my (@eligible, @updatable, $answer, $theme, $maxlen, $queryname, $tempdir,
    $filename, $tempname, $i, $newpath, $setname, $my_updated);

  init_update_management();

  foreach (sort keys %themes) {
      ## skipping names that contain '/' prevents attempts
      ## to update IceWM subthemes
    if (!m|/| and ($themes{$_}{'owner'} == $> or !$>)) {
      if (update_eligible($_)) {
        push @updatable, $_;
      }
      push @eligible, $_;
    }
  }

  if (!$loginfo{'hasupdated'}) {

      ##  First time updating; must find out which ones to update

    print "\n ***  First time updating for $programname  ***\n\n";
    print "Updating themes requires that they be positively identified on themes.org.\n";
    print "The identification process only needs to be done once. Any themes that you\n";
    print "install with '-g' will be recorded in the log.\n\n";
    print "However, themes that are installed with -i or -I will not be recorded in\n";
    print "this way. You can run 'wmtheme --manage' if you install some that way, and\n";
    print "want to identify them later.\n\n";
    print "How do you want to deal with the currently installed themes?\n\n";
    print "  a. Ask about each theme, to identify it, or to exclude it from updating.\n";
    print "  b. None of the currently installed themes are subject to updating.\n";
    print "  q. Quit.\n: ";
    $answer = <STDIN>;
    if ($answer =~ /^[aA]/) {
      push @updatable, identify_themerecs(@eligible);
      $loginfo{'hasupdated'} = 1;
      $themedata_modified = 1;
    } elsif ($answer =~ /^[bB]/) {
      $loginfo{'hasupdated'} = 1;
      $themedata_modified = 1;
      foreach (@updatable) {
        $themes{$_}{'updatable'} = 'no';
      }
      finish('All current themes have been marked non-updatable.');
    } else {
      finish('Update cancelled.');
    }
  }

  if (!@updatable) {
    print "$programname: there are no themes eligible for updating.\n";
    return;
  }

  $maxlen = getmaxlen(@updatable);

  foreach $theme (@updatable) {
    print ' ' x ($maxlen - length($theme) + 2), "$theme... ";
    if (update_eligible($theme)) {
      $queryname = $themes{$theme}{'origname'};
      if (!exists $rdfcache{$queryname}) {
        update_rdfquery('themeid', $themes{$theme}{'id'});
        if (! exists $rdfcache{$queryname}) {
          print "\n";
          complain("$programname: can't locate \"$queryname\" ($theme) on themes.org!");
          next;
        }
      }
      if ($rdfcache{$queryname}{'id'} ne $themes{$theme}{'id'}) {
        complain
          ("$programname: Warning - themes.org's \"$queryname\" has id $rdfcache{$queryname}{'id'},",
          "  but $theme's id is $themes{$theme}{'id'}.  SKIPPING.");
        next;
      }
    } else {
      print "\n";
      complain("$programname: Internal error - original name of \"$theme\" not known!");
      next;
    }

    if ($themes{$theme}{'local_updated'}) {
      $my_updated = $themes{$theme}{'local_updated'};
    } else {
      $my_updated = $themes{$theme}{'mtime'};
    }

    if ($my_updated < $rdfcache{$queryname}{'updated'}) {
      print "UPDATING.\n";
      print "       local: " . localtime($my_updated) . "\n";
      print "  themes.org: " .
        localtime($rdfcache{$queryname}{'updated'}) . "\n";
      if (!exists $rdfcache{$queryname}{'link'}) {
        complain("$programname: didn't retrieve a download link!");
        next;
      }

        ## Please note - if the user has upgraded their window manager
        ## and/or the theme author has released an update for a later
        ## version of the window manager, and a version of the theme
        ## is available that's more suited, it will automatically be in
        ## the 'link' below, because of the way wm_download.pl::rdfparse
        ## handles version matching.

      $url = parse_url($rdfcache{$queryname}{'link'});
      $tempdir = gettempdir('update');
      ($filename) = downloadfile($url, $tempdir, 1, 1);

        ## Rename the old theme before installing the new one. Don't
        ## just uninstall it, because the program will abort if the
        ## installer hates the new theme too much, and then they're
        ## both gone! This way, we're left with a theme called
        ## "foobar-wmtheme-temp-0", in the worst case scenario,
        ## which the user can just rename.

      if (!$unsupported{'renaming'}) {
        $i = 0;
        do {
          $tempname = "$theme-wmtheme-temp-$i";
          ++$i;
        } until (!exists $themes{$tempname});
        ($newpath, $setname) = wm_rename($theme, $tempname);
        $newname = $setname || $tempname;
        $themes{$newname} = $themes{$theme};
        $themes{$newname}{'path'} = $newpath;
        delete $themes{$theme};
      } else {
        wm_uninstalltheme($theme) or
          choke("failed to remove old $theme");
      }

      $theme = wm_installtheme($tempdir, $filename, $theme);
      rdfmerge($theme, $rdfcache{$queryname});
      $themes{$theme}{'local_updated'} = $themes{$theme}{'updated'};
      $themes{$theme}{'updatable'} = 'yes';

      if (!$unsupported{'renaming'}) {
        wm_uninstalltheme($newname) or
          choke("failed to remove old $theme");
        delete $themes{$newname};
      }

      $themedata_modified = 1;
      killtempdir($tempdir);
      cache_themedir($theme);

    } else {
      print "Up to date.\n";
    }

  }
}

sub identify_themerecs {
  my @themes = @_;
  my ($querytheme, $queryname, $querymatch, $answer, $satisfied, @updatable,
    $s, $maxlen, @matchnames, @dispchoices, $matchchoice,
    $default, $updatable);

  my $quitting = 0;
  local $| = 0;
  is_running($wm_executable);  # this get pause out of the way

  foreach $querytheme (@themes) {
    last if $quitting;

    $satisfied = 0;
    $updatable = (($querytheme !~ m|/|)
      and (exists $themes{$querytheme})
      and ($themes{$querytheme}{'updatable'} eq 'yes')
      and ($themes{$querytheme}{'owner'} == $> or !$>));

      ##  Build and print the theme's introductory display

    $s = "$querytheme";
    if (exists $themes{$querytheme}) {
      $s .= "  by $themes{$querytheme}{'author'}"
        if $themes{$querytheme}{'author'};
      $s .= "  ($themes{$querytheme}{'category'})"
        if $themes{$querytheme}{'category'};
    }
    print "\n+" . '-' x (length($s) + 3 +
      ((20 - length($s)) * (length($s) < 20))) . "\n";
    print "| $s\n";
    print "| (already identified)\n" if $themes{$querytheme}{'id'};
    if (!$updatable) {
      print "| (not updatable)\n";
    } else {
      print "| (updatable)\n";
    }

      ##  Ask what to do

    while (!$satisfied) {
      $default = 's';
      print "\n  s.  Search by \"$querytheme\"\n";
      print "  e.  Enter another name to search.\n";
      print "  u.  This theme is eligible for updating.\n"
        if $themes{$querytheme}{'id'} and !$updatable;
      print "  n.  This theme is not eligible for updating.\n";
#        if $updatable;
      print "  a.  Activate this theme now.\n" if is_running($wm_executable)
        and !$unsupported{'activation'};
      if ($themes{$querytheme}{'id'} or $themes{$querytheme}{'updatable'} ne '') {
        print "  k.  Keep the current settings.\n";
        $default = 'k';
      }
      print "  f.  Forget identification info.\n" if $themes{$querytheme}{'id'};
      print "  q.  Quit (saves changes)\n\n";
      if ($default eq 'k') {
        print "(default: k, keep)";
      } else {
        print "(default: s, search)";
      }
      print ": ";
      $answer = <STDIN>;
      if ($answer =~ /^\s*$/) {
        $answer = $default;
      }

      if ($answer =~ /^[sSeE]/) {

          ##  choice: SEARCH

          #   Ask for the name.

        if ($answer =~ /^[eE]/) {
          $queryname = '';
          print "Enter the name to search: ";
          chomp($queryname = <STDIN>);
          $queryname =~ s/^\s*(.+?)\s*$/$1/;
          next unless $queryname;
        } else {
          $queryname = $querytheme;
        }

          #   Query themes.org if no case-insensitive match
          #   (puts results in the cache)

        if ($cachenames !~ /\n\Q$queryname\E\n/i) {
          print " - querying for \"$queryname\"\n";
          update_rdfquery('themetxt', $queryname);
        }

          #   Gather all possible matches from cache
          #   A proper case insensitive substring will only be taken
          #   as a good match if the user didn't enter the search string.

        if ($answer =~ /^[sS]/ and $cachenames =~ /\n(\Q$queryname\E)\n/i) {
          @matchnames = ($1);
        } else {
          @matchnames = ();
          while ($cachenames =~ m|\n([^\n]*\Q$queryname\E[^\n]*)(?=\n)|ig) {
            push @matchnames, $1;
          }
        }

          #   Ask for confirmation/choice among several

        if ($#matchnames == 0) {
          $querymatch = $matchnames[0];
          print "\n -- Found one:\n";
          print_themerec($querymatch, %{$rdfcache{$querymatch}});
          print "Is this an acceptable identification for \"$querytheme\"? [Y/n] ";
          $answer = <STDIN>;
          if ($answer =~ /^([yY]|\s*$)/) {
            rdfmerge($querytheme, $rdfcache{$querymatch});
            $themes{$querytheme}{'updatable'} = 'yes';
            push @updatable, $querytheme;
            $satisfied = 1;
          }
        } elsif (@matchnames) {
          @dispchoices = ();
          $maxlen = getmaxlen(@matchnames);
          foreach (@matchnames) {
            push @dispchoices, $_ . ' ' x ($maxlen - length($_) + 2) .
              "by $rdfcache{$_}{'author'}  ($rdfcache{$_}{'category'})";
          }
          print "\n -- several themes match \"$queryname\" (enter q to reject all of these)\n";
          $matchchoice = getuserchoice(@dispchoices);
          if ($matchchoice >= 0 and $matchchoice <= $#matchnames) {
            $querymatch = $matchnames[$matchchoice];
            rdfmerge($querytheme, $rdfcache{$querymatch});
            $themes{$querytheme}{'updatable'} = 'yes';
            push @updatable, $querytheme;
            $satisfied = 1;
          }
          # else it loops back to the question so they can make it
          # non-updatable, or enter another search term
        } else {
          print "\n !! can't find any themes matching \"$queryname\"\n";
        }

      } elsif ($answer =~ /^[kK]/) {
        $satisfied = 1;
      } elsif ($answer =~ /^[uU]/ and $themes{$querytheme}{'id'} and !$updatable) {
        $themes{$querytheme}{'updatable'} = 'yes';
        print " - \"$querytheme\" is marked updatable.\n";
        $satisfied = 1;
#      } elsif ($answer =~ /^[nN]/ and $updatable) {
      } elsif ($answer =~ /^[nN]/) {
        $themes{$querytheme}{'updatable'} = 'no';
        $satisfied = 1;
        print " - \"$querytheme\" is marked non-updatable.\n";
      } elsif ($answer =~ /^[aA]/ and is_running($wm_executable) and
          !$unsupported{'activation'}) {
        activate_theme($querytheme);
      } elsif ($answer =~ /^[qQ]/) {
        $satisfied = 1;
        $quitting = 1;
        print "Bye.\n";
      } elsif ($answer =~ /^[fF]/ and $themes{$querytheme}{'id'}) {
        print " - forgetting identification information.\n";
        foreach (@rdffields) {
          $themes{$querytheme}{$_} = '';
        }
        $satisfied = 1;
      } else {
        chomp $answer;
        print "(\"$answer\" not understood)\n";
      }
    }
  }
  @updatable;
}

sub update_rdfquery {
  my %queryinfo = @_;
  my ($querytext, $queryid, $queryname, %queryresult, $s, @queryterms);

  $querytext = getrdfquery($tosite, %queryinfo);
  foreach (keys %queryinfo) {
    if ($_ eq 'themeid') {
      push @queryterms, ('id', $queryinfo{$_});
    } elsif ($_ eq 'themetxt') {
      push @queryterms, ('name', $queryinfo{$_});
    }
    ## else do something?
  }

  %queryresult = rdfparse($querytext, @queryterms);
  if (%queryresult) {
    $cachenames= "\n" unless $cachenames;
    foreach $s (keys %queryresult) {
      $cachenames .= "$s\n";
      $rdfcache{$s} = $queryresult{$s};
    }
  }
}

sub print_themerec {
  my ($name, %rec) = @_;
  print "      Name:  $name\n";
  print "    Author:  $rec{'author'}\n" if $rec{'author'};
  print "  Category:  $rec{'category'}\n" if $rec{'category'};
  print "        Id:  $rec{'id'}  (" . localtime($rec{'id'}) . ")\n"
    if $rec{'id'};
}

sub update_eligible {
  my $theme = shift;

  if (
    ($theme !~ /\//) and
    ($themes{$theme}{'owner'} == $> or !$>) and
    $themes{$theme}{'origname'} and
    ($themes{$theme}{'updatable'} eq 'yes') ) {
    return 1;
  } else {
    return 0;
  }
}

1;


