#  wm_fonts.pl -- font handling for wmtheme

sub _install_fonts {
  return unless exists $config_wm{tempfontdir};
  chomp(my $fontdir = `echo $config_wm{tempfontdir}`);
  
  unless (-e $fontdir) {
    mkdir $fontdir, 0755 or choke("Can't mkdir $fontdir: $!");
  }
  unless (-d $fontdir and -x _ and -w _) {
    complain("Can't use local font directory $config_wm{tempfontdir}",
      "Please make sure it exists and has proper permissions.");
    return;
  }

  my $srcdir = shift;
  my @dirs = ($srcdir);
  my ($dir, $entry, $foundany);

  my $fontre = '.\.(?i:pcf|pfa|pfb|spd|ttf)(?:\.gz)?$';

  while ($dir = pop @dirs) {
    unless (opendir FDH, $dir) {
      complain("Can't opendir $dir: $!");
      next;
    }

    while (defined ($entry = readdir FDH)) {
      next if $entry =~ /^\.\.?$/;
      if (-d "$dir/$entry") {
        push @dirs, "$dir/$entry";
      } elsif (-f _ and $entry =~ /$fontre/ and !-e "$fontdir/$entry") {
        dbugout("_INSTALL_FONTS: Installing $entry to local font directory") if $debug;
        syscmd('mv', "$dir/$entry", $fontdir);
        $foundany = 1;
      }
    }
  }

  if ($foundany) {
    if (exists $config_wm{installfontcmd}) {
      syscmd($config_wm{installfontcmd});
    } else {
      print "$programname: fonts were copied to $config_wm{tempfontdir}\n";
    }
  } elsif ($debug) {
    dbugout("_INSTALL_FONTS: No fonts were installed for this theme");
  }
}

1;


