######################################################################
#
#  enlightenment.pl - wmtheme support for E
#

$tosite = 'e.themes.org';
$wm_executable = 'enlightenment';
$defaultuserdir = "$home/.enlightenment/themes";
$badnamechars .= '&\'"|\\ ()`$;';

my ($E_version, $E_exec, $E_themedir);
my @guess_dirs = (
  '/usr/local/enlightenment',        # Default
  '/usr/share/enlightenment',        # Red Hat/Debian
  '/usr/X11R6/share/enlightenment',  # Slackware
  '/usr/local/share/enlightenment'   # .. just to be safe
  );

  ###
  #
  #  WM_GETDEFAULTDIRS
  #
  ###

sub wm_getdefaultdirs {
  my @themedirs;
  my @dirs = @guess_dirs;
  my $userthemedir = "$home/.enlightenment/themes";

  set_exec_themedir_enlightenment();

  if ($E_themedir) {
      # Use this as the global theme directory, even if its owner's
      # uid isn't 0.  Enlightenment chowns the global theme directory
      # to match the owner of the directory from which it was installed,
      # a strange behavior which must be dealt with here.

    @themedirs = ($E_themedir);
    $globalthemedir = $E_themedir;
    if (-d $userthemedir and -x _ and -r _) {
      push @themedirs, $userthemedir;
      $localthemedir = $userthemedir;
    }
  } else {
    foreach (@dirs) { $_ .= '/themes'; }
    unshift @dirs, $userthemedir;
    @themedirs = verify_themedirs(0, @dirs);
  }

  @themedirs;
}

  ###
  #
  #  WM_SCANDIR
  #
  ##

sub wm_scandir {
  my $dir = shift;
  my $oid = (stat $dir)[4];
  my $mtime = (stat _)[9];

  dbugout("WM_SCANDIR: scanning $dir") if $debug;
  opendir DH, $dir or choke("can't opendir $dir: $!");
  while (defined($entry = readdir DH)) {
    next if $entry =~ /^\.\.?$/;

    dbugout("WM_SCANDIR: checking \"$entry\"") if $debug;
    if (-s "$dir/$entry" and $entry =~ /^DEFAULT$/) {
      dbugout("WM_SCANDIR: skipping default-symlink") if $debug;
    } elsif (-d "$dir/$entry") {
      if ($entry =~ /([^\/]+)$/) {
        createthemerec($1, "$dir/$entry", $oid);
      } else {
        choke("WM_SCANDIR: internal error evaluating $entry");
      }
    } elsif ($entry =~ /([^\/]+)\.etheme$/) {

      # A directory theme overrides a .etheme theme
      if (!exists $themes{$1} or $themes{$1}{path} ne "$dir/$1") {
        createthemerec($1, "$dir/$entry", $oid);
      }
    }
    ## else just ignore this file
  }
  ($dir, $mtime);
}

  ###
  #
  #  WM_INSTALLTHEME
  #
  ###

sub wm_installtheme {
  my ($location, $filename, $defname) = @_;
  my ($possiblename, $themename, $destthemedir, $answer, $properthemedir);

###  Determine destination directory

  if ($> == 0) {
    if (!$globalthemedir) {
       choke("no global theme directory could be identified",
         "perhaps Enlightenment is not installed on this system?");
    }
    $destthemedir = $globalthemedir;
  } elsif (!$localthemedir) {
    print "There is no theme directory for this user. Do you want it created now?\n";
    print "[Y/n] ";
    if (<STDIN> =~ /^[nN]/) {
      choke("theme installation aborted");
    }
    print "$programname: creating $defaultuserdir\n";
    syscmd('install', '-d', $defaultuserdir);
    $localthemedir = $defaultuserdir;
    $destthemedir = $localthemedir;
  } else {
    $destthemedir = $localthemedir;
  }

  dbugout("WM_INSTALLTHEME: filename=$filename  location=$location")
    if $debug;

  if ($defname) {
    $possiblename = $defname;
  } else {
    if ($filename and $filename =~ /([^\/]+)\.etheme$/) {
      $possiblename = $1;
    } elsif ($location =~ /\/([^\/]+)$/) {
      $possiblename = $1;
    } else {
      choke("internal error: can't grab a theme name from $location");
    }

  }
   ## fixme - future versions of enlightenment may be able to handle
   ## themes with spaces in their names
  $possiblename =~ y/ /_/;
  $themename = checkname($possiblename);

  if (-d $location) {
    if ($properthemedir = findsubdirwithfile($location, 'init.cfg')) {
      syscmd('mv', $properthemedir, "$destthemedir/$themename");
    } else {
      syscmd('mv', $location, "$destthemedir/$themename");
    }
  } elsif ($location =~ /\.etheme$/) {
   ## Extract the tarball since E will anyway

    mkdir "$destthemedir/$themename", 0755 or
      choke("can't mkdir $destthemedir/$themename: $!");
    forktick("gzip -dc \Q$location\E | tar xf - -C \Q$destthemedir/$themename\E");
  } else {
    choke("cannot use $location as a theme");
  }

  createthemerec($themename, "$destthemedir/$themename", $>);
  syscmd('eesh', '-e', 'reload_menus') if is_running($wm_executable);
  $themename;
}

  ###
  #
  #  WM_ACTIVATETHEME
  #
  ###

sub wm_activatetheme {
  my $theme = shift;

  syscmd('eesh', '-e', "restart_theme $themes{$theme}{path}")
    if is_running($wm_executable);
}

  ###
  #
  #  WM_UNINSTALLTHEME
  #
  ###

sub wm_uninstalltheme {
  my $theme = shift;

   ##  Remove .etheme file if present
  if (-d $themes{$theme}{path} and -f "$themes{$theme}{path}.etheme") {
    dirwipe("$themes{$theme}{path}.etheme");
  }

  if (dirwipe($themes{$theme}{path}, 1)) {
    syscmd('eesh', '-e', 'reload_menus') if is_running($wm_executable);
    1;
  } else {
    0;
  }
}

  ###
  #
  #  WM_RENAME
  #
  ###

sub wm_rename {
  my ($old, $new) = @_;

  my $oldpath = $themes{$old}{path};
  my $newpath = $oldpath;

  if (-d $oldpath) {
    $newpath =~ s/\/\Q$old\E$/\/$new/ or
      choke("internal error: \"$oldpath\" dir doesn't end in \"$old\""); 

      # also check for a coexisting name.etheme file, and rename.
      # this sequence depends on wm_scantheme preferring a theme directory
      # to name.etheme, if both exist!
    my $olddir = $oldpath;
    $olddir =~ s/\/([^\/]+)$//;
    if (-f "$olddir/$old.etheme") {
      rename "$olddir/$old.etheme", "$olddir/$new.etheme" or
        choke("can't rename $olddir/$old.etheme to $olddir/$new.etheme: $!");
    }
  } else {
    $newpath =~ s/\/\Q$old\E\.etheme$/\/$new.etheme/ or
      choke("internal error: \"$oldpath\" doesn't end in \"$old.etheme\"");
  }
  rename $oldpath, $newpath or
    choke("can't rename $themes{$current}{path} to $newpath: $!");
  syscmd('eesh', '-e', 'reload_menus') if is_running($wm_executable);
  $newpath;
}

  ###
  #
  #  WM_VERSIONOK
  #
  ###

sub wm_versionok {
  my $request = shift;
  my ($rqver, $ever, $rqmat, $emat);

  $ever = getversion_enlightenment();
  if ($ever and $request =~ /(\d+(\.\d*)?)/) {
    $rqver = $1;
    if ($request =~ /DR(\d+)/ and $rqver == $1) {
      $rqver /= 100;
    }

    dbugout("VERSIONOK: checking $rqver against E v$ever")
      if $debug;
    if ($ever < 0.15) {
      return ($rqver < 0.15);
    } if ($ever < 0.16) {
      return ($rqver >= 0.15 and $rqver < 0.16);
    } elsif ($ever < 0.17) {
      return ($rqver >= 0.16 and $rqver < 0.17);
    } else {
      return minorvermatch($rqver, $ever);
    }
  } else {
    dbugout("VERSIONOK: bad version \"$request\" or E version unknown: returning ok")
      if $debug;
  }
  return 0;
}

sub getversion_enlightenment {
  if (!defined $E_version) {
    set_exec_themedir_enlightenment();
    if (-x $E_exec and `$E_exec --version` =~ /versio\S+\s+(\d+(\.\d*)?)/i) {
      $E_version = $1;
      dbugout("Enlightenment executable: $E_exec",
        "Enlightenment version: $E_version") if $debug;
    } else {
      dbugout("Can't get Enlightenment version.") if $debug;
    }
  }
  $E_version;
}

sub set_exec_themedir_enlightenment {
  if (!defined $E_exec) {
    foreach (@guess_dirs) {
      if (-x "$_/bin/enlightenment") {
        $E_exec = "$_/bin/enlightenment";
        if (-d "$_/themes" and -x _ and -r _) {
          $E_themedir = "$_/themes";
        }
        return;
      }
    }
    if (!$E_exec or ! -x $E_exec or -d _) {
      $E_exec = findexe('enlightenment');
    }
  }
}

1;

