#include <stdlib.h>

#include <dockapp.h>

#include "types.h"
#include "events.h"
#include "buttonbar.h"
#include "options.h"
#include "menu.h"
#include "xobjects.h"
#include "pixmaps.h"

static bool BarShown = false ;
static bool LeavedTile = false ;

static void EnterApp (void)
{
    if (Menu_HasChanged ())
    {
        Menu_Reload () ;

        TileXSize = TileYSize = 0 ;
        Pixmaps_LoadMenu () ;
        Pixmaps_LoadTile () ;

        ButtonBar_Rebuild () ;
    }

    ButtonBar_Show () ;
    BarShown = true ;
    LeavedTile = false ;
}

static void LeaveBar (void)
{
    ButtonBar_Hide () ;
    BarShown = false ;
}

static void InvokeBar (int x, int y)
{
    int h, w ;
    h = Menu_GetNbRows () ;
    w = Menu_GetNbColumns () ;
    x /= TileXSize ;
    y /= TileYSize ;
    if (0 <= y && y < h && 0 <= x && x < w)
    {
        int entry ;
        entry = y + h*x ;

        if (entry < Menu_GetNbEntries ())
        {
            system (Menu_GetEntryCommand (entry)) ;
        }
    }

    LeaveBar () ;
}

static void PressApp (int button, int state, int x, int y)
{
    if (BarShown) LeaveBar () ;
    else EnterApp () ;
}

extern void Events_SetCallbacks (void)
{
    DACallbacks events ;

    events.destroy = NULL ;
    events.buttonPress = PressApp ;
    events.buttonRelease = NULL ;
    events.motion = NULL ;
    events.enter = (ClickOnly ? NULL : EnterApp) ;
    events.leave = NULL ;

    DASetCallbacks (& events) ;

    /* work around a bug in libdockapp: not selecting Enter/Leave events */
    if (! ClickOnly)
    {
        XSetWindowAttributes ws ;
        XWindowAttributes wa ;

        XGetWindowAttributes (DADisplay, DAWindow, & wa) ;
        ws.event_mask = wa.your_event_mask | EnterWindowMask ;
        XChangeWindowAttributes (DADisplay, DAWindow, CWEventMask, & ws) ;
    }
}

extern void Events_Loop (void)
{
    XEvent ev ;

    while (true)
    {
        XNextEvent (DADisplay, & ev) ;
        /* DANextEventOrTimeout (& ev, period) ; */

        if (ev.xany.window == ButtonBarWindow) switch (ev.type)
        {
            case ButtonRelease :
                InvokeBar (ev.xbutton.x, ev.xbutton.y) ;
                break ;

            case LeaveNotify :
                /* trick here: see below */
                if (LeavedTile && ! BarShown) EnterApp () ;
                else LeaveBar () ;
                break ;

	    case MotionNotify :
		if (HighlightImage != 0) /* try to avoid func call */
		{
		    ButtonBar_Highlight (
			ev.xmotion.x/TileXSize, ev.xmotion.y/TileYSize) ;
		}
		break ;
        }
        else
        {
            /* also hide bar when leaving WMaker's dockapp tile */
            if (ev.type == LeaveNotify && NewLeaving
            && ev.xany.window == WMFrame && BarShown)
            {
                /*
                This relies on a trick: when the cursor leaves the tile to
                go into the bar, X will consider the cursor to be in the
                bar, so when we hide it a Leave event will be generated for
                the bar; We catch it later and show the bar back.
                */
                LeaveBar () ;
                LeavedTile = true ;
            }

            DAProcessEvent (& ev) ;
        }
    }
}
