#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <assert.h>
/* POSIX */
#include <unistd.h>

#include "utils.h"
#include "error.h"
#include "types.h"

static char * ReadAll (FILE * f, int offset)
{
    char buf [10*1024] ;
    int iRead, nRead ;
    char * ret ;

    clearerr (f) ;

    iRead = 0 ;
    nRead = 0 ;
    while (iRead < sizeof buf)
    {
        nRead = fread (buf+iRead, 1, (sizeof buf)-iRead, f) ;
        if (nRead <= 0) break ;
        iRead += nRead ;
    }

    if (nRead > 0)
    {
        assert (iRead == sizeof buf) ;
        ret = ReadAll (f, offset+iRead) ;
    }
    else
    if (ferror (f) != 0)
    {
        error ("read file: %s", strerror (errno)) ;
        ret = NULL ;
    }
    else
    {
        ret = malloc (offset+iRead+1) ;
        if (ret == NULL) error ("failed to allocate memory") ;
        ret[offset+iRead] = EOS ;
    }
    memcpy (ret+offset, buf, iRead) ;

    return ret ;
}

extern char * File_ReadAll (FILE * f)
{
    assert (f != NULL) ;
    return ReadAll (f, 0) ;
}

extern bool File_FindInPath (char * out, int outSz,
    const char * path, const char * basename)
{
    char name [FILENAME_MAX] ;
    int len ;

    assert (path != NULL) ;
    assert (basename != NULL) ;
    assert (out != NULL) ;

    if (access (basename, F_OK) == 0)
    {
        sprintf (out, "%.*s", outSz-1, basename) ;
        return true ;
    }
    else
    if (strchr (basename, '/') != NULL)
    {
        return false ;
    }
    else
    {
        while (*path != EOS)
        {
            len = strcspn (path, ":") ;
            sprintf (name, "%.*s/%s", len, path, basename) ;

            if (access (name, F_OK) == 0)
            {
                sprintf (out, "%.*s", outSz-1, name) ;
                return true ;
            }

            path += len ;
            while (*path == ':') path++ ;
        }

        return false ;
    }
}
