#include <assert.h>

#include <dockapp.h>

#include "buttonbar.h"
#include "xobjects.h"
#include "pixmaps.h"
#include "options.h"
#include "menu.h"

extern void ButtonBar_Build (void)
{
    int i, n ;
    int width, height ;
    GC imgOp ;
    XGCValues gc ;
    Pixmap image, mask ;
    int x, y ;
    XSetWindowAttributes wa ;

    n = Menu_GetNbEntries () ;
    assert (n > 0) ;
    width = TileXSize * n ;
    height = TileYSize ;


    ButtonBarWindow = XCreateSimpleWindow (
        DADisplay, DefaultRootWindow (DADisplay), 0, 0, width, height, 0,
        BlackPixel (DADisplay, DefaultScreen (DADisplay)),
        BlackPixel (DADisplay, DefaultScreen (DADisplay))) ;
    ButtonBarImage = XCreatePixmap (DADisplay, ButtonBarWindow,
        width, height, DADepth) ;
    imgOp = XCreateGC (DADisplay, ButtonBarWindow, 0, & gc) ;

    /* first apply tile to whole width of bar */
    for (i=0; i<n; i++)
        XCopyArea (DADisplay, TileImage, ButtonBarImage, imgOp, 0, 0,
            TileXSize, TileYSize, TileXSize*i, 0) ;

    /* then apply each pixmap of menu entry */
    for (i=0; i<n; i++)
    {
        Pixmaps_FindLoad (Menu_GetEntryPixmap (i),
            & image, & mask, & width, & height) ;

        x = (width >= TileXSize ? 0 : (TileXSize-width)/2) ;
        y = (height >= TileYSize ? 0 : (TileYSize-height)/2) ;
        gc.clip_x_origin = TileXSize*i + x ;
        gc.clip_y_origin = y ;
        gc.clip_mask = mask ; /* may be None */
        XChangeGC (DADisplay, imgOp,
            GCClipXOrigin | GCClipYOrigin | GCClipMask, & gc) ;

        XCopyArea (DADisplay, image, ButtonBarImage, imgOp, 0, 0,
            width, height, gc.clip_x_origin, gc.clip_y_origin) ;

        XFreePixmap (DADisplay, image) ;
        if (mask != 0) XFreePixmap (DADisplay, mask) ;
    }

    XFreeGC (DADisplay, imgOp) ;

    wa.background_pixmap = ButtonBarImage ;
    wa.event_mask =
        ButtonPressMask | ButtonReleaseMask |
        EnterWindowMask | LeaveWindowMask /* |
        PointerMotionMask */ ;
    wa.override_redirect = True ;
    XChangeWindowAttributes (DADisplay, ButtonBarWindow,
        CWBackPixmap | CWEventMask | CWOverrideRedirect, & wa) ;
}

extern void ButtonBar_Show (void)
{
    XWindowAttributes wa ;
    int xMid, scrWidth ;
    int x, y ;

    if (WMFrame == None)
    {
        Window tile, parent, root, *children ;
        unsigned int nChildren ;

        /* find window just under root, it is the wm frame icon */
        /* (or DAWindow itself if none) */
        root = 0 ;
        tile = parent = DAWindow ;
        while (parent != root)
        {
            tile = parent ;
            XQueryTree (DADisplay, tile,
                &root, &parent, &children, &nChildren) ;
            if (children != NULL) XFree (children) ;
        }

        WMFrame = tile ;
        if (NewLeaving) XSelectInput (DADisplay, WMFrame, LeaveWindowMask) ;
    }

    XGetWindowAttributes (DADisplay, WMFrame, & wa) ;

    /* compute y */
    y = wa.y ;
    /* TODO: check if TileYSize != wa.height to center/shift vertically */

    /* compute x */
    scrWidth = DisplayWidth (DADisplay, DefaultScreen (DADisplay)) ;
    xMid = wa.x + wa.width/2 ;
    if (xMid*2 < scrWidth)
    {
        /* we are rather on left, expand to right */
        x = wa.x + wa.width ;
    }
    else
    {
        /* we are rather on right, expand to left */
        x = wa.x - TileXSize * Menu_GetNbEntries () ;
    }

    XMoveWindow (DADisplay, ButtonBarWindow, x, y) ;
    XMapRaised (DADisplay, ButtonBarWindow) ;
}

extern void ButtonBar_Hide (void)
{
    XUnmapWindow (DADisplay, ButtonBarWindow) ;
}

extern void ButtonBar_Rebuild (void)
{
    XDestroyWindow (DADisplay, ButtonBarWindow) ;
    ButtonBar_Build () ;
}
