/* Author : Scott Holden ( scotth@thezone.net )
   Modified : Yong-iL Joh ( tolkien@mizi.com )
 * 
 * Pop3 Email checker.
 *
 * Last Updated : Mar 12, 2001
 *
 */

#include "Client.h"
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define	PCU	(pc->u).pop

FILE *pop3Login(Pop3 pc)
{
	int fd;
	FILE *fp;

	if ((fd = sock_connect(PCU.serverName, PCU.serverPort)) == -1) {
		fprintf(stderr, "Not Connected To Server '%s:%d'\n",
				PCU.serverName, PCU.serverPort);
		return NULL;
	}

	fp = fdopen(fd, "r+");
	fgets(buf, BUF_SIZE, fp);

	fflush(fp);
	fprintf(fp, "USER %s\r\n", PCU.userName);
	fflush(fp);
	fgets(buf, BUF_SIZE, fp);
	if (buf[0] != '+') {
		fprintf(stderr, "Invalid User Name '%s@%s:%d'\n",
				PCU.userName, PCU.serverName, PCU.serverPort);
#ifdef DEBUG_POP3
		fprintf(stderr, "%s\n", buf);
#endif
		fprintf(fp, "QUIT\r\n");
		fclose(fp);
		return NULL;
	};

	fflush(fp);
	fprintf(fp, "PASS %s\r\n", PCU.password);
	fflush(fp);
	fgets(buf, BUF_SIZE, fp);
	if (buf[0] != '+') {
		fprintf(stderr, "Incorrect Password for user '%s@%s:%d'\n",
				PCU.userName, PCU.serverName, PCU.serverPort);
		fprintf(stderr, "It said %s", buf);
		fprintf(fp, "QUIT\r\n");
		fclose(fp);
		return NULL;
	};

	return fp;
}

int pop3CheckMail(Pop3 pc)
{
	FILE *f;
	int read;

	f = pc->open(pc);
	if (f == NULL)
		return -1;

	fflush(f);
	fprintf(f, "STAT\r\n");
	fflush(f);
	fgets(buf, 256, f);
	if (buf[0] != '+') {
		fprintf(stderr, "Error Receiving Stats '%s@%s:%d'\n",
				PCU.userName, PCU.serverName, PCU.serverPort);
		return -1;
	} else {
		sscanf(buf, "+OK %d", &(pc->TotalMsgs));
	}

	fflush(f);
	fprintf(f, "LAST\r\n");
	fflush(f);
	fgets(buf, 256, f);
	if (buf[0] != '+') {
		fprintf(stderr, "Error Receiving Stats '%s@%s:%d'\n",
				PCU.userName, PCU.serverName, PCU.serverPort);
		return -1;
	} else {
		sscanf(buf, "+OK %d", &read);
		pc->UnreadMsgs = pc->TotalMsgs - read;
	}

	fprintf(f, "QUIT\r\n");
	fclose(f);

	return 0;
}

int pop3Create(Pop3 pc, char *str)
{
	/* POP3 format: pop3:user:password@server[:port] */
	char *tmp;
	char *p;

#ifdef DEBUG_POP3
	printf("pop3: str = '%s'\n", str);
#endif

	strcpy(PCU.password, "");
	strcpy(PCU.userName, "");
	strcpy(PCU.serverName, "");
	PCU.serverPort = 110;
	pc->TotalMsgs = 0;
	pc->UnreadMsgs = 0;
	tmp = strdup(str);
	p = strtok(tmp, ":");		/* cut off ``pop3:'' */
	p = strtok(NULL, ":");		/* p pointed to username */
	strcpy(PCU.userName, p);
	p = strtok(NULL, "@");		/* p -> password */
	strcpy(PCU.password, p);
	p = strtok(NULL, ":");		/* p -> server */
	strcpy(PCU.serverName, p);
	strcpy(pc->path, "");		/* p -> mailbox */
	if ((p = strtok(NULL, ":")) != NULL) {	/* port selected; p -> port */
		PCU.serverPort = atoi(p);
	}
	free(tmp);

	pc->open = pop3Login;
	pc->checkMail = pop3CheckMail;

#ifdef DEBUG_POP3
	printf("pop3: userName= '%s'\n", PCU.userName);
	printf("pop3: password= '%s'\n", PCU.password);
	printf("pop3: serverName= '%s'\n", PCU.serverName);
	printf("pop3: serverPort= '%d'\n", PCU.serverPort);
#endif

	return 0;
}

/* vim:set ts=4: */
