/* Author : Yong-iL Joh ( tolkien@mizi.com )
 * 
 * Imap4 Email checker.
 *
 * Last Updated : Mar 12, 2001
 *
 */

#include "Client.h"
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define	PCU	(pc->u).pop

FILE *imap4Login(Pop3 pc)
{
	int fd;
	FILE *f;

	if ((fd = sock_connect(PCU.serverName, PCU.serverPort)) == -1) {
		fprintf(stderr, "Not Connected To Server '%s:%d'\n",
				PCU.serverName, PCU.serverPort);
		return NULL;
	}

	f = fdopen(fd, "r+");
	fgets(buf, BUF_SIZE, f);

	/* Login to the server */
	fflush(f);
	fprintf(f, "a001 LOGIN %s %s\r\n", PCU.userName, PCU.password);

	/* Ensure that the buffer is not an informational line */
	do {
		fflush(f);
		fgets(buf, BUF_SIZE, f);
	}
	while (buf[0] == '*');

	if (buf[5] != 'O') {		/* Looking for "a001 OK" */
		fprintf(f, "a002 LOGOUT\r\n");
		fclose(f);
		return NULL;
	};

	return f;
}

int imap4CheckMail(Pop3 pc)
{
	FILE *f;
	char str[128];

	f = pc->open(pc);
	if (f == NULL)
		return -1;

	fflush(f);
	fprintf(f, "a003 STATUS %s (MESSAGES)\r\n", pc->path);
	fflush(f);
	fgets(buf, 127, f);
	if (buf[0] != '*') {		/* Looking for "* STATUS ..." */
		fprintf(stderr, "Error Receiving Stats '%s@%s:%d'\n\t%s\n",
				PCU.userName, PCU.serverName, PCU.serverPort, buf);
		fclose(f);
		return -1;
	} else {
		sprintf(str, "* STATUS %s (MESSAGES %%d)", pc->path);
		sscanf(buf, str, &(pc->TotalMsgs));
#ifdef DEBUG_IMAP4
		fprintf(stderr, "[%s:%d] %s", __FILE__, __LINE__, buf);
#endif
		fgets(buf, 127, f);
#ifdef DEBUG_IMAP4
		fprintf(stderr, "[%s:%d] %s", __FILE__, __LINE__, buf);
#endif
	}

	fflush(f);
	fprintf(f, "a003 STATUS %s (UNSEEN)\r\n", pc->path);
	fflush(f);
	fgets(buf, 127, f);
	if (buf[0] != '*') {		/* Looking for "* STATUS ..." */
		fprintf(stderr, "Error Receiving Stats '%s@%s:%d'\n\t%s\n",
				PCU.userName, PCU.serverName, PCU.serverPort, buf);
		fclose(f);
		return -1;
	} else {
		sprintf(str, "* STATUS %s (UNSEEN %%d)", pc->path);
		sscanf(buf, str, &(pc->UnreadMsgs));
#ifdef DEBUG_IMAP4
		fprintf(stderr, "[%s:%d] %s", __FILE__, __LINE__, buf);
#endif
	}

	fprintf(f, "a002 LOGOUT\r\n");
	fclose(f);

	return 0;
}

int imap4Create(Pop3 pc, char *str)
{
	/* IMAP4 format: imap:user:password@server/mailbox[:port] */
	char *tmp;
	char *p;

#ifdef DEBUG_IMAP4
	printf("imap4: str = '%s'\n", str);
#endif

	strcpy(PCU.password, "");
	strcpy(PCU.userName, "");
	strcpy(PCU.serverName, "");
	PCU.serverPort = 143;
	pc->TotalMsgs = 0;
	pc->UnreadMsgs = 0;
	tmp = strdup(str);

	/* We start with imap:user:password@server[/mailbox][:port] */
	p = strtok(tmp, ":");		/* cut off ``imap:'' */

	/* Now, we have user:password@server[/mailbox][:port] */
	p = strtok(NULL, ":");		/* p pointed to username */
	strcpy(PCU.userName, p);

	/* Now, we have password@server[/mailbox][:port] */
	p = strtok(NULL, "@");		/* p -> password */
	strcpy(PCU.password, p);

	/* At this point, our call to strtok should contain server[/mailbox][:port] */
	p = strtok(NULL, "/");		/* p -> server */
	strcpy(PCU.serverName, p);

	/* It should now be [mailbox][:port] */
	if ((p = strtok(NULL, ":")) != NULL) {	/* p -> mailbox */
		strcpy(pc->path, p);
	} else {
		strcpy(pc->path, "INBOX");
	}

	/* and finally [port] */
	if ((p = strtok(NULL, ":")) != NULL) {	/* port selected; p -> port */
		PCU.serverPort = atoi(p);
	}
	free(tmp);

	pc->open = imap4Login;
	pc->checkMail = imap4CheckMail;

#ifdef DEBUG_IMAP4
	printf("imap4: userName= '%s'\n", PCU.userName);
	printf("imap4: password= '%s'\n", PCU.password);
	printf("imap4: serverName= '%s'\n", PCU.serverName);
	printf("imap4: serverPath= '%s'\n", pc->path);
	printf("imap4: serverPort= '%d'\n", PCU.serverPort);
#endif

	return 0;
}

/* vim:set ts=4: */
