/*
 *  WMMultipop3
 *  Checks for mail on one or more popservers.
 *  
 *  (C) Daniel Sundberg 2000
 *  dss@home.se
 *  http://wmmultipop3.sf.net
 *  
 *  Based on:
 *  wmpop3.c
 *  pop3 mail checker. 
 *  by Scott Holden (scotth@thezone.net)
 *
 *  Contains some code from WMInet Dockable app.
 *             - BlitNum and BlitString
 *
*/

#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <signal.h>

#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ioctl.h>

#include <X11/xpm.h>
#include <X11/Xlib.h>
#include <X11/extensions/shape.h>

#include "../wmgeneral/misc.h"
#include "../wmgeneral/wmgeneral.h"
#include "Pop3Client.h"

#include "wmpop3.xpm"

char wminet_mask_bits[64*64];
int  wminet_mask_width = 64;
int  wminet_mask_height = 64;

#define WMPOP3_VERSION "0.8"

#define CHAR_WIDTH   5
#define CHAR_HEIGHT  7
#define SEC_IN_MIN  60
#define YES          1
#define NO           0
#define STR_LENGTH 128 
#define MAX_RUN_COMMAND_STR_LENGTH      255

char *ProgName;

typedef struct {
  char password[STR_LENGTH];
  char username[STR_LENGTH];
  char popserver[4*STR_LENGTH];
  char mailserverid[4];
  int  port;
  int  nMsgs;
  int  nUnread;
} MailServerConf;

typedef struct {
  MailServerConf **c;
  char mailclient[STR_LENGTH];
  char middle_click_cmd[STR_LENGTH];
  char mail_arrived_cmd[STR_LENGTH];  /* Added by Roeland Huys 18/5/2002 */
  char right_click_cmd[STR_LENGTH];
  char run_command[MAX_RUN_COMMAND_STR_LENGTH];
  int  autoChecking;
  int  mailCheckDelay;
  int  viewUnread;
  int  nMailBoxes;
  int  debug;
} Conf;

Conf conf;

char config_file[256] = "not-defined"; 

void usage(void);
void printversion(void);
void wmCheckMail_routine(int, char **);
int  readConfigFile( char *filename );
void printConfig(void);

void BlitString(char *name, int x, int y);
void BlitNum(int num, int x, int y);


/********************************
 *           Main Program
 ********************************/
int main(int argc, char *argv[]) {
  int		i;
  conf.debug = NO;
  conf.viewUnread=NO;
  ProgName = argv[0];
  if (strlen(ProgName) >= 5) {
    ProgName += (strlen(ProgName) - 5);
  }
	
  /* Parse command line arguments */
  for (i=1; i<argc; i++) {
    char *arg = argv[i];

    if (*arg=='-') {
      switch (arg[1]) {
      case 'd' :
	if (strcmp(arg+1, "display")) {
	  usage();
	  exit(1);
	}
	break;
      case 'g' :
	if (strcmp(arg+1, "geometry")) {
	  usage();
	  exit(1);
	}
	break;
      case 'v' :
	printversion();
	exit(0);
	break;
      case 'D' :
	conf.debug=YES;
	printf("Debug=YES\n");
	break;
      case 'u' :
	conf.viewUnread=YES;
	if (conf.debug)
	  printf("Viewing unread messages...\n");
	break;
      case 'c' :
	if (argc > (i+1)) {
	  strncpy(config_file, argv[i+1], sizeof(config_file));
	  i++;
	}
	break;
      default:
	usage();
	exit(0);
	break;
      }
    }
  }

  /* End of commandline parsing */
  //  signal(SIGCHLD, SIG_IGN);
  wmCheckMail_routine(argc, argv); 
  //  signal(SIGCHLD, SIG_DFL);
  /*readConfigFile(config_file);*/
  return 0;
}

/*
 * wmCheckMail_routine : This function is used to set up the X display
 *           for wmpop3 and check for mail every n number of minutes.
 */

  static int nTotMail_last = 0;
void wmCheckMail_routine(int argc, char **argv){
  int    nTotMail       = 0; 
  long   startTime      = 0; 
  long   nextCheckTime  = 0; 
  int    forcedCheck    = NO; 
  int	 buttonStatus   =-1; 
  int    tempPopCnt     = 0;
  int    mailWaiting    = 0;
  int    i              = 0;
  int    j              = 0;
  XEvent Event; 
  Pop3   pc; 
  char   *display_name  = NULL;
  Display *temp_display  = NULL;
  char command[1024];
  int num_msgs, read_msgs;
  
  /* Find config-file */
  if( !strcmp( config_file, "not-defined") ) {
    snprintf(config_file, sizeof(config_file), "%s/.wmmultipop3rc", getenv("HOME")); 
  }

  /* Read config */
  if( readConfigFile(config_file) == -1){ 
    exit(0); 
  }
 
  /* initialize Pop3 */ 
  pc = pop3Create();    

  /* Set up timer for checking mail */ 
  startTime     = time(0);
  nextCheckTime = 0; /* Check for mail on startup */ 

  /* Load the pixmap */    
  createXBMfromXPM(wminet_mask_bits, wmpop3_xpm 
  		   , wminet_mask_width, wminet_mask_height); 
  openXwindow(argc, argv, wmpop3_xpm, wminet_mask_bits 
  	      , wminet_mask_width, wminet_mask_height); 
  AddMouseRegion(0, 18, 49, 45, 59 ); /* middle button (check-button) */ 
  AddMouseRegion(1, 5 , 49, 17, 59 ); /* left button (ac-button) */ 
  AddMouseRegion(2, 46, 49, 59, 59 ); /* right button (<>-button) */ 
  AddMouseRegion(3, 2, 2, 58, 33);    /* main area     */ 
  AddMouseRegion(4, 5, 46, 58, 56); 
  
  /* Check if Autochecking is on or off */ 
  if(conf.autoChecking == NO ){ 
    copyXPMArea(67, 7 ,4 ,4 ,52 ,7 );  
  } 
  
  RedrawWindow(); 

  /* get the display_name */
  for (i = 1; argv[i]; i++) {
	  if (!strcmp(argv[i], "-display")) {
		  display_name = argv[i+1];
		  break;
	  }
  }
  
  while(1) {
    /* still connected ? */
    temp_display = XOpenDisplay(display_name);
    if (!temp_display) {
      fprintf(stderr, "Lost the connection with the X server %s\n", XDisplayName(display_name));
      exit(1);
    }
    XCloseDisplay(temp_display);
    
    if( (((time(0) > nextCheckTime) || (nextCheckTime == 0)) 
	 && ( conf.autoChecking == YES))  
	|| (forcedCheck == YES)) {  
      /* Ok now we're about to check some mail */
      tempPopCnt = conf.nMailBoxes;
      nTotMail   = 0;
      if (conf.debug == YES)
	printf("Checking for mail...\n");
      /* Here we check the all the mailboxes, last one first */
      while ( tempPopCnt > 0 ) {
	tempPopCnt--;
	BlitString("Chk:     ", 5, (11*(4-1)) + 5); 
	BlitString(conf.c[tempPopCnt]->mailserverid, 33, (11*(4-1)) + 5); 
	RedrawWindow();
	
	if (conf.c[tempPopCnt]->popserver[0] == '/') {
	  snprintf( command, 1024, "%s%s%s", "exit `grep \"^From \" ",
	            conf.c[tempPopCnt]->popserver, " | wc -l`" );
	  num_msgs = WEXITSTATUS(system(command));
	  if (num_msgs < 0) {
	    num_msgs = 0;
	  }
	  conf.c[tempPopCnt]->nMsgs = num_msgs;
	  snprintf( command, 1024, "%s%s%s", "exit `grep \"^Status: R\" ",
	            conf.c[tempPopCnt]->popserver, " | wc -l`" );
	  read_msgs = WEXITSTATUS(system(command));
	  if (read_msgs < 0) { 
	    read_msgs = 0;
	  }
	  if (read_msgs > num_msgs) {
	    read_msgs = num_msgs;
	  }
	  conf.c[tempPopCnt]->nUnread = num_msgs - read_msgs;
	  nTotMail += conf.c[tempPopCnt]->nUnread;
	  if ((conf.c[tempPopCnt]->nMsgs > 0) || (conf.c[tempPopCnt]->nUnread > 0)) {
	    j = tempPopCnt;
	  }
	} else {
	  if (pop3MakeConnection(pc, conf.c[tempPopCnt]->popserver, conf.c[tempPopCnt]->port)==-1) {
	    mailWaiting = -1;
	    j = tempPopCnt;
	  } else if (pop3Login(pc, conf.c[tempPopCnt]->username,conf.c[tempPopCnt]->password) == -1) {
	    mailWaiting = -1;
	    j = tempPopCnt;
	  } else if ((pop3CheckMail(pc)) == -1) {
	    mailWaiting = -1;
	    j = tempPopCnt;
	  } else {
	    /* Now we can check if we got new mail */
	    conf.c[tempPopCnt]->nMsgs   = pop3GetNumberOfUnreadMessages(pc);
	    conf.c[tempPopCnt]->nUnread = pop3GetTotalNumberOfMessages(pc);
	    if (conf.viewUnread == YES) {
	      printf("Adding unread msgs....\n");
	      nTotMail = nTotMail + conf.c[tempPopCnt]->nUnread;
	    } else {
	      nTotMail = nTotMail + conf.c[tempPopCnt]->nMsgs;
	    }
	    if ((conf.c[tempPopCnt]->nMsgs > 0) || (conf.c[tempPopCnt]->nUnread > 0))
	      j = tempPopCnt;
	  }
	}
	if (conf.debug == YES) {
	  printf("Checking %s...%d/%d\n", conf.c[tempPopCnt]->popserver,
		 conf.c[tempPopCnt]->nMsgs,conf.c[tempPopCnt]->nUnread); 
	}
	pop3Quit(pc);
      }
      
      if (forcedCheck == YES) {
	forcedCheck = NO;
      }
      nextCheckTime = time(0) + (conf.mailCheckDelay * SEC_IN_MIN); 
      
      /* Can someone tell me if or why I need this line? (This was a comment from the author 
         of wmpop3). Seems to work on my system, mail (dss@home.se) if you want this uncommented */
      /* waitpid(0, NULL, WNOHANG); */

      if( mailWaiting == -1 ){ 
        /* Error connecting to pop server */ 
        BlitString("Err:  ", 5, (11*(4-1)) + 5); 
        BlitString(conf.c[j]->mailserverid, 33, (11*(4-1)) + 5); 
      } 

      /* Added by Roeland Huys 18/5/2002 */
      if (( nTotMail > nTotMail_last) && strlen(conf.mail_arrived_cmd)) {
	execCommand(conf.mail_arrived_cmd);
      }
      nTotMail_last = nTotMail;

      if (conf.debug == YES) {
	printf("%d new messages!\n", nTotMail);
      }

      BlitString("   :  /", 5, (11*(4-1)) + 5); 
      BlitString(conf.c[j]->mailserverid, 5, (11*(4-1)) + 5); 
      printf("nUnread == %d, nMsgs == %d\n", conf.c[j]->nUnread, conf.c[j]->nMsgs);
      if (conf.viewUnread == YES) {
	BlitNum(conf.c[j]->nUnread, 30, (11*(4-1)) + 5); 
      }	else {
	BlitNum(conf.c[j]->nMsgs, 30, (11*(4-1)) + 5); 
      }
      BlitNum(nTotMail, 45, (11*(4-1)) + 5); 

      /*      printf("nTotMail == %d\n", nTotMail);*/

      if( nTotMail > 0) {
        copyXPMArea(72, 2, 45, 28, 4, 4 ); 
	system(conf.run_command);
      } else {
	copyXPMArea(72, 33, 45, 28, 4, 4 );  
      } 
      RedrawWindow(); 
    } // if        
    
    /* X Events */ 
    while (XPending(display)){ 
      XNextEvent(display, &Event); 
      switch (Event.type) {
      case Expose: 
	RedrawWindow(); 
  	break; 
      case DestroyNotify: 
	XCloseDisplay(display); 
	exit(0); 
	break; 
      case ButtonPress: 
	buttonStatus = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y); 
	if ( buttonStatus >= 0 ){
	  switch (buttonStatus){
	  case 0 :
	    /* Presses check-button */
	    copyXPMArea(128,29 ,27 ,8 ,18 ,49 );
	    nextCheckTime = 0;
	    break;
	  case 1 : 
	    /* Ac-button */
	    copyXPMArea(128,16 ,11 ,8 ,6 ,49 );
	    break;
	  case 2: 
	    copyXPMArea(128,2 ,11 ,8 ,46 ,49 );
	    /* Change displayed mailbox */
	    if (j<(conf.nMailBoxes-1)) {
	      j++;
	    } else {
	      j=0;
	    }
	    BlitString("   :  /", 4, (11*(4-1)) + 5); 
	    BlitString(conf.c[j]->mailserverid, 5, (11*(4-1)) + 5); 
	    if (conf.viewUnread == YES) {
	      BlitNum(conf.c[j]->nUnread, 29, (11*(4-1)) + 5); 
	    } else {
	      BlitNum(conf.c[j]->nMsgs, 29, (11*(4-1)) + 5); 
	    }
  	    break; 
	    BlitNum(nTotMail, 45, (11*(4-1)) + 5); 
	  case 3:
	    switch (Event.xbutton.button) {
	    case 1: /* left mouse button */
	      execCommand(conf.mailclient);
	      break;
	    case 2: /* middle */
	      execCommand( conf.middle_click_cmd );
	      break;
	    case 3: /* right */
	      execCommand( conf.right_click_cmd );
	      break;
	    }
	    /* Recheck mail after 30 seconds,
	     * This gives time for the mail 
	     * browser to check the account  */
	    nextCheckTime = time(0) + 30;

	    break;
	  }
	}
	break;
      case ButtonRelease:
	i = CheckMouseRegion(Event.xbutton.x, Event.xbutton.y);
	
	if (buttonStatus == i && buttonStatus >= 0){
	  switch (buttonStatus){
	  case 0 :  
	    copyXPMArea(128,39 ,27 ,8 ,18 ,49 );
	    forcedCheck = YES;
	    break;
	  case 1 :  
	    copyXPMArea(144,16 ,11 ,8 ,5 ,49 );
	    if( conf.autoChecking == YES){
	      conf.autoChecking = NO;
	      /* Activate Red Led */
	      copyXPMArea(67, 7 ,4 ,4 ,52 ,7 ); 
	    }else{
	      /* Activate Green Led */
	      copyXPMArea(67, 2 ,4 ,4 ,52 ,7 ); 
	      conf.autoChecking = YES;
	    }
	    break;
	  case 2:
	    copyXPMArea(144,3 ,11 ,8 ,46 ,49 );
	    break;
	  case 3:
	    break;
	  }
	}
	buttonStatus = -1;
	RedrawWindow();
	break;
      default:
	//	printf("event type: %d\n", Event.type);
	break;
      } // switch
    } // while XEvent-loopen
    usleep(200000L);  /* 200ms */
    
  }  // While(1) 
  pop3Quit(pc);
}


/*
 * usage : Prints proper command parameters of wmpop3.
 */
void usage(void)
{
  fprintf(stderr, "\nwmMultiPop3 - Daniel Sundberg <dss@home.se>\n\n");
  fprintf(stderr, "Based on:\n");
  fprintf(stderr, "\nWMPop3 - Scott Holden <scotth@thezone.net>\n\n");
  fprintf(stderr, "usage:\n");
  fprintf(stderr, "    -display <display name>\n");
  fprintf(stderr, "    -geometry +XPOS+YPOS      initial window position\n");
  fprintf(stderr, "    -c <filename>             use specified config file\n");
  fprintf(stderr, "    -h                        this help screen\n");
  fprintf(stderr, "    -D                        print debug information\n");
  fprintf(stderr, "    -v                        print the version number\n");
  fprintf(stderr, "    -u                        view all msg:s including unread msg:s\n");
  fprintf(stderr, "\n");
}

/*
 * printversion : This function is used to print the version info
 *                to standard output.
 */
void printversion(void)
{
  fprintf(stderr, "wmMultiPop3 v%s\n", WMPOP3_VERSION);
}



int  readConfigFile(char *filename) {
  char buf[256];
  char *ptr = 0;
  FILE *fp;

  int popservers = 0;
  int usernames  = 0;
  int passwords  = 0;
  int ports      = 0;
  int ids        = 0;

  conf.nMailBoxes = 0;
  conf.c = (MailServerConf **)malloc(sizeof(MailServerConf));

  /* If we don't have a configfile, output a new one */
  if ( (fp = fopen( filename, "r" )) == 0) {
    snprintf(config_file, sizeof(config_file), "%s/.wmmultipop3rc", getenv("HOME"));
    printf("-Config file does not exit : %s\n",config_file);
    printf("+Trying to create new config file.\n");
    if ((fp = fopen(config_file,"w")) == 0) {
      printf("-Error creating new config file\n");
      return -1;
    }
    fprintf(fp, "# Replace all < > with appropriate data\n");
    fprintf(fp, "autochecking      1      # 1 == YES\n");
    fprintf(fp, "viewunread        1      # 1 == YES\n");
    fprintf(fp, "mailcheckdelay    10     # default mail check time in minutes\n");
    fprintf(fp, "mailclient        balsa  # this is the command you want to run on leftclick\n");
    fprintf(fp, "middle_click_cmd  balsa\n");
    fprintf(fp, "right_click_cmd   wmmultipop3cfg\n");
    fprintf(fp, "run_command       /bin/false\n\n");
    fprintf(fp, "[Mailserver 1]\n");
    fprintf(fp, "popserver         < pop3 server name >\n");
    fprintf(fp, "port              110    # default port\n");
    fprintf(fp, "username          < pop3 login name  >\n");
    fprintf(fp, "password          < pop3 password    >\n");
    fprintf(fp, "mailserverid      < mail server id string (3 chars) >\n");
    fprintf(fp, "#[Mailserver 2]\n");
    fprintf(fp, "#popserver         < pop3 server name >\n");
    fprintf(fp, "#port              110    # default port\n");
    fprintf(fp, "#username          < pop3 login name  >\n");
    fprintf(fp, "#password          < pop3 password    >\n");
    fprintf(fp, "#mailserverid      < mail server id string (3 chars) >\n");
    fprintf(fp, "# To use a local mailbox, set the file name as the pop server.\n");
    fprintf(fp, "# The port number, username and password are ignored.\n");
    fprintf(fp, "#[Mailserver 3]\n");
    fprintf(fp, "#popserver         /var/spool/mail/< your_user_name >\n");
    fprintf(fp, "#port              110    # default port\n");
    fprintf(fp, "#username          ignored\n");
    fprintf(fp, "#password          ignored\n");
    fprintf(fp, "#mailserverid      < mailbox id string (3 chars) >\n");
    fprintf(fp, "# Add other mail servers here if you want\n");
    printf("+New config file created : ~/.wmmultipop3rc\n\n");
    printf("+ ~/.wmmultipop3rc must be configured before running wmmultipop3.\n");
    fclose(fp);
    return -1;
    conf.mail_arrived_cmd[0]=0;
  }

  /*
   * Read the config-file
   */
  while ( fgets(buf, 256, fp) != 0) {
    ptr = strtok( buf, " \n" );
    
    /* Check if we have empty ptr or a comment */
    if ( (ptr != 0) && (ptr[0] != '#') && (ptr[0] != '[') ) {
      /* Check for global config options */
      if ( !strcmp(ptr, "autochecking") ) {
	ptr = strtok( 0, " \n");
	if ( ptr == 0 ) {
	  printf("Invalid autochecking option, sould be 1 or 0\n");
	  return -1;
	}
	conf.autoChecking = atoi(ptr);
      }
      if ( !strcmp(ptr, "viewunread") ) {
	ptr = strtok( 0, " \n");
	if ( ptr == 0 ) {
	  printf("Invalid viewunread option, sould be 1 or 0\n");
	  return -1;
	}
	conf.viewUnread = atoi(ptr);
      }
      if ( !strcmp(ptr, "mailcheckdelay") ) {
	ptr = strtok( 0, " \n");
	if ( ptr == 0 ) {
	  printf("Invalid autochecking option, sould be a number\n");
	  return -1;
	}
	conf.mailCheckDelay = atoi(ptr);
      }
      /* mailclient == eg. left click command */
      if ( !strcmp(ptr, "mailclient") ) {
	ptr = strtok( 0, "\n");
	if ( ptr == 0 ) {
	  printf("Error in mailclient string\n");
	  return -1;
	}
	strncpy(conf.mailclient, ptr, sizeof(conf.mailclient));
      }
      if ( !strcmp(ptr, "middle_click_cmd") ) {
	ptr = strtok( 0, "\n");
	if ( ptr == 0 ) {
	  printf("Error in middle_click_cmd string\n");
	  return -1;
	}
	strncpy(conf.middle_click_cmd, ptr, sizeof(conf.middle_click_cmd));
      }
      if ( !strcmp(ptr, "right_click_cmd") ) {
	ptr = strtok( 0, "\n");
	if ( ptr == 0 ) {
	  printf("Error in right_click_cmd string\n");
	  return -1;
	}
	strncpy(conf.right_click_cmd, ptr, sizeof(conf.right_click_cmd));
      }
      if ( !strcmp(ptr, "mail_arrived_cmd") ) {
	ptr = strtok( 0, "\n");
	if ( strlen(ptr)>(STR_LENGTH-1) )  {
	  printf("Error in mail_arrived_cmd string: maximum size is %d\n",STR_LENGTH-1);
	  return -1;
	}
	strcpy(conf.mail_arrived_cmd, ptr);
      }
      if ( !strcmp(ptr, "run_command") ) {
	ptr = strtok( 0, "\n");
	if ( ptr == 0 ) {
	  printf("Error in run_command string\n");
	  return -1;
	}
	strncpy(conf.run_command, ptr, sizeof(conf.run_command));
      }

      if ( !strcmp(ptr, "popserver") ) {
	ptr = strtok( 0, " \n");
	if ( ptr == 0 ) {
	  printf("Error in popserver string\n");
	  return -1;
	}
	/* create new struct, well "popserver" have to be first of new mailboxes for now */
	if (popservers > 0)
	  conf.c = (MailServerConf **)realloc(conf.c,(popservers+1)*sizeof(MailServerConf));
	conf.c[popservers]=(MailServerConf *)malloc(sizeof(MailServerConf));
	strncpy(conf.c[popservers]->popserver, ptr, sizeof(conf.c[popservers]->popserver));
	/*	conf.c[popservers]->nMailWaiting=0;*/
	popservers++;
      }
      if ( !strcmp(ptr, "port") ) {
	ptr = strtok( 0, " \n");
	if ( (ptr == 0) || (ports == popservers) ) {
	  printf("Error in mailserver port declaration\n");
	  return -1;
	}
	conf.c[ports]->port=atoi(ptr);
	ports++;
      }
      if ( !strcmp(ptr, "username") ) {
	ptr = strtok( 0, " \n");
	if ( (ptr == 0) || (usernames == popservers) ) {
	  printf("Error in username string\n");
	  return -1;
	}
	strncpy(conf.c[usernames]->username, ptr, sizeof(conf.c[usernames]->username));
	usernames++;
      }
      if ( !strcmp(ptr, "password") ) {
	ptr = strtok( 0, " \n");
	if ( (ptr == 0) || (passwords == popservers) ) {
	  printf("Error in password string\n");
	  return -1;
	}
	strncpy(conf.c[passwords]->password, ptr, sizeof(conf.c[passwords]->password));
	passwords++;
      }
      if ( !strcmp(ptr, "mailserverid") ) {
	ptr = strtok( 0, " \n");
	if ( (ptr == 0) || (ids == popservers) ) {
	  printf("Error in mail-server ID string\n");
	  return -1;
	}
	strncpy(conf.c[ids]->mailserverid, ptr, sizeof(conf.c[ids]->mailserverid));
	ids++;
      }
    }
  } //while
  
  /* If middle_click_cmd and right_click_cmd are not spcified we will set them 
     to mailclient (eg. left mouse click). This will preserve compability with 
     configfiles belonging to older versions of wmmultipop3 */
  if ( strlen( conf.middle_click_cmd ) < 1 ) {
    strncpy(conf.middle_click_cmd, conf.mailclient, sizeof(conf.middle_click_cmd));
  }
  if ( strlen( conf.right_click_cmd ) < 1 ) {
    strncpy(conf.right_click_cmd, conf.mailclient, sizeof(conf.right_click_cmd));
  }

  conf.nMailBoxes = popservers;
  if ((popservers+ports+usernames+passwords+ids)%5) {
    printf("Wrong number of one (or more) config options...\n");
    return -1;
  }
  fclose(fp);
  if (conf.debug == YES)
    printConfig(); //debug
  return 0;
}

/* Prints your config */
void printConfig(void) {
  int i;
  printf("Mailclient:               %s\n", conf.mailclient);
  printf("Right click               %s\n", conf.right_click_cmd);
  printf("Middle click              %s\n", conf.middle_click_cmd);
  printf("Mail arrived command      %s\n", conf.mail_arrived_cmd);
  printf("Autochecking:             %d\n", conf.autoChecking);
  printf("Mailcheckdelay:           %d\n", conf.mailCheckDelay);
  printf("Number of mailboxes:      %d\n", conf.nMailBoxes);
  printf("view unread messages:     %d\n", conf.viewUnread);
  for (i = 0; i < conf.nMailBoxes; i++) {
    printf("[Mailbox %d]\n", i+1);
    printf("Popserver:    %s\n", conf.c[i]->popserver);
    printf("Port:         %d\n", conf.c[i]->port);
    printf("Username:     %s\n", conf.c[i]->username);
    printf("Password:     xxxxxx\n");
    printf("MailserverID: %s\n", conf.c[i]->mailserverid);
  }
}

/*
 * Functions from wminet or something like that
 */

/* 
 * Blits a string at given co-ordinates
 */
void BlitString(char *name, int x, int y)
{
  int		i;
  int		c;
  int		k;

  k = x;
  for (i=0; name[i]; i++) {
    c = toupper(name[i]); 
    if (c >= 'A' && c <= 'Z') {   
      /* its a letter */
      c -= 'A';
      copyXPMArea(c * 6, 74, 6, 8, k, y);
      k += 6;
    } else if( c == ' ' ) {
      c = 14;
      copyXPMArea(73, 64, 6, 8, k, y);
      k += 6;
    } else if( c == '/' ) {
      c = 14;
      copyXPMArea(68, 64, 6, 8, k, y);
      k += 6;
    } else {   /* its a number or symbol */
      c -= '0';
      copyXPMArea(c * 6, 64, 6, 8, k, y);
      k += 6;
    }
  }
}


/* 
 * Blits number to give coordinates.. two 0's, right justified 
 */
void BlitNum(int num, int x, int y)
{
  char buf[1024];
  int newx=x;

  if (num > 99) {
    newx -= CHAR_WIDTH;
  } 
  
  if (num > 999) {
    newx -= CHAR_WIDTH;
  } 
  
  snprintf(buf, sizeof(buf), "%02i", num);
  
  BlitString(buf, newx, y);
}
