#!/usr/local/bin/perl
# list_access.cgi
# Display a list of all domain and address mappings

require './sendmail-lib.pl';
require './access-lib.pl';
$access{'access'} || &error($text{'access_ecannot'});
&header($text{'access_title'}, "");
print "<hr>\n";

$conf = &get_sendmailcf();
$afile = &access_file($conf);
($adbm, $adbmtype) = &access_dbm($conf);
if (!$adbm) {
	# No Kaccess directive in sendmail.cf
	print "<p><b>",$text{'access_econfig'},"</b> <p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
if (!-r $afile) {
	# Text file not found
	print "<p><b>",&text('access_efile', "<tt>$afile</tt>",
	      "<tt>$adbm</tt>", "/config.cgi?$module_name"),"</b> <p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
@accs = &list_access($afile);

&access_form();
if (@accs) {
	# sort if needed
	if ($config{'sort_mode'} == 1) {
		@accs = sort { $a->{'from'} cmp $b->{'from'} } @accs;
		}

	# render table of access rules
	$mid = int((@accs+1)/2);
	print "<table width=100%> <tr><td width=50% valign=top>\n";
	&accs_table(@accs[0..$mid-1]);
	print "</td><td width=50% valign=top>\n";
	if ($mid < @accs) { &accs_table(@accs[$mid..$#accs]); }
	print "</td></tr> </table><br>\n";
	}
print "<a href='edit_file.cgi?mode=access'>",
	&text('file_edit', "<tt>$afile</tt>"),"</a><p>\n";
print $text{'access_desc1'},"<p>\n";
print $text{'access_desc2'},"<br>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

sub accs_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'access_source'}</b></td> ",
      "<td><b>$text{'access_action'}</b></td> </tr>\n";
foreach $m (@_) {
	print "<tr $cb> <td><a href=\"edit_access.cgi?num=$m->{'num'}\">",
	      "$m->{'from'}</a></td>\n";
	print "<td>$m->{'action'}</td> </tr>\n";
	}
print "</table>\n";
}

