#!/usr/local/bin/perl
# autoreply.pl
# Simple autoreply script

# read sendmail module config
$p = -l $0 ? readlink($0) : $0;
$p =~ /^(.*)\/[^\/]+$/;
open(CONF, "$1/config");
while(<CONF>) {
	if (/^(\S+)=(.*)/) {
		$config{$1} = $2;
		}
	}
close(CONF);

# read headers
while(<STDIN>) {
	s/\r|\n//g;
	if (/^(\S+):\s+(.*)/) {
		$header{lc($1)} = $2;
		}
	elsif (!$_) { last; }
	}
while(<STDIN>) {
	$body .= $_;
	}

# run sendmail to reply
open(MAIL, "|$config{'sendmail_path'} -t");
print MAIL "From: $header{'to'}\n";
if ($header{'reply-to'}) {
	print MAIL "To: $header{'reply-to'}\n";
	}
else {
	print MAIL "To: $header{'from'}\n";
	}
print MAIL "Subject: Autoreply to $header{'subject'}\n";
print MAIL "\n";
open(AUTO, $ARGV[0]);
while(<AUTO>) {
	s/\$SUBJECT/$header{'subject'}/g;
	s/\$FROM/$header{'from'}/g;
	s/\$TO/$header{'to'}/g;
	s/\$DATE/$header{'date'}/g;
	s/\$BODY/$body/g;
	print MAIL $_;
	}
close(AUTO);
close(MAIL);

