#!/usr/local/bin/perl
# list_users.cgi
# Lists all the users with quotas on some filesystem

require './quota-lib.pl';
$f = $ARGV[0];
$whatfailed = $text{'lusers_failed'};
&can_edit_filesys($f) ||
	&error($text{'lusers_eallow'});

# List quotas
&header($text{'lusers_title'}, "", "list_users");
print "<hr>\n";
$n = &filesystem_users($f);
if ($n > $config{'display_max'}) {
	print "<b>", &text('lusers_toomany', $f), "</b><br>\n";
	}
elsif ($n) {
	print "<h3>",&text('lusers_qoutas', $f),"</h3>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><br></td>\n";
	@fs = &free_space($f);
	print "<td colspan=3 align=center><b>$text{'lusers_blocks'}</b>\n";
	print "&nbsp;&nbsp;&nbsp; ($fs[0] total / $fs[1] free)\n"
		if ($access{'diskspace'});
	print "</td> <td colspan=3 align=center><b>$text{'lusers_files'}</b>\n";
	print "&nbsp;&nbsp;&nbsp; ($fs[2] total / $fs[3] free)\n"
		if ($access{'diskspace'});
	print "</td> </tr>\n";
	print "<tr $tb> <td><b>$text{'lusers_user'}</b></td>\n";
	print "<td><b>$text{'lusers_used'}</b></td> <td><b>$text{'lusers_soft'}</b></td>\n";
	print "<td><b>$text{'lusers_hard'}</b></td>\n";
	print "<td><b>$text{'lusers_used'}</b></td> <td><b>$text{'lusers_soft'}</b></td>\n";
	print "<td><b>$text{'lusers_hard'}</b></td> </tr>\n";
	@order = (0 .. $n-1);
	@order = sort { $user{$b,'ublocks'} <=> $user{$a,'ublocks'} } @order;
	foreach $i (@order) {
		next if (!&can_edit_user($user{$i,'user'}));
		print "<tr $cb>\n";
		print "<td><a href=\"edit_user_quota.cgi?user=$user{$i,'user'}",
		      "&filesys=$f&source=0\">$user{$i,'user'}</a></td>\n";
		print "<td>$user{$i,'ublocks'}</td>\n";
		&print_limit($user{$i,'sblocks'});
		&print_limit($user{$i,'hblocks'});
		print "<td>$user{$i,'ufiles'}</td>\n";
		&print_limit($user{$i,'sfiles'});
		&print_limit($user{$i,'hfiles'});
		print "</tr>\n";
		}
	print "</table><br>\n";
	}
else {
	print "<b>$text{'lusers_noquota'}<tt>$f</tt></b><br>\n";
	}

print "<table width=100%><tr>\n";
print "<form action=edit_user_quota.cgi>\n";
print "<input type=hidden name=filesys value=\"$f\">\n";
print "<input type=hidden name=source value=0>\n";
print "<td align=left width=33%>\n";
print "<input type=submit value=\"$text{'lusers_equota'}\">\n";
print "<input name=user size=8> ",
      &user_chooser_button("user", 0),"</td></form>\n";

if ($access{'ugrace'}) {
	print "<form action=user_grace_form.cgi>\n";
	print "<input type=hidden name=filesys value=\"$f\">\n";
	print "<td align=center width=33%>\n";
	print "<input type=submit value=\"$text{'lusers_egrace'}\">\n";
	print "</td></form>\n";
	}
else { print "<td width=33%></td>\n"; }

print "<form action=check_quotas.cgi>\n";
print "<input type=hidden name=filesys value=\"$f\">\n";
print "<input type=hidden name=source value=user>\n";
print "<td align=right width=33%><input type=submit value=\"$text{'lusers_check'}\">\n";
print "</td></form> </tr></table>\n";

if ($access{'default'}) {
	print "<hr>\n";
	print &text('lusers_info', $text{'lusers_useradmin'});
	print "<p>\n";

	@dquot = split(/\s+/, $config{"sync_$f"});
	print "<form action=save_sync.cgi>\n";
	print "<input type=hidden name=filesys value=\"$f\">\n";
	print "<table width=100% border> <tr $tb>\n";
	print "<td colspan=2><b>$text{'lusers_newuser'}</b></td> </tr> <tr $cb>\n";

	print "<td width=50%><table><tr>\n";
	print "<td><b>$text{'lusers_sblimit'}</b></td> <td>\n";
	&quota_input("sblocks", $dquot[0]);
	print "</td> </tr><tr> <td><b>$text{'lusers_hblimit'}</b></td> <td>\n";
	&quota_input("hblocks", $dquot[1]);
	print "</td> </tr></table></td>\n";

	print "<td width=50%><table><tr>\n";
	print "<td><b>$text{'lusers_sflimit'}</b></td> <td>\n";
	&quota_input("sfiles", $dquot[2]);
	print "</td> </tr><tr> <td><b>$text{'lusers_hflimit'}</b></td> <td>\n";
	&quota_input("hfiles", $dquot[3]);
	print "</td> </tr></table></td>\n";
	print "</tr> </table><p>\n";
	print "<input type=submit value=$text{'lusers_apply'}></form>\n";
	}

print "<hr>\n";
&footer("", $text{'lusers_return'});

sub print_limit
{
if ($_[0] == 0) { print "<td>$text{'quota_unlimited'}</td>\n"; }
else { print "<td>$_[0]</td>\n"; }
}

