#!/usr/local/bin/perl
# list_groups.cgi
# Lists all the groups with quotas on some filesystem

require './quota-lib.pl';
$f = $ARGV[0];
$whatfailed = $text{'lgroups_failed'};
&can_edit_filesys($f) ||
	&error($text{'lgroups_eallow'});

# List quotas
&header($text{'lgroups_title'}, "", "list_groups");
print "<hr>\n";
$n = &filesystem_groups($f);
if ($n > $config{'display_max'}) {
	print "<b>",&text('lgroups_toomany', $f),"</b><br>\n";
	}
elsif ($n) {
	print "<h3>",&text('lgroups_quotas', $ff),"</h3>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td></td>\n";
	@fs = &free_space($f);
	print "<td colspan=3 align=center><b>$text{'lgroups_blocks'}</b>\n";
	print "&nbsp;&nbsp;&nbsp; ($fs[0] total / $fs[1] free)\n"
		if ($access{'diskspace'});
	print "</td> <td colspan=3 align=center><b>$text{'lgroups_files'}</b>\n";
	print "&nbsp;&nbsp;&nbsp; ($fs[2] total / $fs[3] free)\n"
		if ($access{'diskspace'});
	print "</td> </tr>\n";
	print "<tr $tb> <td><b>$text{'lgroups_group'}</b></td>\n";
	print "<td><b>$text{'lgroups_used'}</b></td> <td><b>$text{'lgroups_soft'}</b></td>\n";
	print "<td><b>$text{'lgroups_hard'}</b></td>\n";
	print "<td><b>$text{'lgroups_used'}</b></td> <td><b>$text{'lgroups_soft'}</b></td>\n";
	print "<td><b>$text{'lgroups_hard'}</b></td> </tr>\n";
	@order = (0 .. $n-1);
	@order = sort { $group{$b,'ublocks'} <=> $group{$a,'ublocks'} } @order;
	foreach $i (@order) {
		next if (!&can_edit_group($group{$i,'group'}));
		print "<tr $cb>\n";
		print "<td><a href=\"edit_group_quota.cgi?group=$group{$i,'group'}",
		      "&filesys=$f&source=0\">$group{$i,'group'}</a></td>\n";
		print "<td>$group{$i,'ublocks'}</td>\n";
		&print_limit($group{$i,'sblocks'});
		&print_limit($group{$i,'hblocks'});
		print "<td>$group{$i,'ufiles'}</td>\n";
		&print_limit($group{$i,'sfiles'});
		&print_limit($group{$i,'hfiles'});
		print "</tr>\n";
		}
	print "</table><br>\n";
	}
else {
	print "<b>&text('lgroups_noquota', $f)</b><br>\n";
	}

print "<table width=100%><tr>\n";
print "<form action=edit_group_quota.cgi>\n";
print "<input type=hidden name=filesys value=\"$f\">\n";
print "<input type=hidden name=source value=0>\n";
print "<td align=left width=33%>\n";
print "<input type=submit value=\"$text{'lgroups_equota'}\">\n";
print "<input name=group size=8> ",
      &group_chooser_button("group",0),"</td></form>\n";

if ($access{'ggrace'}) {
	print "<form action=group_grace_form.cgi>\n";
	print "<input type=hidden name=filesys value=\"$f\">\n";
	print "<td align=center width=33%>\n";
	print "<input type=submit value=\"$text{'lgroups_grace'}\">\n";
	print "</td></form>\n";
	}
else { print "<td width=33%></td>\n"; }

print "<form action=check_quotas.cgi>\n";
print "<input type=hidden name=filesys value=\"$f\">\n";
print "<input type=hidden name=source value=group>\n";
print "<td align=right width=33%><input type=submit value=\"$text{'lgroups_check'}\">\n";
print "</td></form> </tr></table>\n";

print "<hr>\n";
&footer("", $text{'lgroups_return'});

sub print_limit
{
if ($_[0] == 0) { print "<td>$text{'quota_unlimited'}</td>\n"; }
else { print "<td>$_[0]</td>\n"; }
}

