
require './quota-lib.pl';

# acl_security_form(&options)
# Output HTML for editing security options for the quota module
sub acl_security_form
{
local $groups = &quotas_supported() >= 2;

print "<tr> <td valign=top><b>$text{'acl_fss'}</b></td>\n";
print "<td colspan=3><select width=150 name=filesys multiple size=3>\n";
local ($f, %qcan);
map { $qcan{$_}++ } split(/\s+/, $_[0]->{'filesys'});
foreach $f (&list_filesystems()) {
	if ($f->[4]) {
		printf "<option %s>%s\n",
			$qcan{$f->[0]} || $qcan{'*'} ? "selected" : "", $f->[0];
		}
	}
print "</select></td> </tr>\n";

print "<tr> <td colspan=4><hr></td> </tr>\n";

print "<tr> <td><b>$text{'acl_quotaon'}</b></td> <td>\n";
printf "<input type=radio name=enable value=1 %s> $text{'yes'}\n",
	$_[0]->{'enable'} ? "checked" : "";
printf "<input type=radio name=enable value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'enable'} ? "" : "checked";

print "<td><b>$text{'acl_quotanew'}</b></td> <td>\n";
printf "<input type=radio name=default value=1 %s> $text{'yes'}\n",
	$_[0]->{'default'} ? "checked" : "";
printf "<input type=radio name=default value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'default'} ? "" : "checked";

print "<tr> <td><b>$text{'acl_ugrace'}</b></td> <td>\n";
printf "<input type=radio name=ugrace value=1 %s> $text{'yes'}\n",
	$_[0]->{'ugrace'} ? "checked" : "";
printf "<input type=radio name=ugrace value=0 %s> $text{'no'}</td>\n",
	$_[0]->{'ugrace'} ? "" : "checked";

print "<td><b>$text{'acl_vtotal'}</b></td> <td>\n";
printf "<input type=radio name=diskspace value=1 %s> $text{'yes'}\n",
	$_[0]->{'diskspace'} ? "checked" : "";
printf "<input type=radio name=diskspace value=0 %s> $text{'no'}</td> </tr>\n",
	$_[0]->{'diskspace'} ? "" : "checked";

if ($groups) {
	print "<td><b>$text{'acl_ggrace'}</b></td> <td>\n";
	printf "<input type=radio name=ggrace value=1 %s> $text{'yes'}\n",
		$_[0]->{'ggrace'} ? "checked" : "";
	printf "<input type=radio name=ggrace value=0 %s> $text{'no'}</td> </tr>\n",
		$_[0]->{'ggrace'} ? "" : "checked";
	}

print "<tr> <td colspan=4><hr></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'acl_uquota'}",
      "</b></td> <td colspan=3>\n";
printf "<input type=radio name=umode value=0 %s>$text{'acl_uall'}<br>\n",
	$_[0]->{'umode'} == 0 ? "checked" : "";
printf "<input type=radio name=umode value=1 %s>$text{'acl_uonly'}\n",
	$_[0]->{'umode'} == 1 ? "checked" : "";
printf "<input name=ucan size=40 value='%s'> %s<br>\n",
	$_[0]->{'umode'} == 1 ? $_[0]->{'users'} : "",
	&user_chooser_button("ucan", 1);
printf "<input type=radio name=umode value=2 %s>$text{'acl_uexcept'}\n",
	$_[0]->{'umode'} == 2 ? "checked" : "";
printf "<input name=ucannot size=40 value='%s'> %s<br>\n",
	$_[0]->{'umode'} == 2 ? $_[0]->{'users'} : "",
	&user_chooser_button("ucannot", 1);
printf "<input type=radio name=umode value=3 %s>$text{'acl_ugroup'}\n",
	$_[0]->{'umode'} == 3 ? "checked" : "";
printf "<input name=upri size=8 value='%s'> %s</td> </tr>\n",
	$_[0]->{'umode'} == 3 ? scalar(getgrgid($_[0]->{'users'})) : "",
	&group_chooser_button("upri", 0);

if ($groups) {
	print "<tr> <td colspan=4><hr></td> </tr>\n";

	print "<tr> <td valign=top><b>$text{'acl_gquota'}",
	      "</b></td> <td colspan=3>\n";
	printf "<input type=radio name=gmode value=0 %s>$text{'acl_gall'}<br>\n",
		$_[0]->{'gmode'} == 0 ? "checked" : "";
	printf "<input type=radio name=gmode value=3 %s>$text{'acl_gnone'}<br>\n",
		$_[0]->{'gmode'} == 3 ? "checked" : "";
	printf "<input type=radio name=gmode value=1 %s>$text{'acl_gonly'}\n",
		$_[0]->{'gmode'} == 1 ? "checked" : "";
	printf "<input name=gcan size=40 value='%s'> %s<br>\n",
		$_[0]->{'gmode'} == 1 ? $_[0]->{'groups'} : "",
		&group_chooser_button("gcan", 1);
	printf "<input type=radio name=gmode value=2 %s>$text{'acl_gexcept'}\n",
		$_[0]->{'gmode'} == 2 ? "checked" : "";
	printf "<input name=gcannot size=40 value='%s'> %s</td> </tr>\n",
		$_[0]->{'gmode'} == 2 ? $_[0]->{'groups'} : "",
		&group_chooser_button("gcannot", 1);
	}
}

# acl_security_save(&options)
# Parse the form for security options for the quota module
sub acl_security_save
{
local $q = 0;
map { $q++ if ($_->[4]) } &list_filesystems();
local @sel = split(/\0/, $in{'filesys'});
if (@sel == $q) {
	$_[0]->{'filesys'} = "*";
	}
else {
	$_[0]->{'filesys'} = join(" ", @sel);
	}
$_[0]->{'umode'} = $in{'umode'};
$_[0]->{'users'} = $in{'umode'} == 0 ? "" :
		   $in{'umode'} == 1 ? $in{'ucan'} :
		   $in{'umode'} == 2 ? $in{'ucannot'} :
				       scalar(getgrnam($in{'upri'}));
$_[0]->{'gmode'} = $in{'gmode'};
$_[0]->{'groups'} = $in{'gmode'} == 0 ? "" :
		    $in{'gmode'} == 1 ? $in{'gcan'} : $in{'gcannot'};
$_[0]->{'enable'} = $in{'enable'};
$_[0]->{'default'} = $in{'default'};
$_[0]->{'ugrace'} = $in{'ugrace'};
$_[0]->{'ggrace'} = $in{'ggrace'};
$_[0]->{'diskspace'} = $in{'diskspace'};
}

